/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.network;

import cn.leancloud.core.AppConfiguration;
import cn.leancloud.utils.StringUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DNSDetoxicant
implements Dns {
    static final long TWENTY_MIN_IN_MILLS = 1200000L;
    static final String AVOS_SERVER_HOST_ZONE = "avoscloud_server_host_zone";
    public static final String EXPIRE_TIME = ".expireTime";
    static final String DNSPOD_HOST = System.getProperty("dnspodHost", "119.29.29.29");
    private static final int DNS_REQUEST_TIME_OUT = 2000;

    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        if (StringUtil.isEmpty(hostname)) {
            throw new UnknownHostException("hostname is empty");
        }
        try {
            InetAddress[] addresses = InetAddress.getAllByName(hostname);
            return Arrays.asList(addresses);
        }
        catch (UnknownHostException e) {
            try {
                boolean isCacheValid;
                String response = this.getCacheDNSResult(hostname);
                boolean bl = isCacheValid = !StringUtil.isEmpty(response);
                if (!isCacheValid) {
                    response = DNSDetoxicant.getIPByHostSync(hostname);
                }
                InetAddress[] addresses = DNSDetoxicant.getIPAddress(hostname, response);
                if (!isCacheValid) {
                    this.cacheDNS(hostname, response);
                }
                return Arrays.asList(addresses);
            }
            catch (Exception e1) {
                throw new UnknownHostException();
            }
        }
    }

    public static String getIPByHostSync(String host) throws Exception {
        HttpUrl httpUrl = new HttpUrl.Builder().scheme("http").host(DNSPOD_HOST).addPathSegment("d").addQueryParameter("dn", host).build();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(2000L, TimeUnit.MILLISECONDS);
        builder.dns(Dns.SYSTEM);
        OkHttpClient okHttpClient = builder.build();
        Request request = new Request.Builder().url(httpUrl).get().build();
        try {
            Response response = okHttpClient.newCall(request).execute();
            if (null != response && response.isSuccessful()) {
                return response.body().string();
            }
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    private void cacheDNS(String host, String response) {
        AppConfiguration.getDefaultSetting().saveString(AVOS_SERVER_HOST_ZONE, host, response);
        AppConfiguration.getDefaultSetting().saveString(AVOS_SERVER_HOST_ZONE, host + EXPIRE_TIME, String.valueOf(System.currentTimeMillis() + 1200000L));
    }

    private String getCacheDNSResult(String url) {
        String response = AppConfiguration.getDefaultSetting().getString(AVOS_SERVER_HOST_ZONE, url, null);
        String expiredAt = AppConfiguration.getDefaultSetting().getString(AVOS_SERVER_HOST_ZONE, url + EXPIRE_TIME, "0");
        if (!StringUtil.isEmpty(response) && System.currentTimeMillis() < Long.parseLong(expiredAt)) {
            return response;
        }
        return null;
    }

    private static InetAddress[] getIPAddress(String url, String response) throws Exception {
        String[] ips = response.split(";");
        InetAddress[] addresses = new InetAddress[ips.length];
        Constructor constructor = InetAddress.class.getDeclaredConstructor(Integer.TYPE, byte[].class, String.class);
        constructor.setAccessible(true);
        for (int i = 0; i < ips.length; ++i) {
            String ip = ips[i];
            String[] ipSegment = ip.split("\\.");
            if (ipSegment.length != 4) continue;
            byte[] ipInBytes = new byte[]{(byte)Integer.parseInt(ipSegment[0]), (byte)Integer.parseInt(ipSegment[1]), (byte)Integer.parseInt(ipSegment[2]), (byte)Integer.parseInt(ipSegment[3])};
            addresses[i] = (InetAddress)constructor.newInstance(2, ipInBytes, url);
        }
        return addresses;
    }
}

