/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.cache;

import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class LocalStorage {
    private String baseDir;
    private boolean disableLocalCache = false;

    public LocalStorage(String baseDir) {
        if (StringUtil.isEmpty(baseDir)) {
            this.disableLocalCache = true;
        } else {
            File root;
            if (!baseDir.endsWith("/")) {
                baseDir = baseDir + "/";
            }
            if (!(root = new File(baseDir)).exists()) {
                root.mkdirs();
            }
            this.baseDir = baseDir;
        }
    }

    public String saveData(String key, byte[] content) {
        if (this.disableLocalCache) {
            return null;
        }
        if (StringUtil.isEmpty(key) || null == content) {
            return null;
        }
        String path = this.baseDir + key;
        PersistenceUtil.sharedInstance().saveContentToFile(content, new File(path));
        return path;
    }

    public String saveFile(String key, File localFile) {
        if (this.disableLocalCache) {
            return null;
        }
        if (StringUtil.isEmpty(key)) {
            return null;
        }
        if (null == localFile || !localFile.exists() || !localFile.isFile()) {
            return null;
        }
        String path = this.baseDir + key;
        boolean saveResult = PersistenceUtil.sharedInstance().saveFileToLocal(path, localFile);
        if (saveResult) {
            return path;
        }
        return null;
    }

    public byte[] readData(String key) {
        if (this.disableLocalCache) {
            return null;
        }
        if (StringUtil.isEmpty(key)) {
            return null;
        }
        String path = this.baseDir + key;
        return this.readData(new File(path));
    }

    public byte[] readData(File file) {
        if (this.disableLocalCache) {
            return null;
        }
        return PersistenceUtil.sharedInstance().readContentBytesFromFile(file);
    }

    public File getCacheFile(String key) {
        if (this.disableLocalCache) {
            return null;
        }
        if (StringUtil.isEmpty(key)) {
            return null;
        }
        return new File(this.baseDir + key);
    }

    public InputStream getInputStreamFromFile(File file) throws FileNotFoundException {
        if (this.disableLocalCache) {
            return null;
        }
        return new FileInputStream(file);
    }

    public void clearCachedFile(String key) {
        if (this.disableLocalCache || StringUtil.isEmpty(key)) {
            return;
        }
        String path = this.baseDir + key;
        PersistenceUtil.sharedInstance().deleteFile(path);
    }

    public void clearAllCachedFiles() {
        if (this.disableLocalCache) {
            return;
        }
        this.clearCacheMoreThanDays(0);
    }

    public void clearCacheMoreThanDays(int days) {
        if (this.disableLocalCache) {
            return;
        }
        long curTime = System.currentTimeMillis();
        if (days > 0) {
            curTime -= 86400000L * (long)days;
        }
        PersistenceUtil.sharedInstance().clearDir(this.baseDir, curTime);
    }
}

