/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVQuery;
import cn.leancloud.callback.SendCallback;
import cn.leancloud.core.PaasClient;
import cn.leancloud.utils.AVUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AVPush {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVPush.class);
    private static final String deviceTypeTag = "deviceType";
    private static final Set<String> DEVICE_TYPES = new HashSet<String>();
    private static final String FlowControlTag = "flow_control";
    private static final int FlowControlMinValue = 1000;
    private final Set<String> channelSet = new HashSet<String>();
    private AVQuery<? extends AVInstallation> pushQuery;
    private String cql;
    private long expirationTime;
    private long expirationTimeInterval;
    private final Set<String> pushTarget;
    private final Map<String, Object> pushData = new HashMap<String, Object>();
    private volatile AVObject notification;
    private Date pushDate = null;
    private int flowControl = 0;

    public AVPush() {
        this.pushTarget = new HashSet<String>(DEVICE_TYPES);
        this.pushQuery = AVInstallation.getQuery();
    }

    public Set<String> getChannelSet() {
        return this.channelSet;
    }

    public AVObject getNotification() {
        return this.notification;
    }

    public AVQuery<? extends AVInstallation> getPushQuery() {
        return this.pushQuery;
    }

    public Date getPushDate() {
        return this.pushDate;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public long getExpirationTimeInterval() {
        return this.expirationTimeInterval;
    }

    public Set<String> getPushTarget() {
        return this.pushTarget;
    }

    public Map<String, Object> getPushData() {
        return this.pushData;
    }

    public int getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(int flowControl) {
        if (flowControl < 1000) {
            flowControl = 1000;
        }
        this.flowControl = flowControl;
    }

    public void setChannel(String channel) {
        this.channelSet.clear();
        this.channelSet.add(channel);
    }

    public void setChannels(Collection<String> channels) {
        this.channelSet.clear();
        this.channelSet.addAll(channels);
    }

    public void setData(Map<String, Object> data) {
        this.pushData.put("data", data);
    }

    public void setData(JSONObject data) {
        try {
            HashMap map = new HashMap();
            for (Map.Entry entry : data.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            this.pushData.put("data", map);
        }
        catch (Exception exception) {
            LOGGER.w(exception);
        }
    }

    private Date expirationDateTime() {
        return new Date(this.expirationTime);
    }

    public void setPushDate(Date date) {
        this.pushDate = date;
    }

    public void setExpirationTime(long time) {
        this.expirationTime = time;
    }

    public void setExpirationTimeInterval(long timeInterval) {
        this.expirationTimeInterval = timeInterval;
    }

    public void setMessage(String message) {
        this.pushData.clear();
        Map<String, Object> map = AVUtils.createStringObjectMap("alert", message);
        this.pushData.put("data", map);
    }

    public void setPushToAndroid(boolean pushToAndroid) {
        if (pushToAndroid) {
            this.pushTarget.add("android");
        } else {
            this.pushTarget.remove("android");
        }
    }

    public void setPushToIOS(boolean pushToIOS) {
        if (pushToIOS) {
            this.pushTarget.add("ios");
        } else {
            this.pushTarget.remove("ios");
        }
    }

    public void setPushToWindowsPhone(boolean pushToWP) {
        if (pushToWP) {
            this.pushTarget.add("wp");
        } else {
            this.pushTarget.remove("wp");
        }
    }

    public void setQuery(AVQuery<? extends AVInstallation> query) {
        this.pushQuery = query;
    }

    public void setCloudQuery(String cql) {
        this.cql = cql;
    }

    public void clearExpiration() {
        this.expirationTime = 0L;
        this.expirationTimeInterval = 0L;
    }

    public void send() {
        this.sendInBackground().blockingFirst();
    }

    public Observable<JSONObject> sendInBackground() {
        try {
            Map<String, Object> map = this.postDataMap();
            return PaasClient.getPushClient().sendPushRequest(map);
        }
        catch (Exception ex) {
            return Observable.error((Throwable)ex);
        }
    }

    private Map<String, Object> pushChannelsData() {
        return AVUtils.createStringObjectMap("channels", this.channelSet);
    }

    private Map<String, Object> postDataMap() throws AVException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.pushQuery != null) {
            if (this.pushTarget.size() == 0) {
                this.pushQuery.whereNotContainedIn(deviceTypeTag, DEVICE_TYPES);
            } else if (this.pushTarget.size() == 1) {
                this.pushQuery.whereEqualTo(deviceTypeTag, this.pushTarget.toArray()[0]);
            }
            Map<String, String> pushParameters = this.pushQuery.assembleParameters();
            if (pushParameters.keySet().size() > 0 && !StringUtil.isEmpty(this.cql)) {
                throw new IllegalStateException("You can't use AVQuery and Cloud query at the same time.");
            }
            for (Map.Entry<String, String> entry : pushParameters.entrySet()) {
                map.put(entry.getKey(), JSON.parse((String)entry.getValue()));
            }
        }
        if (!StringUtil.isEmpty(this.cql)) {
            map.put("cql", this.cql);
        }
        if (this.channelSet.size() > 0) {
            map.putAll(this.pushChannelsData());
        }
        if (this.expirationTime > 0L) {
            map.put("expiration_time", this.expirationDateTime());
        }
        if (this.expirationTimeInterval > 0L) {
            map.put("push_time", StringUtil.stringFromDate(new Date()));
            map.put("expiration_interval", this.expirationTimeInterval);
        }
        if (this.pushDate != null) {
            map.put("push_time", StringUtil.stringFromDate(this.pushDate));
        }
        if (this.flowControl > 0) {
            map.put(FlowControlTag, this.flowControl);
        }
        map.putAll(this.pushData);
        return map;
    }

    public void sendInBackground(final SendCallback callback) {
        this.sendInBackground().subscribe((Observer)new Observer<JSONObject>(){

            public void onSubscribe(Disposable disposable) {
            }

            public void onNext(JSONObject jsonObject) {
                AVPush.this.notification = new AVObject("_Notification");
                AVPush.this.notification.resetServerData(jsonObject.getInnerMap());
                if (null != callback) {
                    callback.internalDone(null);
                }
            }

            public void onError(Throwable throwable) {
                if (null != callback) {
                    callback.internalDone(new AVException(throwable));
                }
            }

            public void onComplete() {
            }
        });
    }

    public static void sendDataInBackground(JSONObject data, AVQuery<? extends AVInstallation> query, SendCallback callback) {
        AVPush push = new AVPush();
        push.setData(data);
        push.setQuery(query);
        push.sendInBackground(callback);
    }

    public static Observable<JSONObject> sendDataInBackground(JSONObject data, AVQuery<? extends AVInstallation> query) {
        AVPush push = new AVPush();
        push.setData(data);
        push.setQuery(query);
        return push.sendInBackground();
    }

    public static Observable<JSONObject> sendMessageInBackground(String message, AVQuery<? extends AVInstallation> query) {
        AVPush push = new AVPush();
        push.setMessage(message);
        push.setQuery(query);
        return push.sendInBackground();
    }

    public static void sendMessageInBackground(String message, AVQuery<? extends AVInstallation> query, SendCallback callback) {
        AVPush push = new AVPush();
        push.setMessage(message);
        push.setQuery(query);
        push.sendInBackground(callback);
    }

    static {
        DEVICE_TYPES.add("android");
        DEVICE_TYPES.add("ios");
    }
}

