/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.ops;

import cn.leancloud.AVObject;
import cn.leancloud.ops.BaseOperation;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.ops.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CompoundOperation
extends BaseOperation {
    private List<ObjectFieldOperation> operations = new LinkedList<ObjectFieldOperation>();

    public CompoundOperation(String field) {
        super("Compound", field, null, false);
    }

    public CompoundOperation(String field, ObjectFieldOperation ... ops) {
        this(field);
        this.operations.addAll(Arrays.asList(ops));
    }

    public List<ObjectFieldOperation> getSubOperations() {
        return this.operations;
    }

    @Override
    public boolean checkCircleReference(Map<AVObject, Boolean> markMap) {
        boolean result = false;
        for (ObjectFieldOperation op : this.operations) {
            result = result || op.checkCircleReference(markMap);
        }
        return result;
    }

    @Override
    public Object apply(Object obj) {
        for (ObjectFieldOperation op : this.operations) {
            obj = op.apply(obj);
        }
        return obj;
    }

    @Override
    protected ObjectFieldOperation mergeWithPrevious(ObjectFieldOperation previous) {
        this.operations.add(previous);
        return this;
    }

    public List<Map<String, Object>> encodeRestOp(AVObject parent) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (null == parent) {
            return result;
        }
        String requestEndPoint = parent.getRequestRawEndpoint();
        String requestMethod = parent.getRequestMethod();
        for (int i = 1; i < this.operations.size(); ++i) {
            ObjectFieldOperation tmp = this.operations.get(i);
            Map<String, Object> tmpOp = tmp.encode();
            Map<String, Object> tmpResult = Utils.makeCompletedRequest(parent.getObjectId(), requestEndPoint, requestMethod, tmpOp);
            if (null == tmpResult) continue;
            result.add(tmpResult);
        }
        return result;
    }

    private Map<String, Object> encodeHeadOp() {
        if (this.operations.size() < 1) {
            return null;
        }
        return this.operations.get(0).encode();
    }

    @Override
    public Map<String, Object> encode() {
        return this.encodeHeadOp();
    }
}

