/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVObject;
import cn.leancloud.AVQuery;
import cn.leancloud.Transformer;
import cn.leancloud.ops.Utils;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Collection;
import java.util.HashMap;

public class AVRelation<T extends AVObject> {
    private String key;
    @JSONField(serialize=false)
    private AVObject parent;
    private String targetClass;

    public AVRelation() {
    }

    public AVRelation(AVObject parent, String key) {
        this();
        this.parent = parent;
        this.key = key;
    }

    public AVRelation(String targetClass) {
        this(null, null);
        this.targetClass = targetClass;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public AVObject getParent() {
        return this.parent;
    }

    public void setParent(AVObject parent) {
        this.parent = parent;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }

    public void add(T object) {
        if (object == null) {
            throw new IllegalArgumentException("null AVObject");
        }
        if (StringUtil.isEmpty(this.targetClass)) {
            this.targetClass = ((AVObject)object).getClassName();
        }
        if (!StringUtil.isEmpty(this.targetClass) && !this.targetClass.equals(((AVObject)object).getClassName())) {
            throw new IllegalArgumentException("Could not add class '" + ((AVObject)object).getClassName() + "' to this relation,expect class is '" + this.targetClass + "'");
        }
        this.parent.addRelation((AVObject)object, this.key);
    }

    public void addAll(Collection<T> objects) {
        if (objects != null) {
            for (AVObject obj : objects) {
                this.add(obj);
            }
        }
    }

    public void remove(AVObject object) {
        this.parent.removeRelation(object, this.key);
    }

    @JSONField(serialize=false)
    public AVQuery<T> getQuery() {
        return this.getQuery(null);
    }

    @JSONField(serialize=false)
    public AVQuery<T> getQuery(Class<T> clazz) {
        if (this.getParent() == null || StringUtil.isEmpty(this.getParent().getObjectId())) {
            throw new IllegalStateException("unable to encode an association with an unsaved AVObject");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("object", Utils.mapFromPointerObject(this.getParent()));
        map.put("key", this.getKey());
        String targetClassName = this.getTargetClass();
        if (StringUtil.isEmpty(targetClassName)) {
            targetClassName = this.getParent().getClassName();
        }
        AVQuery<T> query = new AVQuery<T>(targetClassName, clazz);
        query.addWhereItem("$relatedTo", null, map);
        if (StringUtil.isEmpty(this.getTargetClass())) {
            query.getParameters().put("redirectClassNameForKey", this.getKey());
        }
        return query;
    }

    public static <M extends AVObject> AVQuery<M> reverseQuery(String parentClassName, String relationKey, AVObject child) {
        AVQuery query = new AVQuery(parentClassName);
        query.whereEqualTo(relationKey, Utils.mapFromPointerObject(child));
        return query;
    }

    public static <M extends AVObject> AVQuery<M> reverseQuery(Class<M> theParentClazz, String relationKey, AVObject child) {
        AVQuery<M> query = new AVQuery<M>(Transformer.getSubClassName(theParentClazz), theParentClazz);
        query.whereEqualTo(relationKey, Utils.mapFromPointerObject(child));
        return query;
    }
}

