/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVCloudQuery;
import cn.leancloud.AVException;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.Transformer;
import cn.leancloud.cache.QueryResultCache;
import cn.leancloud.core.PaasClient;
import cn.leancloud.query.AVCloudQueryResult;
import cn.leancloud.query.QueryConditions;
import cn.leancloud.query.QueryOperation;
import cn.leancloud.types.AVGeoPoint;
import cn.leancloud.types.AVNull;
import cn.leancloud.utils.AVUtils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AVQuery<T extends AVObject>
implements Cloneable {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVQuery.class);
    private Class<T> clazz;
    private String className;
    private Boolean isRunning;
    private CachePolicy cachePolicy = CachePolicy.IGNORE_CACHE;
    private long maxCacheAge = -1L;
    private boolean includeACL = false;
    QueryConditions conditions;

    public AVQuery(String theClassName) {
        this(theClassName, null);
    }

    public AVQuery clone() throws CloneNotSupportedException {
        AVQuery query = (AVQuery)super.clone();
        query.isRunning = false;
        query.cachePolicy = this.cachePolicy;
        query.maxCacheAge = this.maxCacheAge;
        query.conditions = null != this.conditions ? this.conditions.clone() : null;
        return query;
    }

    AVQuery(String theClassName, Class<T> clazz) {
        Transformer.checkClassName(theClassName);
        this.className = theClassName;
        this.clazz = clazz;
        this.conditions = new QueryConditions();
    }

    public static <T extends AVObject> AVQuery<T> getQuery(String theClassName) {
        return new AVQuery<T>(theClassName);
    }

    public static <T extends AVObject> AVQuery<T> getQuery(Class<T> clazz) {
        return new AVQuery<T>(Transformer.getSubClassName(clazz), clazz);
    }

    Class<T> getClazz() {
        return this.clazz;
    }

    void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    List<String> getInclude() {
        return this.conditions.getInclude();
    }

    void setInclude(List<String> include) {
        this.conditions.setInclude(include);
    }

    Set<String> getSelectedKeys() {
        return this.conditions.getSelectedKeys();
    }

    void setSelectedKeys(Set<String> selectedKeys) {
        this.conditions.setSelectedKeys(selectedKeys);
    }

    Map<String, String> getParameters() {
        return this.conditions.getParameters();
    }

    void setParameters(Map<String, String> parameters) {
        this.conditions.setParameters(parameters);
    }

    Map<String, List<QueryOperation>> getWhere() {
        return this.conditions.getWhere();
    }

    public String getClassName() {
        return this.className;
    }

    public AVQuery<T> setClassName(String className) {
        this.className = className;
        return this;
    }

    public CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    public AVQuery<T> setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
        return this;
    }

    public CachePolicy getPolicy() {
        return this.cachePolicy;
    }

    public AVQuery<T> setPolicy(CachePolicy policy) {
        this.cachePolicy = policy;
        return this;
    }

    public long getMaxCacheAge() {
        return this.maxCacheAge;
    }

    public AVQuery<T> setMaxCacheAge(long maxCacheAge) {
        this.maxCacheAge = maxCacheAge;
        return this;
    }

    public static void clearAllCachedResults() {
        QueryResultCache.getInstance().clearAllCachedFiles();
    }

    public void clearCachedResult() {
        Map<String, String> query = this.assembleParameters();
        String cacheKey = QueryResultCache.generateKeyForQueryCondition(this.getClassName(), query);
        QueryResultCache.getInstance().clearCachedFile(cacheKey);
    }

    public int getLimit() {
        return this.conditions.getLimit();
    }

    public AVQuery<T> setLimit(int limit) {
        this.conditions.setLimit(limit);
        return this;
    }

    public AVQuery<T> limit(int limit) {
        this.setLimit(limit);
        return this;
    }

    public AVQuery<T> skip(int skip) {
        this.setSkip(skip);
        return this;
    }

    public int getSkip() {
        return this.conditions.getSkip();
    }

    public AVQuery<T> setSkip(int skip) {
        this.conditions.setSkip(skip);
        return this;
    }

    public String getOrder() {
        return this.conditions.getOrder();
    }

    public AVQuery<T> setOrder(String order) {
        this.conditions.setOrder(order);
        return this;
    }

    public AVQuery<T> order(String order) {
        this.setOrder(order);
        return this;
    }

    public AVQuery<T> addAscendingOrder(String key) {
        this.conditions.addAscendingOrder(key);
        return this;
    }

    public AVQuery<T> addDescendingOrder(String key) {
        this.conditions.addDescendingOrder(key);
        return this;
    }

    public boolean isIncludeACL() {
        return this.includeACL;
    }

    public AVQuery<T> includeACL(boolean includeACL) {
        this.includeACL = includeACL;
        return this;
    }

    public AVQuery<T> include(String key) {
        this.conditions.include(key);
        return this;
    }

    public AVQuery<T> selectKeys(Collection<String> keys) {
        this.conditions.selectKeys(keys);
        return this;
    }

    public AVQuery<T> orderByAscending(String key) {
        this.conditions.orderByAscending(key);
        return this;
    }

    public AVQuery<T> orderByDescending(String key) {
        this.conditions.orderByDescending(key);
        return this;
    }

    public AVQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereContainedIn(key, values);
        return this;
    }

    public AVQuery<T> whereContains(String key, String substring) {
        this.conditions.whereContains(key, substring);
        return this;
    }

    public AVQuery<T> whereSizeEqual(String key, int size) {
        this.conditions.whereSizeEqual(key, size);
        return this;
    }

    public AVQuery<T> whereContainsAll(String key, Collection<?> values) {
        this.conditions.whereContainsAll(key, values);
        return this;
    }

    public AVQuery<T> whereDoesNotExist(String key) {
        this.conditions.whereDoesNotExist(key);
        return this;
    }

    public AVQuery<T> whereEndsWith(String key, String suffix) {
        this.conditions.whereEndsWith(key, suffix);
        return this;
    }

    public AVQuery<T> whereEqualTo(String key, Object value) {
        this.conditions.whereEqualTo(key, value);
        return this;
    }

    private AVQuery<T> addOrItems(QueryOperation op) {
        this.conditions.addOrItems(op);
        return this;
    }

    private AVQuery<T> addAndItems(AVQuery query) {
        this.conditions.addAndItems(query.conditions);
        return this;
    }

    protected AVQuery<T> addWhereItem(String key, String op, Object value) {
        this.conditions.addWhereItem(key, op, value);
        return this;
    }

    public AVQuery<T> whereExists(String key) {
        this.conditions.whereExists(key);
        return this;
    }

    public AVQuery<T> whereGreaterThan(String key, Object value) {
        this.conditions.whereGreaterThan(key, value);
        return this;
    }

    public AVQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.conditions.whereGreaterThanOrEqualTo(key, value);
        return this;
    }

    public AVQuery<T> whereLessThan(String key, Object value) {
        this.conditions.whereLessThan(key, value);
        return this;
    }

    public AVQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.conditions.whereLessThanOrEqualTo(key, value);
        return this;
    }

    public AVQuery<T> whereMatches(String key, String regex) {
        this.conditions.whereMatches(key, regex);
        return this;
    }

    public AVQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.conditions.whereMatches(key, regex, modifiers);
        return this;
    }

    public AVQuery<T> whereNear(String key, AVGeoPoint point) {
        this.conditions.whereNear(key, point);
        return this;
    }

    public AVQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.conditions.whereNotContainedIn(key, values);
        return this;
    }

    public AVQuery<T> whereNotEqualTo(String key, Object value) {
        this.conditions.whereNotEqualTo(key, value);
        return this;
    }

    public AVQuery<T> whereStartsWith(String key, String prefix) {
        this.conditions.whereStartsWith(key, prefix);
        return this;
    }

    public AVQuery<T> whereWithinGeoBox(String key, AVGeoPoint southwest, AVGeoPoint northeast) {
        this.conditions.whereWithinGeoBox(key, southwest, northeast);
        return this;
    }

    public AVQuery<T> whereWithinKilometers(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance);
        return this;
    }

    public AVQuery<T> whereWithinKilometers(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinKilometers(key, point, maxDistance, minDistance);
        return this;
    }

    public AVQuery<T> whereWithinMiles(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance);
        return this;
    }

    public AVQuery<T> whereWithinMiles(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinMiles(key, point, maxDistance, minDistance);
        return this;
    }

    public AVQuery<T> whereWithinRadians(String key, AVGeoPoint point, double maxDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance);
        return this;
    }

    public AVQuery<T> whereWithinRadians(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        this.conditions.whereWithinRadians(key, point, maxDistance, minDistance);
        return this;
    }

    public AVQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, AVQuery<?> query) {
        HashMap<String, Object> inner = new HashMap<String, Object>();
        inner.put("className", query.getClassName());
        inner.put("where", query.conditions.compileWhereOperationMap());
        if (query.conditions.getSkip() > 0) {
            inner.put("skip", query.conditions.getSkip());
        }
        if (query.conditions.getLimit() > 0) {
            inner.put("limit", query.conditions.getLimit());
        }
        if (!StringUtil.isEmpty(query.getOrder())) {
            inner.put("order", query.getOrder());
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("query", inner);
        queryMap.put("key", keyInQuery);
        return this.addWhereItem(key, "$select", queryMap);
    }

    public AVQuery<T> whereMatchesQuery(String key, AVQuery<?> query) {
        Map<String, Object> map = AVUtils.createMap("where", query.conditions.compileWhereOperationMap());
        map.put("className", query.className);
        if (query.conditions.getSkip() > 0) {
            map.put("skip", query.conditions.getSkip());
        }
        if (query.conditions.getLimit() > 0) {
            map.put("limit", query.conditions.getLimit());
        }
        if (!StringUtil.isEmpty(query.getOrder())) {
            map.put("order", query.getOrder());
        }
        this.addWhereItem(key, "$inQuery", map);
        return this;
    }

    public AVQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, AVQuery<?> query) {
        Map<String, Object> map = AVUtils.createMap("className", query.className);
        map.put("where", query.conditions.compileWhereOperationMap());
        Map<String, Object> queryMap = AVUtils.createMap("query", map);
        queryMap.put("key", keyInQuery);
        this.addWhereItem(key, "$dontSelect", queryMap);
        return this;
    }

    public AVQuery<T> whereDoesNotMatchQuery(String key, AVQuery<?> query) {
        Map<String, Object> map = AVUtils.createMap("className", query.className);
        map.put("where", query.conditions.compileWhereOperationMap());
        this.addWhereItem(key, "$notInQuery", map);
        return this;
    }

    AVQuery<T> setWhere(Map<String, List<QueryOperation>> value) {
        this.conditions.setWhere(value);
        return this;
    }

    public static <T extends AVObject> AVQuery<T> or(List<AVQuery<T>> queries) {
        if (null == queries || queries.isEmpty()) {
            throw new IllegalArgumentException("queries must be non-empty.");
        }
        String className = queries.get(0).getClassName();
        AVQuery<T> result = new AVQuery<T>(className);
        if (queries.size() > 1) {
            for (AVQuery<T> query : queries) {
                if (!className.equals(query.getClassName())) {
                    throw new IllegalArgumentException("All queries must be for the same class");
                }
                super.addOrItems(new QueryOperation("$or", "$or", query.conditions.compileWhereOperationMap()));
            }
        } else {
            result.setWhere(queries.get((int)0).conditions.getWhere());
        }
        return result;
    }

    public static <T extends AVObject> AVQuery<T> and(List<AVQuery<T>> queries) {
        if (null == queries || queries.isEmpty()) {
            throw new IllegalArgumentException("queries must be non-empty.");
        }
        String className = queries.get(0).getClassName();
        AVQuery<T> result = new AVQuery<T>(className);
        if (queries.size() > 1) {
            for (AVQuery<T> query : queries) {
                if (!className.equals(query.getClassName())) {
                    throw new IllegalArgumentException("All queries must be for the same class");
                }
                super.addAndItems(query);
            }
        } else {
            result.setWhere(queries.get((int)0).conditions.getWhere());
        }
        return result;
    }

    public boolean hasCachedResult() {
        Map<String, String> query = this.assembleParameters();
        return PaasClient.getStorageClient().hasCachedResult(this.getClassName(), query, this.getMaxCacheAge());
    }

    public List<T> find() {
        return (List)this.findInBackground().blockingLast();
    }

    public Observable<List<T>> findInBackground() {
        return this.findInBackground(0);
    }

    protected Observable<List<T>> findInBackground(int explicitLimit) {
        Map<String, String> query = this.assembleParameters();
        if (this.includeACL && null != query) {
            query.put("returnACL", "true");
        }
        if (explicitLimit > 0) {
            query.put("limit", Integer.toString(explicitLimit));
        }
        LOGGER.d("Query: " + query);
        return PaasClient.getStorageClient().queryObjects(this.getClassName(), query, this.cachePolicy, this.maxCacheAge).map(new Function<List<AVObject>, List<T>>(){

            public List<T> apply(List<AVObject> var1) throws Exception {
                LOGGER.d("invoke within AVQuery.findInBackground(). resultSize=" + var1.size());
                ArrayList result = new ArrayList(var1.size());
                for (AVObject obj : var1) {
                    Object tmp = Transformer.transform(obj, AVQuery.this.getClassName());
                    result.add(tmp);
                }
                return result;
            }
        });
    }

    public T get(String objectId) {
        return (T)((AVObject)this.getInBackground(objectId).blockingFirst());
    }

    public Observable<T> getInBackground(String objectId) {
        List<String> include = this.getInclude();
        String includeKeys = null;
        if (null != include && include.size() > 0) {
            includeKeys = StringUtil.join(",", include);
        }
        return PaasClient.getStorageClient().fetchObject(this.getClassName(), objectId, includeKeys).map(new Function<AVObject, T>(){

            public T apply(AVObject avObject) throws Exception {
                if (null == avObject || StringUtil.isEmpty(avObject.getObjectId())) {
                    throw new AVException(101, "Object is not found.");
                }
                return Transformer.transform(avObject, AVQuery.this.getClassName());
            }
        });
    }

    public T getFirst() {
        try {
            return (T)((AVObject)this.getFirstInBackground().blockingFirst());
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public Observable<T> getFirstInBackground() {
        return this.findInBackground(1).flatMap(new Function<List<T>, ObservableSource<T>>(){

            public ObservableSource<T> apply(List<T> list) throws Exception {
                LOGGER.d("flatMap: " + list);
                return Observable.fromIterable(list);
            }
        });
    }

    public int count() {
        return (Integer)this.countInBackground().blockingFirst();
    }

    public Observable<Integer> countInBackground() {
        Map<String, String> query = this.assembleParameters();
        query.put("count", "1");
        query.put("limit", "0");
        return PaasClient.getStorageClient().queryCount(this.getClassName(), query);
    }

    public void deleteAll() {
        this.deleteAllInBackground().blockingSubscribe();
    }

    public Observable<AVNull> deleteAllInBackground() {
        return this.findInBackground().flatMap(new Function<List<T>, ObservableSource<AVNull>>(){

            public ObservableSource<AVNull> apply(List<T> list) {
                return AVObject.deleteAllInBackground(list);
            }
        });
    }

    public Map<String, String> assembleParameters() {
        this.conditions.assembleParameters();
        return this.conditions.getParameters();
    }

    protected Map<String, Object> assembleJsonParam() {
        Map<String, Object> result = this.conditions.assembleJsonParam();
        result.put("className", this.getClassName());
        return result;
    }

    public static Observable<AVCloudQueryResult> doCloudQueryInBackground(String cql) {
        return AVCloudQuery.executeInBackground(cql);
    }

    public static Observable<AVCloudQueryResult> doCloudQueryInBackground(String cql, Object ... params) {
        return AVCloudQuery.executeInBackground(cql, params);
    }

    public static Observable<AVCloudQueryResult> doCloudQueryInBackground(String cql, Class<? extends AVObject> clazz) {
        return AVCloudQuery.executeInBackground(cql, clazz);
    }

    public static Observable<AVCloudQueryResult> doCloudQueryInBackground(String cql, Class<? extends AVObject> clazz, Object ... params) {
        return AVCloudQuery.executeInBackground(cql, clazz, params);
    }

    public static enum CachePolicy {
        CACHE_ELSE_NETWORK,
        CACHE_ONLY,
        CACHE_THEN_NETWORK,
        IGNORE_CACHE,
        NETWORK_ELSE_CACHE,
        NETWORK_ONLY;

    }
}

