/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.search;

import cn.leancloud.types.AVGeoPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AVSearchSortBuilder {
    private final List<Object> sortFields = new ArrayList<Object>();

    public static AVSearchSortBuilder newBuilder() {
        return new AVSearchSortBuilder();
    }

    public AVSearchSortBuilder orderByAscending(String key, String mode, String missing) {
        return this.addField(key, "asc", mode, missing);
    }

    public AVSearchSortBuilder orderByAscending(String key, String mode) {
        return this.orderByAscending(key, mode, "last");
    }

    public AVSearchSortBuilder orderByAscending(String key) {
        return this.orderByAscending(key, "avg");
    }

    public AVSearchSortBuilder orderByDescending(String key, String mode, String missing) {
        return this.addField(key, "desc", mode, missing);
    }

    public AVSearchSortBuilder orderByDescending(String key, String mode) {
        return this.orderByDescending(key, mode, "last");
    }

    public AVSearchSortBuilder orderByDescending(String key) {
        return this.orderByDescending(key, "avg");
    }

    private AVSearchSortBuilder addField(String key, String order, String mode, String missing) {
        HashMap field = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("order", order);
        map.put("mode", mode);
        map.put("missing", "_" + missing);
        field.put(key, map);
        this.sortFields.add(field);
        return this;
    }

    public AVSearchSortBuilder whereNear(String key, AVGeoPoint point) {
        return this.whereNear(key, point, "asc");
    }

    public AVSearchSortBuilder whereNear(String key, AVGeoPoint point, String order) {
        return this.whereNear(key, point, order, "avg", "km");
    }

    public AVSearchSortBuilder whereNear(String key, AVGeoPoint point, String order, String mode, String unit) {
        HashMap field = new HashMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Double> geoMap = new HashMap<String, Double>();
        geoMap.put("lat", point.getLatitude());
        geoMap.put("lon", point.getLongitude());
        map.put(key, geoMap);
        map.put("unit", unit);
        map.put("mode", mode);
        map.put("order", order);
        field.put("_geo_distance", map);
        this.sortFields.add(field);
        return this;
    }

    public List<Object> getSortFields() {
        return this.sortFields;
    }
}

