/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.ops;

import cn.leancloud.ops.AddOperation;
import cn.leancloud.ops.AddRelationOperation;
import cn.leancloud.ops.AddUniqueOperation;
import cn.leancloud.ops.BaseOperation;
import cn.leancloud.ops.BitAndOperation;
import cn.leancloud.ops.BitOrOperation;
import cn.leancloud.ops.BitXorOperation;
import cn.leancloud.ops.CompoundOperation;
import cn.leancloud.ops.DecrementOperation;
import cn.leancloud.ops.DeleteOperation;
import cn.leancloud.ops.IncrementOperation;
import cn.leancloud.ops.NullOperation;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.ops.RemoveOperation;
import cn.leancloud.ops.RemoveRelationOperation;
import cn.leancloud.ops.SetOperation;

public class OperationBuilder {
    public static final OperationBuilder gBuilder = new OperationBuilder();

    private OperationBuilder() {
    }

    public ObjectFieldOperation create(OperationType type, String field, Object value) {
        BaseOperation operation = null;
        switch (type) {
            case Add: {
                operation = new AddOperation(field, value);
                break;
            }
            case Set: {
                operation = new SetOperation(field, value);
                break;
            }
            case Delete: {
                operation = new DeleteOperation(field);
                break;
            }
            case AddRelation: {
                operation = new AddRelationOperation(field, value);
                break;
            }
            case AddUnique: {
                operation = new AddUniqueOperation(field, value);
                break;
            }
            case Remove: {
                operation = new RemoveOperation(field, value);
                break;
            }
            case RemoveRelation: {
                operation = new RemoveRelationOperation(field, value);
                break;
            }
            case Increment: {
                operation = new IncrementOperation(field, value);
                break;
            }
            case Decrement: {
                operation = new DecrementOperation(field, value);
                break;
            }
            case BitAnd: {
                operation = new BitAndOperation(field, value);
                break;
            }
            case BitOr: {
                operation = new BitOrOperation(field, value);
                break;
            }
            case BitXor: {
                operation = new BitXorOperation(field, value);
                break;
            }
            case Compound: {
                operation = new CompoundOperation(field);
                break;
            }
            default: {
                operation = new NullOperation(field, value);
            }
        }
        return operation;
    }

    public static enum OperationType {
        Set,
        Delete,
        Add,
        AddUnique,
        Remove,
        AddRelation,
        RemoveRelation,
        Increment,
        Decrement,
        BitAnd,
        BitOr,
        BitXor,
        Compound;

    }
}

