/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.network;

import cn.leancloud.network.NetworkingDetector;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class SimpleNetworkingDetector
implements NetworkingDetector {
    private static final String eth0Pattern = "[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+";

    @Override
    public boolean isConnected() {
        boolean result = false;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                boolean isEth0 = false;
                for (InterfaceAddress i : networkInterface.getInterfaceAddresses()) {
                    if ("127.0.0.1".equalsIgnoreCase(i.getAddress().getHostAddress())) break;
                    if (!Pattern.matches(eth0Pattern, i.getAddress().getHostAddress())) continue;
                    isEth0 = true;
                    break;
                }
                if (!isEth0) continue;
                result = networkInterface.isUp();
                break;
            }
            return result;
        }
        catch (SocketException ex) {
            return false;
        }
    }

    @Override
    public NetworkingDetector.NetworkType getNetworkType() {
        return NetworkingDetector.NetworkType.WIFI;
    }
}

