/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVQuery;
import cn.leancloud.AVStatus;
import cn.leancloud.AVStatusQuery;
import com.alibaba.fastjson.JSON;
import java.util.Map;

class StatusIterator {
    AVStatusQuery.SourceType sourceType;
    AVStatus lastStatus = null;
    private int pageSize;
    private long sinceId = AVStatus.INVALID_MESSAGE_ID;
    private long maxId = AVStatus.INVALID_MESSAGE_ID;
    private AVStatusQuery.PaginationDirection direction;

    public StatusIterator(AVStatusQuery.SourceType type) {
        this(type, AVStatusQuery.PaginationDirection.NEW_TO_OLD, 0);
    }

    public StatusIterator(AVStatusQuery.SourceType type, AVStatusQuery.PaginationDirection direction, int pageSize) {
        this.sourceType = type;
        this.direction = direction;
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize > 0 && pageSize < 200) {
            this.pageSize = pageSize;
        }
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public AVStatusQuery.PaginationDirection getDirection() {
        return this.direction;
    }

    public void setDirection(AVStatusQuery.PaginationDirection direction) {
        this.direction = direction;
    }

    public void fillConditions(AVQuery query) {
        if (null == query || null == this.lastStatus) {
            return;
        }
        if (AVStatusQuery.PaginationDirection.NEW_TO_OLD == this.direction) {
            query.whereLessThan("createdAt", this.lastStatus.getCreatedAt());
        } else {
            query.whereGreaterThan("createdAt", this.lastStatus.getCreatedAt());
        }
    }

    public void fillConditions(Map<String, String> condition) {
        if (this.direction == AVStatusQuery.PaginationDirection.OLD_TO_NEW && this.sinceId > (long)AVStatus.INVALID_MESSAGE_ID) {
            condition.put("sinceId", String.valueOf(this.sinceId));
        }
        if (this.direction == AVStatusQuery.PaginationDirection.NEW_TO_OLD && this.maxId > (long)AVStatus.INVALID_MESSAGE_ID) {
            condition.put("maxId", String.valueOf(this.maxId - 1L));
        }
    }

    public void encounter(AVStatus status) {
        this.lastStatus = status;
        if (AVStatusQuery.SourceType.INBOX == this.sourceType && null != status) {
            if (this.direction == AVStatusQuery.PaginationDirection.OLD_TO_NEW) {
                if (status.getMessageId() > this.sinceId) {
                    this.sinceId = status.getMessageId();
                }
            } else if (0L == this.maxId) {
                this.maxId = status.getMessageId();
            } else if (status.getMessageId() < this.maxId) {
                this.maxId = status.getMessageId();
            }
        }
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

