/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.core.AVOSCloud;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.logging.InternalLogger;
import cn.leancloud.utils.StringUtil;

public class AVLogger {
    private volatile InternalLogger internalLogger = null;
    private String tag = null;

    public AVLogger(String tag) {
        this.tag = tag;
    }

    public void v(String msg) {
        this.writeLog(Level.VERBOSE, msg);
    }

    public void v(String msg, Throwable tr) {
        this.writeLog(Level.VERBOSE, msg, tr);
    }

    public void d(String msg) {
        this.writeLog(Level.DEBUG, msg);
    }

    public void d(String msg, Throwable tr) {
        this.writeLog(Level.DEBUG, msg, tr);
    }

    public void i(String msg) {
        this.writeLog(Level.INFO, msg);
    }

    public void i(String msg, Throwable tr) {
        this.writeLog(Level.INFO, msg, tr);
    }

    public void w(String msg) {
        this.writeLog(Level.WARNING, msg);
    }

    public void w(String msg, Throwable tr) {
        this.writeLog(Level.WARNING, msg, tr);
    }

    public void w(Throwable tr) {
        this.writeLog(Level.WARNING, tr);
    }

    public void e(String msg) {
        this.writeLog(Level.ERROR, msg);
    }

    public void e(String msg, Throwable tr) {
        this.writeLog(Level.ERROR, msg, tr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalLogger getInternalLogger() {
        if (null == this.internalLogger) {
            AVLogger aVLogger = this;
            synchronized (aVLogger) {
                if (null == this.internalLogger) {
                    this.internalLogger = AppConfiguration.getLogAdapter().getLogger(this.tag);
                }
            }
        }
        return this.internalLogger;
    }

    protected boolean isEnabled(Level testLevel) {
        return AVOSCloud.getLogLevel().intLevel() >= testLevel.intLevel();
    }

    protected void writeLog(Level level, String msg) {
        if (!this.isEnabled(level)) {
            return;
        }
        if (null == msg) {
            msg = "";
        }
        InternalLogger internalLogger = this.getInternalLogger();
        internalLogger.writeLog(level, msg);
    }

    protected void writeLog(Level level, String msg, Throwable tr) {
        if (null == tr) {
            this.writeLog(level, msg);
            return;
        }
        if (StringUtil.isEmpty(msg)) {
            this.writeLog(level, tr);
            return;
        }
        if (!this.isEnabled(level)) {
            return;
        }
        InternalLogger internalLogger = this.getInternalLogger();
        internalLogger.writeLog(level, msg, tr);
    }

    protected void writeLog(Level level, Throwable tr) {
        if (!this.isEnabled(level)) {
            return;
        }
        if (null == tr) {
            return;
        }
        InternalLogger internalLogger = this.getInternalLogger();
        internalLogger.writeLog(level, tr);
    }

    public static enum Level {
        OFF(0),
        ERROR(1),
        WARNING(2),
        INFO(3),
        DEBUG(4),
        VERBOSE(5),
        ALL(6);

        private int intLevel;

        private Level(int intLevel) {
            this.intLevel = intLevel;
        }

        public int intLevel() {
            return this.intLevel;
        }
    }
}

