/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.AVException;
import cn.leancloud.AVLogger;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class FileDownloader {
    private static final AVLogger gLogger = LogUtil.getLogger(FileDownloader.class);
    private static final int READ_BUF_SIZE = 8192;

    public AVException execute(String url, File localFile) {
        if (StringUtil.isEmpty(url)) {
            return new AVException(new IllegalArgumentException("url is null"));
        }
        if (localFile.exists()) {
            return null;
        }
        return this.downloadFileFromNetwork(url, localFile);
    }

    private OkHttpClient getHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AVException downloadFileFromNetwork(String url, File cacheFile) {
        AVException errors;
        block25: {
            errors = null;
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url);
            OkHttpClient client = this.getHttpClient();
            try {
                Response response = client.newCall(requestBuilder.build()).execute();
                int statusCode = response.code();
                Headers headers = response.headers();
                InputStream data = response.body().byteStream();
                if (statusCode / 100 == 2 && null != data) {
                    byte[] content = new byte[8192];
                    FileOutputStream out = null;
                    ReentrantReadWriteLock.WriteLock writeLock = PersistenceUtil.sharedInstance().getLock(cacheFile.getAbsolutePath()).writeLock();
                    if (writeLock.tryLock()) {
                        try {
                            out = new FileOutputStream(cacheFile, false);
                            int currentReadSize = data.read(content);
                            while (currentReadSize > 0) {
                                out.write(content, 0, currentReadSize);
                                currentReadSize = data.read(content);
                            }
                            break block25;
                        }
                        catch (Exception e) {
                            gLogger.w(e);
                            errors = new AVException(e);
                            break block25;
                        }
                        finally {
                            try {
                                data.close();
                            }
                            catch (IOException iOException) {}
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            writeLock.unlock();
                        }
                    }
                    gLogger.w("failed to lock writeLocker, skip to save network streaming to local cache.");
                    break block25;
                }
                if (null != data) {
                    errors = new AVException(statusCode, "status code is invalid");
                    gLogger.w(errors);
                } else {
                    errors = new AVException(statusCode, "data is empty!");
                    gLogger.w(errors);
                }
            }
            catch (IOException ex) {
                errors = new AVException(ex);
            }
        }
        return errors;
    }
}

