/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.AVException;
import cn.leancloud.AVFile;
import cn.leancloud.AVLogger;
import cn.leancloud.callback.ProgressCallback;
import cn.leancloud.core.PaasClient;
import cn.leancloud.upload.FileUploadToken;
import cn.leancloud.upload.HttpClientUploader;
import cn.leancloud.upload.QCloudUploader;
import cn.leancloud.upload.QiniuSlicingUploader;
import cn.leancloud.upload.S3Uploader;
import cn.leancloud.upload.Uploader;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FileUploader
extends HttpClientUploader {
    private static AVLogger logger = LogUtil.getLogger(FileUploader.class);
    static final int gProgressGotToken = 10;
    static final int gProgressUploadedFile = 90;
    static final int gProgressComplete = 100;
    static final String gProviderQCloud = "qcloud";
    static final String gProviderS3 = "s3";
    private String token;
    private String bucket;
    private String uploadUrl;
    private String provider;
    static HashMap<String, String> UPLOAD_HEADERS = new HashMap();

    public FileUploader(AVFile avFile, FileUploadToken uploadToken, ProgressCallback progressCallback) {
        super(avFile, progressCallback);
        this.token = uploadToken.getToken();
        this.bucket = uploadToken.getBucket();
        this.uploadUrl = uploadToken.getUploadUrl();
        this.provider = uploadToken.getProvider();
    }

    @Override
    public AVException execute() {
        this.publishProgress(10);
        Uploader uploader = this.getUploaderImplementation();
        if (null == uploader) {
            return new AVException(new Throwable("Uploader can not be instantiated."));
        }
        AVException uploadException = uploader.execute();
        if (uploadException == null) {
            this.publishProgress(100);
            this.completeFileUpload(true);
            return null;
        }
        this.completeFileUpload(false);
        return uploadException;
    }

    private Uploader getUploaderImplementation() {
        if (!StringUtil.isEmpty(this.provider)) {
            if (gProviderQCloud.equalsIgnoreCase(this.provider)) {
                return new QCloudUploader(this.avFile, this.token, this.uploadUrl, this.progressCallback);
            }
            if (gProviderS3.equalsIgnoreCase(this.provider)) {
                return new S3Uploader(this.avFile, this.uploadUrl, this.progressCallback);
            }
            return new QiniuSlicingUploader(this.avFile, this.token, this.uploadUrl, this.progressCallback);
        }
        logger.w("provider doesnot exist, cannot upload any file.");
        return null;
    }

    private void completeFileUpload(boolean success) {
        if (!StringUtil.isEmpty(this.token)) {
            try {
                JSONObject completeResult = new JSONObject();
                completeResult.put("result", (Object)success);
                completeResult.put("token", (Object)this.token);
                PaasClient.getStorageClient().fileCallback(completeResult);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setUploadHeader(String key, String value) {
        UPLOAD_HEADERS.put(key, value);
    }

    public static interface FileUploadProgressCallback {
        public void onProgress(int var1);
    }

    protected static class ProgressCalculator {
        Map<Integer, Integer> blockProgress = new HashMap<Integer, Integer>();
        FileUploadProgressCallback callback;
        int fileBlockCount = 0;

        public ProgressCalculator(int blockCount, FileUploadProgressCallback callback) {
            this.callback = callback;
            this.fileBlockCount = blockCount;
        }

        public synchronized void publishProgress(int offset, int progress) {
            this.blockProgress.put(offset, progress);
            if (this.callback != null) {
                int progressSum = 0;
                Set<Integer> keySet = this.blockProgress.keySet();
                for (Integer index : keySet) {
                    progressSum += this.blockProgress.get(index).intValue();
                }
                this.callback.onProgress(10 + 80 * progressSum / (100 * this.fileBlockCount));
            }
        }
    }
}

