/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.AVLogger;
import cn.leancloud.cache.SystemSetting;
import cn.leancloud.core.AVOSCloud;
import cn.leancloud.core.AVOSService;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.LoggingInterceptor;
import cn.leancloud.network.DNSDetoxicant;
import cn.leancloud.service.AppAccessEndpoint;
import cn.leancloud.service.AppRouterService;
import cn.leancloud.service.RTMConnectionServerResponse;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.fastjson.FastJsonConverterFactory;

public class AppRouter {
    private static final AVLogger LOGGER = LogUtil.getLogger(AppRouter.class);
    private static final String APP_ROUTER_HOST = "https://app-router.leancloud.cn";
    private static final AppRouter INSTANCE = new AppRouter();
    private static final String DEFAULT_SERVER_HOST_FORMAT = "https://%s.%s.%s";
    private static final String DEFAULT_SERVER_API = AVOSService.API.toString();
    private static final String DEFAULT_SERVER_STAT = AVOSService.STATS.toString();
    private static final String DEFAULT_SERVER_ENGINE = AVOSService.ENGINE.toString();
    private static final String DEFAULT_SERVER_PUSH = AVOSService.PUSH.toString();
    private static final String DEFAULT_SERVER_RTM_ROUTER = AVOSService.RTM.toString();
    private static final String DEFAULT_REGION_EAST_CHINA = "lncldapi.com";
    private static final String DEFAULT_REGION_NORTH_CHINA = "lncld.net";
    private static final String DEFAULT_REGION_NORTH_AMERICA = "lncldglobal.com";
    private Retrofit retrofit = null;
    private AppAccessEndpoint appAccessEndpoint = null;
    private AppAccessEndpoint fixedAccessEndpoint = new AppAccessEndpoint();

    public static AppRouter getInstance() {
        return INSTANCE;
    }

    public static AVOSCloud.REGION getAppRegion(String applicationId) {
        if (StringUtil.isEmpty(applicationId)) {
            return AVOSCloud.REGION.NorthChina;
        }
        if (applicationId.endsWith("-MdYXbMMI")) {
            return AVOSCloud.REGION.NorthAmerica;
        }
        if (applicationId.endsWith("-9Nh9j0Va")) {
            return AVOSCloud.REGION.EastChina;
        }
        return AVOSCloud.REGION.NorthChina;
    }

    protected AppRouter() {
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)new LoggingInterceptor()).dns((Dns)new DNSDetoxicant()).build();
        this.retrofit = new Retrofit.Builder().baseUrl(APP_ROUTER_HOST).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(httpClient).build();
    }

    protected AppAccessEndpoint buildDefaultEndpoint(String appId) {
        AppAccessEndpoint result = new AppAccessEndpoint();
        String appIdPrefix = appId.substring(0, 8).toLowerCase();
        AVOSCloud.REGION region = AppRouter.getAppRegion(appId);
        String lastHost = "";
        switch (region) {
            case NorthChina: {
                lastHost = DEFAULT_REGION_NORTH_CHINA;
                break;
            }
            case EastChina: {
                lastHost = DEFAULT_REGION_EAST_CHINA;
                break;
            }
            case NorthAmerica: {
                lastHost = DEFAULT_REGION_NORTH_AMERICA;
                break;
            }
            default: {
                LOGGER.w("Invalid region");
            }
        }
        result.setApiServer(String.format(DEFAULT_SERVER_HOST_FORMAT, appIdPrefix, DEFAULT_SERVER_API, lastHost));
        result.setEngineServer(String.format(DEFAULT_SERVER_HOST_FORMAT, appIdPrefix, DEFAULT_SERVER_ENGINE, lastHost));
        result.setPushServer(String.format(DEFAULT_SERVER_HOST_FORMAT, appIdPrefix, DEFAULT_SERVER_PUSH, lastHost));
        result.setRtmRouterServer(String.format(DEFAULT_SERVER_HOST_FORMAT, appIdPrefix, DEFAULT_SERVER_RTM_ROUTER, lastHost));
        result.setStatServer(String.format(DEFAULT_SERVER_HOST_FORMAT, appIdPrefix, DEFAULT_SERVER_STAT, lastHost));
        result.setTtl(36000L + System.currentTimeMillis() / 1000L);
        return result;
    }

    private Observable<String> fetchServerFromRemote(String appId, final AVOSService service) {
        return this.fetchServerHostsInBackground(appId).map((Function)new Function<AppAccessEndpoint, String>(){

            public String apply(AppAccessEndpoint appAccessEndpoint) throws Exception {
                String result = "";
                switch (service) {
                    case API: {
                        result = appAccessEndpoint.getApiServer();
                        break;
                    }
                    case ENGINE: {
                        result = appAccessEndpoint.getEngineServer();
                        break;
                    }
                    case PUSH: {
                        result = appAccessEndpoint.getPushServer();
                        break;
                    }
                    case RTM: {
                        result = appAccessEndpoint.getRtmRouterServer();
                        break;
                    }
                    case STATS: {
                        result = appAccessEndpoint.getStatServer();
                        break;
                    }
                }
                if (!StringUtil.isEmpty(result) && !result.startsWith("http")) {
                    result = "https://" + result;
                }
                return result;
            }
        });
    }

    public void freezeEndpoint(AVOSService service, String host) {
        this.fixedAccessEndpoint.freezeEndpoint(service, host);
    }

    public Observable<String> getEndpoint(String appId, AVOSService service, boolean forceUpdate) {
        String fixedHost = this.fixedAccessEndpoint.getServerHost(service);
        if (!StringUtil.isEmpty(fixedHost)) {
            return Observable.just((Object)fixedHost);
        }
        if (forceUpdate) {
            return this.fetchServerFromRemote(appId, service);
        }
        if (null == this.appAccessEndpoint) {
            SystemSetting setting = AppConfiguration.getDefaultSetting();
            String cachedResult = null;
            if (null != setting) {
                cachedResult = setting.getString(this.getPersistenceKeyZone(appId, true), appId, "");
            }
            if (!StringUtil.isEmpty(cachedResult)) {
                this.appAccessEndpoint = (AppAccessEndpoint)JSON.parseObject(cachedResult, AppAccessEndpoint.class);
                long currentSeconds = System.currentTimeMillis() / 1000L;
                if (currentSeconds > this.appAccessEndpoint.getTtl()) {
                    this.appAccessEndpoint = null;
                }
            } else {
                this.appAccessEndpoint = this.buildDefaultEndpoint(appId);
            }
        }
        String result = null;
        if (null != this.appAccessEndpoint) {
            switch (service) {
                case API: {
                    result = this.appAccessEndpoint.getApiServer();
                    break;
                }
                case ENGINE: {
                    result = this.appAccessEndpoint.getEngineServer();
                    break;
                }
                case PUSH: {
                    result = this.appAccessEndpoint.getPushServer();
                    break;
                }
                case RTM: {
                    result = this.appAccessEndpoint.getRtmRouterServer();
                    break;
                }
                case STATS: {
                    result = this.appAccessEndpoint.getStatServer();
                    break;
                }
            }
            if (!StringUtil.isEmpty(result) && !result.startsWith("http")) {
                result = "https://" + result;
            }
            return Observable.just((Object)result);
        }
        return this.fetchServerFromRemote(appId, service);
    }

    public Observable<AppAccessEndpoint> fetchServerHostsInBackground(final String appId) {
        AppConfiguration.SchedulerCreator creator;
        AppRouterService service = (AppRouterService)this.retrofit.create(AppRouterService.class);
        Observable result = service.getRouter(appId);
        if (AppConfiguration.isAsynchronized()) {
            result = result.subscribeOn(Schedulers.io());
        }
        if (null != (creator = AppConfiguration.getDefaultScheduler())) {
            result = result.observeOn(creator.create());
        }
        return result.map((Function)new Function<AppAccessEndpoint, AppAccessEndpoint>(){

            public AppAccessEndpoint apply(AppAccessEndpoint appAccessEndpoint) throws Exception {
                LOGGER.d(appAccessEndpoint.toString());
                AppRouter.this.appAccessEndpoint = appAccessEndpoint;
                AppRouter.this.appAccessEndpoint.setTtl(appAccessEndpoint.getTtl() + System.currentTimeMillis() / 1000L);
                SystemSetting setting = AppConfiguration.getDefaultSetting();
                if (null != setting) {
                    String endPoints = JSON.toJSONString((Object)AppRouter.this.appAccessEndpoint);
                    setting.saveString(AppRouter.this.getPersistenceKeyZone(appId, true), appId, endPoints);
                }
                return AppRouter.this.appAccessEndpoint;
            }
        });
    }

    private Observable<RTMConnectionServerResponse> fetchRTMServerFromRemote(final String routerHost, final String appId, String installationId, int secure) {
        AppConfiguration.SchedulerCreator creator;
        LOGGER.d("fetchRTMServerFromRemote. router=" + routerHost + ", appId=" + appId);
        Retrofit tmpRetrofit = this.retrofit.newBuilder().baseUrl(routerHost).build();
        AppRouterService tmpService = (AppRouterService)tmpRetrofit.create(AppRouterService.class);
        Observable result = tmpService.getRTMConnectionServer(appId, installationId, secure);
        if (AppConfiguration.isAsynchronized()) {
            result = result.subscribeOn(Schedulers.io());
        }
        if (null != (creator = AppConfiguration.getDefaultScheduler())) {
            result = result.observeOn(creator.create());
        }
        return result.map((Function)new Function<RTMConnectionServerResponse, RTMConnectionServerResponse>(){

            public RTMConnectionServerResponse apply(RTMConnectionServerResponse rtmConnectionServerResponse) throws Exception {
                SystemSetting setting = AppConfiguration.getDefaultSetting();
                if (null != rtmConnectionServerResponse && null != setting) {
                    rtmConnectionServerResponse.setTtl(rtmConnectionServerResponse.getTtl() + System.currentTimeMillis() / 1000L);
                    String cacheResult = JSON.toJSONString((Object)rtmConnectionServerResponse);
                    setting.saveString(AppRouter.this.getPersistenceKeyZone(appId, false), routerHost, cacheResult);
                }
                return rtmConnectionServerResponse;
            }
        });
    }

    public Observable<RTMConnectionServerResponse> fetchRTMConnectionServer(String routerHost, String appId, String installationId, int secure, boolean forceUpdate) {
        if (!forceUpdate) {
            String cacheServer;
            RTMConnectionServerResponse cachedResponse = null;
            SystemSetting setting = AppConfiguration.getDefaultSetting();
            if (null != setting && !StringUtil.isEmpty(cacheServer = setting.getString(this.getPersistenceKeyZone(appId, false), routerHost, ""))) {
                try {
                    cachedResponse = (RTMConnectionServerResponse)JSON.parseObject((String)cacheServer, RTMConnectionServerResponse.class);
                    long currentSeconds = System.currentTimeMillis() / 1000L;
                    if (currentSeconds > cachedResponse.getTtl()) {
                        setting.removeKey(this.getPersistenceKeyZone(appId, false), routerHost);
                        cachedResponse = null;
                    }
                    if (null != cachedResponse) {
                        return Observable.just((Object)cachedResponse);
                    }
                }
                catch (Exception ex) {
                    cachedResponse = null;
                    setting.removeKey(this.getPersistenceKeyZone(appId, false), routerHost);
                }
            }
        }
        return this.fetchRTMServerFromRemote(routerHost, appId, installationId, secure);
    }

    protected String getPersistenceKeyZone(String appId, boolean forAPIEndpoints) {
        if (forAPIEndpoints) {
            return "com.avos.avoscloud.approuter." + appId;
        }
        return "com.avos.push.router.server.cache" + appId;
    }
}

