/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVObject;
import cn.leancloud.AVStatusQuery;
import cn.leancloud.AVUser;
import cn.leancloud.annotation.AVClassName;
import cn.leancloud.core.PaasClient;
import cn.leancloud.ops.Utils;
import cn.leancloud.types.AVNull;
import cn.leancloud.utils.ErrorUtils;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONType;
import io.reactivex.Observable;
import java.util.HashMap;

@AVClassName(value="_Status")
@JSONType(ignores={"acl", "updatedAt", "uuid"})
public class AVStatus
extends AVObject {
    public static final String CLASS_NAME = "_Status";
    public static final String IMAGE_TAG = "image";
    public static final String MESSAGE_TAG = "message";
    public static final String DATAMAP_TAG = "dataMap";

    public AVStatus() {
        super(CLASS_NAME);
    }

    public void setImageUrl(String imageUrl) {
        this.put(IMAGE_TAG, imageUrl);
    }

    public String getImageUrl() {
        return this.getString(IMAGE_TAG);
    }

    public void setMessage(String msg) {
        this.put(MESSAGE_TAG, msg);
    }

    public String getMessage() {
        return this.getString(MESSAGE_TAG);
    }

    @Override
    public Observable<AVNull> deleteInBackground() {
        return AVStatus.deleteStatusInBackground(this.getObjectId());
    }

    public static Observable<AVNull> deleteStatusInBackground(String statusId) {
        if (!AVStatus.checkUserAuthenticated()) {
            return Observable.error((Throwable)ErrorUtils.sessionMissingException());
        }
        if (StringUtil.isEmpty(statusId)) {
            return Observable.error((Throwable)ErrorUtils.invalidObjectIdException());
        }
        return PaasClient.getStorageClient().deleteStatus(statusId);
    }

    public static Observable<AVNull> deleteInboxStatusInBackground(long messageId, String inboxType, AVUser owner) {
        if (null == owner || StringUtil.isEmpty(owner.getObjectId())) {
            return Observable.error((Throwable)new AVException(211, "Owner can't be null"));
        }
        if (StringUtil.isEmpty(inboxType)) {
            return Observable.error((Throwable)new IllegalArgumentException("messageId can't be null/empty"));
        }
        String ownerString = JSON.toJSONString(Utils.mapFromPointerObject(owner));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("messageId", String.valueOf(messageId));
        params.put("inboxType", inboxType);
        params.put("owner", ownerString);
        return PaasClient.getStorageClient().deleteInboxStatus(params);
    }

    public static AVStatusQuery statusQuery(AVUser owner) throws AVException {
        AVStatusQuery query = new AVStatusQuery();
        query.whereEqualTo("source", owner);
        return query;
    }

    private static boolean checkUserAuthenticated() {
        AVUser currentUser = AVUser.getCurrentUser();
        return null != currentUser && currentUser.isAuthenticated();
    }

    public static enum INBOX_TYPE {
        TIMELINE("default"),
        PRIVATE("private");

        private String type;

        private INBOX_TYPE(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

