/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.query;

import cn.leancloud.AVObject;
import cn.leancloud.ops.Utils;
import cn.leancloud.query.QueryOperation;
import cn.leancloud.types.AVGeoPoint;
import cn.leancloud.utils.AVUtils;
import cn.leancloud.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryConditions
implements Cloneable {
    Map<String, List<QueryOperation>> where = new HashMap<String, List<QueryOperation>>();
    private List<String> include = new LinkedList<String>();
    private Set<String> selectedKeys;
    private int limit;
    private boolean trace;
    private int skip = -1;
    private String order;
    private Map<String, String> parameters = new HashMap<String, String>();

    public QueryConditions clone() {
        QueryConditions condition = new QueryConditions();
        condition.where.putAll(this.where);
        condition.include.addAll(this.include);
        condition.parameters.putAll(this.parameters);
        condition.selectKeys(this.selectedKeys);
        condition.setLimit(this.limit);
        condition.setTrace(this.trace);
        condition.setSkip(this.skip);
        condition.setOrder(this.order);
        return condition;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public void setInclude(List<String> include) {
        this.include = include;
    }

    public Set<String> getSelectedKeys() {
        return this.selectedKeys;
    }

    public void setSelectedKeys(Set<String> selectedKeys) {
        this.selectedKeys = selectedKeys;
    }

    public Map<String, List<QueryOperation>> getWhere() {
        return this.where;
    }

    public void setWhere(Map<String, List<QueryOperation>> where) {
        this.where = where;
    }

    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this.parameters);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void addAscendingOrder(String key) {
        if (StringUtil.isEmpty(this.order)) {
            this.orderByAscending(key);
            return;
        }
        this.order = String.format("%s,%s", this.order, key);
    }

    public void orderByAscending(String key) {
        this.order = String.format("%s", key);
    }

    public void addDescendingOrder(String key) {
        if (StringUtil.isEmpty(this.order)) {
            this.orderByDescending(key);
            return;
        }
        this.order = String.format("%s,-%s", this.order, key);
    }

    public void orderByDescending(String key) {
        this.order = String.format("-%s", key);
    }

    public void include(String key) {
        this.include.add(key);
    }

    public void selectKeys(Collection<String> keys) {
        if (this.selectedKeys == null) {
            this.selectedKeys = new HashSet<String>();
        }
        if (null != keys) {
            this.selectedKeys.addAll(keys);
        }
    }

    public Map<String, Object> compileWhereOperationMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        block4: for (Map.Entry<String, List<QueryOperation>> entry : this.where.entrySet()) {
            ArrayList<Object> opList;
            List<QueryOperation> ops = entry.getValue();
            String key = entry.getKey();
            if (key.equals("$or")) {
                opList = new ArrayList<Object>();
                for (QueryOperation op : ops) {
                    opList.add(op.toResult());
                }
                List existsOr = (List)result.get("$or");
                if (existsOr != null) {
                    existsOr.addAll(opList);
                    continue;
                }
                result.put("$or", opList);
                continue;
            }
            if (key.equals("$and")) {
                opList = new ArrayList();
                for (QueryOperation op : ops) {
                    opList.add(op.getValue());
                }
                List existsAnd = (List)result.get("$and");
                if (existsAnd != null) {
                    existsAnd.addAll(opList);
                    continue;
                }
                result.put("$and", opList);
                continue;
            }
            switch (ops.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    for (QueryOperation op : ops) {
                        result.put(key, op.toResult());
                    }
                    continue block4;
                }
            }
            ArrayList<Object> opList2 = new ArrayList<Object>();
            HashMap opMap = new HashMap();
            boolean hasEqual = false;
            for (QueryOperation op : ops) {
                opList2.add(op.toResult(key));
                if ("__eq".equals(op.getOp())) {
                    hasEqual = true;
                }
                if (hasEqual) continue;
                opMap.putAll((Map)op.toResult());
            }
            if (hasEqual) {
                List existsAnd = (List)result.get("$and");
                if (existsAnd != null) {
                    existsAnd.addAll(opList2);
                    continue;
                }
                result.put("$and", opList2);
                continue;
            }
            result.put(key, opMap);
        }
        return result;
    }

    public Map<String, String> assembleParameters() {
        if (this.where.keySet().size() > 0) {
            Map<String, Object> whereMaps = this.compileWhereOperationMap();
            String whereValue = "";
            whereValue = null == whereMaps ? "{}" : AVUtils.jsonStringFromMapWithNull(Utils.getParsedMap(whereMaps));
            this.parameters.put("where", whereValue);
        }
        if (this.limit > 0) {
            this.parameters.put("limit", Integer.toString(this.limit));
        }
        if (this.skip >= 0) {
            this.parameters.put("skip", Integer.toString(this.skip));
        }
        if (!StringUtil.isEmpty(this.order)) {
            this.parameters.put("order", this.order);
        }
        if (null != this.include && this.include.size() > 0) {
            String value = StringUtil.join(",", this.include);
            this.parameters.put("include", value);
        }
        if (this.selectedKeys != null && this.selectedKeys.size() > 0) {
            String keys = StringUtil.join(",", this.selectedKeys);
            this.parameters.put("keys", keys);
        }
        return this.parameters;
    }

    public void addWhereItem(QueryOperation op) {
        List<QueryOperation> ops = this.where.get(op.getKey());
        if (ops == null) {
            ops = new LinkedList<QueryOperation>();
            this.where.put(op.getKey(), ops);
        }
        this.removeDuplications(op, ops);
        ops.add(op);
    }

    public void addWhereItem(String key, String op, Object value) {
        this.addWhereItem(new QueryOperation(key, op, value));
    }

    private void removeDuplications(QueryOperation op, List<QueryOperation> ops) {
        Iterator<QueryOperation> it = ops.iterator();
        while (it.hasNext()) {
            QueryOperation o = it.next();
            if (!o.sameOp(op)) continue;
            it.remove();
        }
    }

    public void addOrItems(QueryOperation op) {
        List<QueryOperation> ops = this.where.get("$or");
        if (ops == null) {
            ops = new LinkedList<QueryOperation>();
            this.where.put("$or", ops);
        }
        Iterator<QueryOperation> it = ops.iterator();
        while (it.hasNext()) {
            QueryOperation o = it.next();
            if (!o.equals(op)) continue;
            it.remove();
        }
        ops.add(op);
    }

    public void addAndItems(QueryConditions conditions) {
        Map<String, Object> queryOperationMap = conditions.compileWhereOperationMap();
        QueryOperation op = new QueryOperation("$and", "$and", queryOperationMap);
        List<QueryOperation> ops = this.where.get("$and");
        if (ops == null) {
            ops = new LinkedList<QueryOperation>();
            this.where.put("$and", ops);
        }
        Iterator<QueryOperation> it = ops.iterator();
        while (it.hasNext()) {
            QueryOperation o = it.next();
            if (!o.equals(op)) continue;
            it.remove();
        }
        ops.add(op);
    }

    public void whereWithinRadians(String key, AVGeoPoint point, double maxDistance) {
        this.whereWithinRadians(key, point, maxDistance, -1.0);
    }

    public void whereWithinRadians(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        Map<String, Object> map = AVUtils.createMap("$nearSphere", Utils.mapFromGeoPoint(point));
        if (maxDistance >= 0.0) {
            map.put("$maxDistanceInRadians", maxDistance);
        }
        if (minDistance >= 0.0) {
            map.put("$minDistanceInRadians", minDistance);
        }
        this.addWhereItem(new QueryOperation(key, null, map));
    }

    public void whereGreaterThanOrEqualTo(String key, Object value) {
        this.addWhereItem(new QueryOperation(key, "$gte", value));
    }

    public void whereContainedIn(String key, Collection<? extends Object> values) {
        this.addWhereItem(key, "$in", values);
    }

    public void whereExists(String key) {
        this.addWhereItem(key, "$exists", true);
    }

    public void whereGreaterThan(String key, Object value) {
        this.addWhereItem(key, "$gt", value);
    }

    public void whereLessThan(String key, Object value) {
        this.addWhereItem(key, "$lt", value);
    }

    public void whereLessThanOrEqualTo(String key, Object value) {
        this.addWhereItem(key, "$lte", value);
    }

    public void whereMatches(String key, String regex) {
        this.addWhereItem(key, "$regex", regex);
    }

    public void whereMatches(String key, String regex, String modifiers) {
        this.addWhereItem(key, "$regex", regex);
        this.addWhereItem(key, "$options", modifiers);
    }

    public void whereNear(String key, AVGeoPoint point) {
        this.addWhereItem(key, "$nearSphere", Utils.mapFromGeoPoint(point));
    }

    public void whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.addWhereItem(key, "$nin", values);
    }

    public void whereNotEqualTo(String key, Object value) {
        this.addWhereItem(key, "$ne", value);
    }

    public void whereEqualTo(String key, Object value) {
        if (value instanceof AVObject) {
            this.addWhereItem(key, "__eq", Utils.mapFromPointerObject((AVObject)value));
        } else {
            this.addWhereItem(key, "__eq", value);
        }
    }

    public void whereStartsWith(String key, String prefix) {
        this.whereMatches(key, String.format("^%s.*", prefix));
    }

    public void whereWithinGeoBox(String key, AVGeoPoint southwest, AVGeoPoint northeast) {
        LinkedList<Map<String, Object>> box = new LinkedList<Map<String, Object>>();
        box.add(Utils.mapFromGeoPoint(southwest));
        box.add(Utils.mapFromGeoPoint(northeast));
        Map<String, Object> map = AVUtils.createMap("$box", box);
        this.addWhereItem(key, "$within", map);
    }

    public void whereWithinKilometers(String key, AVGeoPoint point, double maxDistance) {
        this.whereWithinKilometers(key, point, maxDistance, -1.0);
    }

    public void whereWithinKilometers(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        Map<String, Object> map = AVUtils.createMap("$nearSphere", Utils.mapFromGeoPoint(point));
        if (maxDistance >= 0.0) {
            map.put("$maxDistanceInKilometers", maxDistance);
        }
        if (minDistance >= 0.0) {
            map.put("$minDistanceInKilometers", minDistance);
        }
        this.addWhereItem(key, null, map);
    }

    public void whereWithinMiles(String key, AVGeoPoint point, double maxDistance) {
        this.whereWithinMiles(key, point, maxDistance, -1.0);
    }

    public void whereWithinMiles(String key, AVGeoPoint point, double maxDistance, double minDistance) {
        Map<String, Object> map = AVUtils.createMap("$nearSphere", Utils.mapFromGeoPoint(point));
        if (maxDistance >= 0.0) {
            map.put("$maxDistanceInMiles", maxDistance);
        }
        if (minDistance >= 0.0) {
            map.put("$minDistanceInMiles", minDistance);
        }
        this.addWhereItem(key, null, map);
    }

    public void whereEndsWith(String key, String suffix) {
        this.whereMatches(key, String.format(".*%s$", suffix));
    }

    public void whereContains(String key, String substring) {
        String regex = String.format(".*%s.*", substring);
        this.whereMatches(key, regex);
    }

    public void whereSizeEqual(String key, int size) {
        this.addWhereItem(key, "$size", size);
    }

    public void whereContainsAll(String key, Collection<?> values) {
        this.addWhereItem(key, "$all", values);
    }

    public void whereDoesNotExist(String key) {
        this.addWhereItem(key, "$exists", false);
    }
}

