/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.PaasClient;
import cn.leancloud.service.PushService;
import cn.leancloud.utils.ErrorUtils;
import com.alibaba.fastjson.JSONObject;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.Map;
import okhttp3.OkHttpClient;

public class PushClient {
    private PushService service = null;
    private boolean asynchronized = false;
    private AppConfiguration.SchedulerCreator defaultCreator = null;

    public PushClient(PushService service, boolean asyncRequest, AppConfiguration.SchedulerCreator observerSchedulerCreator) {
        this.service = service;
        this.asynchronized = AppConfiguration.isAsynchronized();
        this.defaultCreator = AppConfiguration.getDefaultScheduler();
        OkHttpClient httpClient = PaasClient.getGlobalOkHttpClient();
    }

    public Observable<JSONObject> sendPushRequest(Map<String, Object> param) {
        return this.wrapObservable(this.service.sendPushRequest(new JSONObject(param)));
    }

    private Observable wrapObservable(Observable observable) {
        if (null == observable) {
            return null;
        }
        if (this.asynchronized) {
            observable = observable.subscribeOn(Schedulers.io());
        }
        if (null != this.defaultCreator) {
            observable = observable.observeOn(this.defaultCreator.create());
        }
        observable = observable.onErrorResumeNext((Function)new Function<Throwable, ObservableSource>(){

            public ObservableSource apply(Throwable throwable) throws Exception {
                return Observable.error((Throwable)ErrorUtils.propagateException(throwable));
            }
        });
        return observable;
    }
}

