/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVACL;
import cn.leancloud.AVException;
import cn.leancloud.AVFile;
import cn.leancloud.AVLogger;
import cn.leancloud.AVQuery;
import cn.leancloud.AVRelation;
import cn.leancloud.AVSaveOption;
import cn.leancloud.ArchivedRequests;
import cn.leancloud.ObjectTypeAdapter;
import cn.leancloud.ObjectValueFilter;
import cn.leancloud.Transformer;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.PaasClient;
import cn.leancloud.network.NetworkingDetector;
import cn.leancloud.ops.CompoundOperation;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.ops.OperationBuilder;
import cn.leancloud.ops.Utils;
import cn.leancloud.types.AVDate;
import cn.leancloud.types.AVGeoPoint;
import cn.leancloud.types.AVNull;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

@JSONType(deserializer=ObjectTypeAdapter.class, serializer=ObjectTypeAdapter.class)
public class AVObject {
    public static final String KEY_CREATED_AT = "createdAt";
    public static final String KEY_UPDATED_AT = "updatedAt";
    public static final String KEY_OBJECT_ID = "objectId";
    public static final String KEY_ACL = "ACL";
    public static final String KEY_CLASSNAME = "className";
    private static final String INTERNAL_PATTERN = "^[\\da-z][\\d-a-z]*$";
    private static final Set<String> RESERVED_ATTRS = new HashSet<String>(Arrays.asList("createdAt", "updatedAt", "objectId", "ACL"));
    protected static final AVLogger logger = LogUtil.getLogger(AVObject.class);
    protected static final int UUID_LEN = UUID.randomUUID().toString().length();
    protected String className;
    protected String endpointClassName = null;
    protected String objectId = "";
    protected Map<String, Object> serverData = new ConcurrentHashMap<String, Object>();
    protected Map<String, ObjectFieldOperation> operations = new ConcurrentHashMap<String, ObjectFieldOperation>();
    protected AVACL acl = null;
    private String uuid = null;
    @JSONField(serialize=false)
    private volatile boolean fetchWhenSave = false;
    protected volatile boolean totallyOverwrite = false;

    public AVObject() {
        this.className = Transformer.getSubClassName(this.getClass());
    }

    public AVObject(String className) {
        Transformer.checkClassName(className);
        this.className = className;
    }

    public AVObject(AVObject other) {
        this.className = other.className;
        this.objectId = other.objectId;
        this.serverData.putAll(other.serverData);
        this.operations.putAll(other.operations);
        this.acl = other.acl;
        this.endpointClassName = other.endpointClassName;
    }

    public String getClassName() {
        return this.className;
    }

    public String internalClassName() {
        return this.getClassName();
    }

    public void setClassName(String name) {
        Transformer.checkClassName(name);
        this.className = name;
    }

    public String getCreatedAt() {
        return (String)this.serverData.get(KEY_CREATED_AT);
    }

    public String getUpdatedAt() {
        return (String)this.serverData.get(KEY_UPDATED_AT);
    }

    public String getObjectId() {
        if (this.serverData.containsKey(KEY_OBJECT_ID)) {
            return (String)this.serverData.get(KEY_OBJECT_ID);
        }
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
        if (null != this.serverData) {
            this.serverData.put(KEY_OBJECT_ID, objectId);
        }
    }

    public boolean isFetchWhenSave() {
        return this.fetchWhenSave;
    }

    public void setFetchWhenSave(boolean fetchWhenSave) {
        this.fetchWhenSave = fetchWhenSave;
    }

    public String getUuid() {
        if (StringUtil.isEmpty(this.uuid)) {
            this.uuid = UUID.randomUUID().toString().toLowerCase();
        }
        return this.uuid;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    protected static boolean verifyInternalId(String internalId) {
        return Pattern.matches(INTERNAL_PATTERN, internalId);
    }

    protected String internalId() {
        return StringUtil.isEmpty(this.getObjectId()) ? this.getUuid() : this.getObjectId();
    }

    public boolean containsKey(String key) {
        return this.serverData.containsKey(key);
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public Object get(String key) {
        Object value = this.serverData.get(key);
        ObjectFieldOperation op = this.operations.get(key);
        if (null != op) {
            value = op.apply(value);
        }
        return value;
    }

    public boolean getBoolean(String key) {
        Boolean b = (Boolean)this.get(key);
        return b == null ? false : b;
    }

    public byte[] getBytes(String key) {
        return (byte[])this.get(key);
    }

    public Date getDate(String key) {
        Object res = this.get(key);
        if (res instanceof Date) {
            return (Date)res;
        }
        JSONObject rawData = (JSONObject)this.get(key);
        if (null == rawData) {
            return null;
        }
        AVDate date = new AVDate((JSONObject)this.get(key));
        return date.getDate();
    }

    public String getString(String key) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public int getInt(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        Number v = (Number)this.get(key);
        if (v != null) {
            return v.longValue();
        }
        return 0L;
    }

    public double getDouble(String key) {
        Number number = (Number)this.get(key);
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    public Number getNumber(String key) {
        return (Number)this.get(key);
    }

    public JSONArray getJSONArray(String key) {
        Object list = this.get(key);
        if (list == null) {
            return null;
        }
        if (list instanceof JSONArray) {
            return (JSONArray)list;
        }
        if (list instanceof List) {
            return new JSONArray((List)list);
        }
        if (list instanceof Object[]) {
            JSONArray array = new JSONArray();
            for (Object obj : (Object[])list) {
                array.add(obj);
            }
            return array;
        }
        return null;
    }

    public JSONObject getJSONObject(String key) {
        Object object = this.get(key);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        String jsonString = JSON.toJSONString((Object)object);
        JSONObject jsonObject = null;
        try {
            jsonObject = JSON.parseObject((String)jsonString);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Invalid json string", exception);
        }
        return jsonObject;
    }

    public AVGeoPoint getAVGeoPoint(String key) {
        return (AVGeoPoint)this.get(key);
    }

    public AVFile getAVFile(String key) {
        return (AVFile)this.get(key);
    }

    public <T extends AVObject> T getAVObject(String key) {
        try {
            return (T)((AVObject)this.get(key));
        }
        catch (Exception ex) {
            logger.w("failed to convert Object.", ex);
            return null;
        }
    }

    public <T extends AVObject> AVRelation<T> getRelation(String key) {
        this.validFieldName(key);
        Object object = this.get(key);
        if (object instanceof AVRelation) {
            ((AVRelation)object).setParent(this);
            ((AVRelation)object).setKey(key);
            return (AVRelation)object;
        }
        return new AVRelation(this, key);
    }

    void addRelation(AVObject object, String key) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.AddRelation, key, object);
        this.addNewOperation(op);
    }

    void removeRelation(AVObject object, String key) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.RemoveRelation, key, object);
        this.addNewOperation(op);
    }

    public List getList(String key) {
        return (List)this.get(key);
    }

    public Map<String, Object> getServerData() {
        return this.serverData;
    }

    protected void validFieldName(String key) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("Blank key");
        }
        if (key.startsWith("_")) {
            throw new IllegalArgumentException("key should not start with '_'");
        }
        if (RESERVED_ATTRS.contains(key)) {
            throw new IllegalArgumentException("key(" + key + ") is reserved by LeanCloud");
        }
    }

    @JSONField(serialize=false)
    public boolean isDataAvailable() {
        return !StringUtil.isEmpty(this.objectId) && !this.serverData.isEmpty();
    }

    public void add(String key, Object value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Add, key, value);
        this.addNewOperation(op);
    }

    public void addAll(String key, Collection<?> values) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Add, key, values);
        this.addNewOperation(op);
    }

    public void addUnique(String key, Object value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.AddUnique, key, value);
        this.addNewOperation(op);
    }

    public void addAllUnique(String key, Collection<?> values) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.AddUnique, key, values);
        this.addNewOperation(op);
    }

    public void put(String key, Object value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Set, key, value);
        this.addNewOperation(op);
    }

    public void remove(String key) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Delete, key, null);
        this.addNewOperation(op);
    }

    public void removeAll(String key, Collection<?> values) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Remove, key, values);
        this.addNewOperation(op);
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, Number value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Increment, key, value);
        this.addNewOperation(op);
    }

    public void decrement(String key) {
        this.decrement(key, 1);
    }

    public void decrement(String key, Number value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Decrement, key, value);
        this.addNewOperation(op);
    }

    public void bitAnd(String key, long value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.BitAnd, key, value);
        this.addNewOperation(op);
    }

    public void bitOr(String key, long value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.BitOr, key, value);
        this.addNewOperation(op);
    }

    public void bitXor(String key, long value) {
        this.validFieldName(key);
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.BitXor, key, value);
        this.addNewOperation(op);
    }

    protected void addNewOperation(ObjectFieldOperation op) {
        if (null == op) {
            return;
        }
        if (this.totallyOverwrite) {
            if ("Delete".equalsIgnoreCase(op.getOperation())) {
                this.serverData.remove(op.getField());
            } else {
                Object oldValue = this.serverData.get(op.getField());
                Object newValue = op.apply(oldValue);
                if (null == newValue) {
                    this.serverData.remove(op.getField());
                } else {
                    this.serverData.put(op.getField(), newValue);
                }
            }
        } else {
            ObjectFieldOperation previous = null;
            if (this.operations.containsKey(op.getField())) {
                previous = this.operations.get(op.getField());
            }
            this.operations.put(op.getField(), op.merge(previous));
        }
    }

    private boolean needBatchMode() {
        for (ObjectFieldOperation op : this.operations.values()) {
            if (!(op instanceof CompoundOperation)) continue;
            return true;
        }
        return false;
    }

    protected JSONObject generateChangedParam() {
        AVACL serverACL;
        if (this.totallyOverwrite) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.putAll(this.serverData);
            tmp.remove(KEY_CREATED_AT);
            tmp.remove(KEY_UPDATED_AT);
            tmp.remove(KEY_OBJECT_ID);
            return new JSONObject(tmp);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Set<Map.Entry<String, ObjectFieldOperation>> entries = this.operations.entrySet();
        for (Map.Entry<String, ObjectFieldOperation> entry : entries) {
            Map<String, Object> oneOp = entry.getValue().encode();
            params.putAll(oneOp);
        }
        if (null != this.acl && !this.acl.equals(serverACL = this.generateACLFromServerData())) {
            ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Set, KEY_ACL, this.acl);
            params.putAll(op.encode());
        }
        if (!this.needBatchMode()) {
            return new JSONObject(params);
        }
        ArrayList<Map<String, Object>> finalParams = new ArrayList<Map<String, Object>>();
        Map<String, Object> topParams = Utils.makeCompletedRequest(this.getObjectId(), this.getRequestRawEndpoint(), this.getRequestMethod(), params);
        if (null != topParams) {
            finalParams.add(topParams);
        }
        for (ObjectFieldOperation ops : this.operations.values()) {
            List<Map<String, Object>> restParams;
            if (!(ops instanceof CompoundOperation) || null == (restParams = ((CompoundOperation)ops).encodeRestOp(this)) || restParams.isEmpty()) continue;
            finalParams.addAll(restParams);
        }
        HashMap<String, ArrayList<Map<String, Object>>> finalResult = new HashMap<String, ArrayList<Map<String, Object>>>(1);
        finalResult.put("requests", finalParams);
        return new JSONObject(finalResult);
    }

    protected List<AVObject> extractCascadingObjects(Object o) {
        ArrayList<AVObject> result = new ArrayList<AVObject>();
        if (o instanceof AVObject && StringUtil.isEmpty(((AVObject)o).getObjectId())) {
            result.add((AVObject)o);
        } else if (o instanceof Collection) {
            for (Object secondO : ((Collection)o).toArray()) {
                List<AVObject> tmp = this.extractCascadingObjects(secondO);
                if (null == tmp || tmp.isEmpty()) continue;
                result.addAll(tmp);
            }
        }
        return result;
    }

    protected Observable<List<AVObject>> getCascadingSaveObjects() {
        ArrayList<AVObject> result = new ArrayList<AVObject>();
        for (ObjectFieldOperation ofo : this.operations.values()) {
            List<AVObject> operationValues = this.extractCascadingObjects(ofo.getValue());
            if (null == operationValues || operationValues.isEmpty()) continue;
            result.addAll(operationValues);
        }
        return Observable.just(result).subscribeOn(Schedulers.io());
    }

    private Observable<? extends AVObject> saveSelfOperations(AVSaveOption option) {
        String currentClass;
        boolean needFetch;
        boolean bl = needFetch = null != option ? option.fetchWhenSave : this.isFetchWhenSave();
        if (null != option && null != option.matchQuery && !StringUtil.isEmpty(currentClass = this.getClassName()) && !currentClass.equals(option.matchQuery.getClassName())) {
            return Observable.error((Throwable)new AVException(0, "AVObject class inconsistant with AVQuery in AVSaveOption"));
        }
        JSONObject paramData = this.generateChangedParam();
        logger.i("saveObject param: " + paramData.toJSONString());
        final String currentObjectId = this.getObjectId();
        if (this.needBatchMode()) {
            logger.w("Caution: batch mode will ignore fetchWhenSave flag and matchQuery.");
            if (StringUtil.isEmpty(currentObjectId)) {
                logger.d("request payload: " + paramData.toJSONString());
                return PaasClient.getStorageClient().batchSave(paramData).map((Function)new Function<JSONArray, AVObject>(){

                    public AVObject apply(JSONArray object) throws Exception {
                        if (null != object && !object.isEmpty()) {
                            logger.d("batchSave result: " + object.toJSONString());
                            Map lastResult = (Map)object.getObject(object.size() - 1, Map.class);
                            if (null != lastResult) {
                                AVObject.this.serverData.putAll(lastResult);
                                AVObject.this.operations.clear();
                            }
                        }
                        return AVObject.this;
                    }
                });
            }
            return PaasClient.getStorageClient().batchUpdate(paramData).map((Function)new Function<JSONObject, AVObject>(){

                public AVObject apply(JSONObject object) throws Exception {
                    if (null != object) {
                        logger.d("batchUpdate result: " + object.toJSONString());
                        Map lastResult = (Map)object.getObject(currentObjectId, Map.class);
                        if (null != lastResult) {
                            AVObject.this.serverData.putAll(lastResult);
                            AVObject.this.operations.clear();
                        }
                    }
                    return AVObject.this;
                }
            });
        }
        JSONObject whereCondition = null;
        if (null != option && null != option.matchQuery) {
            Map<String, Object> whereOperationMap = option.matchQuery.conditions.compileWhereOperationMap();
            whereCondition = new JSONObject(whereOperationMap);
        }
        if (this.totallyOverwrite) {
            return PaasClient.getStorageClient().saveWholeObject(this.getClass(), this.endpointClassName, currentObjectId, paramData, needFetch, whereCondition);
        }
        if (StringUtil.isEmpty(currentObjectId)) {
            return PaasClient.getStorageClient().createObject(this.className, paramData, needFetch, whereCondition).map((Function)new Function<AVObject, AVObject>(){

                public AVObject apply(AVObject avObject) throws Exception {
                    AVObject.this.mergeRawData(avObject);
                    return AVObject.this;
                }
            });
        }
        return PaasClient.getStorageClient().saveObject(this.className, this.getObjectId(), paramData, needFetch, whereCondition).map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) throws Exception {
                AVObject.this.mergeRawData(avObject);
                return AVObject.this;
            }
        });
    }

    public Observable<? extends AVObject> saveInBackground() {
        return this.saveInBackground(null);
    }

    public Observable<? extends AVObject> saveInBackground(final AVSaveOption option) {
        HashMap<AVObject, Boolean> markMap = new HashMap<AVObject, Boolean>();
        if (this.hasCircleReference(markMap)) {
            return Observable.error((Throwable)new AVException(100001, "Found a circular dependency when saving."));
        }
        Observable<List<AVObject>> needSaveFirstly = this.getCascadingSaveObjects();
        return (Observable)needSaveFirstly.to((Function)new Function<Observable<List<AVObject>>, Observable<? extends AVObject>>(){

            public Observable<? extends AVObject> apply(Observable<List<AVObject>> avNullObservable) throws Exception {
                for (AVObject o : (List)avNullObservable.blockingLast()) {
                    o.save();
                }
                logger.d("secondly, save object itself...");
                return AVObject.this.saveSelfOperations(option);
            }
        });
    }

    public boolean hasCircleReference(Map<AVObject, Boolean> markMap) {
        if (null == markMap) {
            return false;
        }
        markMap.put(this, true);
        boolean rst = false;
        for (ObjectFieldOperation op : this.operations.values()) {
            rst = rst || op.checkCircleReference(markMap);
        }
        return rst;
    }

    public void save() {
        this.saveInBackground().blockingSubscribe();
    }

    public static void saveAll(Collection<? extends AVObject> objects) throws AVException {
        AVObject.saveAllInBackground(objects).blockingSubscribe();
    }

    public static Observable<JSONArray> saveAllInBackground(final Collection<? extends AVObject> objects) {
        if (null == objects || objects.isEmpty()) {
            JSONArray emptyResult = new JSONArray();
            return Observable.just((Object)emptyResult);
        }
        JSONArray requests = new JSONArray();
        for (AVObject aVObject : objects) {
            HashMap<AVObject, Boolean> markMap;
            if (aVObject.hasCircleReference(markMap = new HashMap<AVObject, Boolean>())) {
                return Observable.error((Throwable)new AVException(100001, "Found a circular dependency when saving."));
            }
            JSONObject requestBody = aVObject.generateChangedParam();
            JSONObject objectRequest = new JSONObject();
            objectRequest.put("method", (Object)aVObject.getRequestMethod());
            objectRequest.put("path", (Object)aVObject.getRequestRawEndpoint());
            objectRequest.put("body", (Object)requestBody);
            requests.add((Object)objectRequest);
        }
        JSONObject requestTotal = new JSONObject();
        requestTotal.put("requests", (Object)requests);
        return PaasClient.getStorageClient().batchSave(requestTotal).map((Function)new Function<JSONArray, JSONArray>(){

            public JSONArray apply(JSONArray batchResults) throws Exception {
                if (null != batchResults && objects.size() == batchResults.size()) {
                    logger.d("batchSave result: " + batchResults.toJSONString());
                    Iterator it = objects.iterator();
                    for (int i = 0; i < batchResults.size() && it.hasNext(); ++i) {
                        JSONObject oneResult = batchResults.getJSONObject(i);
                        AVObject originObject = (AVObject)it.next();
                        if (oneResult.containsKey((Object)"success")) {
                            originObject.serverData.putAll((Map<String, Object>)oneResult.getJSONObject("success"));
                            originObject.operations.clear();
                            continue;
                        }
                        if (!oneResult.containsKey((Object)"error")) continue;
                    }
                }
                return batchResults;
            }
        });
    }

    public void saveEventually() throws AVException {
        if (this.operations.isEmpty()) {
            return;
        }
        HashMap<AVObject, Boolean> markMap = new HashMap<AVObject, Boolean>();
        if (this.hasCircleReference(markMap)) {
            throw new AVException(100001, "Found a circular dependency when saving.");
        }
        NetworkingDetector detector = AppConfiguration.getGlobalNetworkingDetector();
        if (null != detector && detector.isConnected()) {
            this.saveInBackground().subscribe((Observer)new Observer<AVObject>(){

                public void onSubscribe(Disposable disposable) {
                }

                public void onNext(AVObject avObject) {
                    logger.d("succeed to save directly");
                }

                public void onError(Throwable throwable) {
                    AVObject.this.add2ArchivedRequest(false);
                }

                public void onComplete() {
                }
            });
        } else {
            this.add2ArchivedRequest(false);
        }
    }

    private void add2ArchivedRequest(boolean isDelete) {
        ArchivedRequests requests = ArchivedRequests.getInstance();
        if (isDelete) {
            requests.deleteEventually(this);
        } else {
            requests.saveEventually(this);
        }
    }

    public void deleteEventually() {
        String objectId = this.getObjectId();
        if (StringUtil.isEmpty(objectId)) {
            logger.w("objectId is empty, you couldn't delete a persistent object.");
            return;
        }
        NetworkingDetector detector = AppConfiguration.getGlobalNetworkingDetector();
        if (null != detector && detector.isConnected()) {
            this.deleteInBackground().subscribe((Observer)new Observer<AVNull>(){

                public void onSubscribe(Disposable disposable) {
                }

                public void onNext(AVNull avNull) {
                    logger.d("succeed to delete directly.");
                }

                public void onError(Throwable throwable) {
                    AVObject.this.add2ArchivedRequest(true);
                }

                public void onComplete() {
                }
            });
        } else {
            this.add2ArchivedRequest(true);
        }
    }

    public Observable<AVNull> deleteInBackground() {
        if (this.totallyOverwrite) {
            return PaasClient.getStorageClient().deleteWholeObject(this.endpointClassName, this.getObjectId());
        }
        return PaasClient.getStorageClient().deleteObject(this.className, this.getObjectId());
    }

    public void delete() {
        this.deleteInBackground().blockingSubscribe();
    }

    public static void deleteAll(Collection<? extends AVObject> objects) throws AVException {
        AVObject.deleteAllInBackground(objects).blockingSubscribe();
    }

    public static Observable<AVNull> deleteAllInBackground(Collection<? extends AVObject> objects) {
        if (null == objects || objects.isEmpty()) {
            return Observable.just((Object)AVNull.getINSTANCE());
        }
        String className = null;
        StringBuilder sb = new StringBuilder();
        for (AVObject aVObject : objects) {
            if (StringUtil.isEmpty(aVObject.getObjectId()) || StringUtil.isEmpty(aVObject.getClassName())) {
                return Observable.error((Throwable)new IllegalArgumentException("Invalid AVObject, the class name or objectId is blank."));
            }
            if (className == null) {
                className = aVObject.getClassName();
                sb.append(aVObject.getObjectId());
                continue;
            }
            if (className.equals(aVObject.getClassName())) {
                sb.append(",").append(aVObject.getObjectId());
                continue;
            }
            return Observable.error((Throwable)new IllegalArgumentException("The objects class name must be the same."));
        }
        return PaasClient.getStorageClient().deleteObject(className, sb.toString());
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(String includeKeys) {
        this.refreshInBackground(includeKeys).blockingSubscribe();
    }

    public Observable<AVObject> refreshInBackground() {
        return this.refreshInBackground(null);
    }

    public Observable<AVObject> refreshInBackground(String includeKeys) {
        if (this.totallyOverwrite) {
            return PaasClient.getStorageClient().getWholeObject(this.endpointClassName, this.getObjectId()).map((Function)new Function<AVObject, AVObject>(){

                public AVObject apply(AVObject avObject) throws Exception {
                    AVObject.this.serverData.clear();
                    AVObject.this.serverData.putAll(avObject.serverData);
                    return AVObject.this;
                }
            });
        }
        return PaasClient.getStorageClient().fetchObject(this.className, this.getObjectId(), includeKeys).map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) throws Exception {
                AVObject.this.serverData.clear();
                AVObject.this.serverData.putAll(avObject.serverData);
                return AVObject.this;
            }
        });
    }

    public AVObject fetch() {
        return this.fetch(null);
    }

    public AVObject fetch(String includeKeys) {
        this.refresh(includeKeys);
        return this;
    }

    public Observable<AVObject> fetchInBackground() {
        return this.refreshInBackground();
    }

    public Observable<AVObject> fetchInBackground(String includeKyes) {
        return this.refreshInBackground(includeKyes);
    }

    public Observable<AVObject> fetchIfNeededInBackground() {
        if (!StringUtil.isEmpty(this.getObjectId()) && this.serverData.size() > 1) {
            return Observable.just((Object)this);
        }
        return this.refreshInBackground();
    }

    public AVObject fetchIfNeeded() {
        this.fetchIfNeededInBackground().blockingSubscribe();
        return this;
    }

    protected void resetAll() {
        this.objectId = "";
        this.acl = null;
        this.serverData.clear();
        this.operations.clear();
    }

    protected void resetByRawData(AVObject avObject) {
        this.resetAll();
        if (null != avObject) {
            this.serverData.putAll(avObject.serverData);
            this.operations.putAll(avObject.operations);
        }
    }

    void mergeRawData(AVObject avObject) {
        if (null != avObject) {
            this.serverData.putAll(avObject.serverData);
        }
        this.operations.clear();
    }

    public void resetServerData(Map data) {
        this.serverData.clear();
        this.serverData.putAll(data);
        this.operations.clear();
    }

    @JSONField(serialize=false)
    public String getRequestRawEndpoint() {
        if (StringUtil.isEmpty(this.getObjectId())) {
            return "/1.1/classes/" + this.getClassName();
        }
        return "/1.1/classes/" + this.getClassName() + "/" + this.getObjectId();
    }

    @JSONField(serialize=false)
    public String getRequestMethod() {
        if (StringUtil.isEmpty(this.getObjectId())) {
            return "POST";
        }
        return "PUT";
    }

    public static <T extends AVObject> void registerSubclass(Class<T> clazz) {
        Transformer.registerClass(clazz);
    }

    public synchronized AVACL getACL() {
        if (null == this.acl) {
            this.acl = this.generateACLFromServerData();
        }
        return this.acl;
    }

    public synchronized void setACL(AVACL acl) {
        this.acl = acl;
    }

    protected AVACL generateACLFromServerData() {
        if (!this.serverData.containsKey(KEY_ACL)) {
            return new AVACL();
        }
        Object aclMap = this.serverData.get(KEY_ACL);
        if (aclMap instanceof HashMap) {
            return new AVACL((HashMap)aclMap);
        }
        return new AVACL();
    }

    public static <T extends AVObject> AVQuery<T> getQuery(Class<T> clazz) {
        return new AVQuery<T>(Transformer.getSubClassName(clazz), clazz);
    }

    public JSONObject toJSONObject() {
        return new JSONObject(this.serverData);
    }

    public String toJSONString() {
        return JSON.toJSONString((Object)this, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect});
    }

    public static AVObject parseAVObject(String objectString) {
        if (StringUtil.isEmpty(objectString)) {
            return null;
        }
        objectString = objectString.replaceAll("^\\{\\s*\"@type\":\\s*\"[A-Za-z\\.]+\",", "{");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVObject\",", "\"@type\":\"cn.leancloud.AVObject\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVInstallation\",", "\"@type\":\"cn.leancloud.AVInstallation\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVUser\",", "\"@type\":\"cn.leancloud.AVUser\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVStatus\",", "\"@type\":\"cn.leancloud.AVStatus\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVRole\",", "\"@type\":\"cn.leancloud.AVRole\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.AVFile\",", "\"@type\":\"cn.leancloud.AVFile\",");
        objectString = objectString.replaceAll("\"@type\":\\s*\"com.avos.avoscloud.ops.[A-Za-z]+Op\",", "");
        return (AVObject)JSON.parseObject((String)objectString, AVObject.class, (Feature[])new Feature[]{Feature.SupportAutoType});
    }

    public static AVObject createWithoutData(String className, String objectId) {
        AVObject object = new AVObject(className);
        object.setObjectId(objectId);
        return object;
    }

    public static <T extends AVObject> T createWithoutData(Class<T> clazz, String objectId) throws AVException {
        try {
            AVObject obj = (AVObject)clazz.newInstance();
            obj.setClassName(Transformer.getSubClassName(clazz));
            obj.setObjectId(objectId);
            return (T)obj;
        }
        catch (Exception ex) {
            throw new AVException(ex);
        }
    }

    protected static <T extends AVObject> T cast(AVObject object, Class<T> clazz) throws Exception {
        if (clazz.getClass().isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        AVObject newItem = (AVObject)clazz.newInstance();
        newItem.className = object.className;
        newItem.objectId = object.objectId;
        newItem.serverData.putAll(object.serverData);
        newItem.operations.putAll(object.operations);
        newItem.acl = object.acl;
        newItem.endpointClassName = object.endpointClassName;
        return (T)newItem;
    }

    public String toString() {
        return this.toJSONString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AVObject)) {
            return false;
        }
        AVObject avObject = (AVObject)o;
        return this.isFetchWhenSave() == avObject.isFetchWhenSave() && Objects.equals(this.getClassName(), avObject.getClassName()) && Objects.equals(this.getServerData(), avObject.getServerData()) && Objects.equals(this.operations, avObject.operations) && Objects.equals(this.acl, avObject.acl);
    }

    public int hashCode() {
        return Objects.hash(this.getClassName(), this.getServerData(), this.operations, this.acl, this.isFetchWhenSave());
    }
}

