/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.utils;

import cn.leancloud.utils.FileUtil;
import cn.leancloud.utils.MimeUtils;
import cn.leancloud.utils.StringUtil;
import java.io.File;
import java.nio.file.Files;

public class DefaultMimeTypeDetector
implements FileUtil.MimeTypeDetector {
    @Override
    public String getMimeTypeFromUrl(String url) {
        if (!StringUtil.isEmpty(url)) {
            int filenamePos;
            int query;
            int fragment = url.lastIndexOf(35);
            if (fragment > 0) {
                url = url.substring(0, fragment);
            }
            if ((query = url.lastIndexOf(63)) > 0) {
                url = url.substring(0, query);
            }
            String filename = 0 <= (filenamePos = url.lastIndexOf(47)) ? url.substring(filenamePos + 1) : url;
            String extension = FileUtil.getExtensionFromFilename(filename);
            return this.getMimeTypeFromExtension(extension);
        }
        return "";
    }

    @Override
    public String getMimeTypeFromPath(String localPath) {
        try {
            return Files.probeContentType(new File(localPath).toPath());
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public String getMimeTypeFromExtension(String extension) {
        if (StringUtil.isEmpty(extension)) {
            return "";
        }
        return MimeUtils.guessExtensionFromMimeType(extension);
    }
}

