/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.upload;

import cn.leancloud.AVException;
import cn.leancloud.AVFile;
import cn.leancloud.callback.ProgressCallback;
import cn.leancloud.codec.SHA1;
import cn.leancloud.upload.FileUploader;
import cn.leancloud.upload.HttpClientUploader;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class QCloudUploader
extends HttpClientUploader {
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String FILE_CONTENT = "filecontent";
    private static final String PARAM_OP = "op";
    private static final String PARAM_SHA = "sha";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String PARAM_FILE_SIZE = "filesize";
    private static final String PARAM_SLICE_SIZE = "slice_size";
    private static final String PARAM_OFFSET = "offset";
    private static final String PARAM_SESSION = "session";
    private static final String OP_UPLOAD_SLICE = "upload_slice";
    private static final String OP_UPLOAD = "upload";
    private static final String PARAM_ACCESS_URL = "access_url";
    private static final int RETRY_TIMES = 5;
    private volatile Future[] tasks;
    private String fileSha;
    private String fileKey;
    private String uploadUrl;
    private String token;
    private static final int DEFAULT_SLICE_LEN = 524288;

    QCloudUploader(AVFile avFile, String token, String uploadUrl, ProgressCallback progressCallback) {
        super(avFile, progressCallback);
        this.fileKey = avFile.getKey();
        this.uploadUrl = uploadUrl;
        this.token = token;
    }

    @Override
    public AVException execute() {
        try {
            byte[] bytes = this.avFile.getData();
            int sliceCount = bytes.length / 524288 + (bytes.length % 524288 == 0 ? 0 : 1);
            if (sliceCount > 1) {
                int sliceOffset;
                JSONObject result = this.uploadControlSlice(this.token, this.uploadUrl, bytes);
                if (null == result) {
                    return new AVException(new RuntimeException("Exception during file upload"));
                }
                if (result.containsKey((Object)PARAM_ACCESS_URL)) {
                    return null;
                }
                String sessionId = result.getString(PARAM_SESSION);
                FileUploader.ProgressCalculator progressCalculator = new FileUploader.ProgressCalculator(sliceCount, new FileUploader.FileUploadProgressCallback(){

                    @Override
                    public void onProgress(int progress) {
                        QCloudUploader.this.publishProgress(progress);
                    }
                });
                String sliceUploadResult = "";
                for (sliceOffset = 0; sliceOffset < sliceCount && null != sliceUploadResult; ++sliceOffset) {
                    sliceUploadResult = new SliceUploadTask(this, this.fileKey, this.token, this.uploadUrl, bytes, sliceOffset, sessionId, progressCalculator, null).upload();
                }
                if (sliceOffset < sliceCount) {
                    return new AVException(-1, "failed to upload slice.");
                }
            } else {
                this.uploadFile(bytes);
            }
        }
        catch (Exception e) {
            return new AVException(e);
        }
        return null;
    }

    private void uploadFile(byte[] bytes) throws AVException {
        try {
            this.fileSha = SHA1.compute(bytes);
            MultipartBody.Builder builder = new MultipartBody.Builder();
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)APPLICATION_OCTET_STREAM), (byte[])bytes, (int)0, (int)QCloudUploader.getCurrentSliceLength(0, bytes.length));
            builder.addFormDataPart(FILE_CONTENT, this.fileKey, fileBody);
            builder.addFormDataPart(PARAM_OP, OP_UPLOAD);
            builder.addFormDataPart(PARAM_SHA, this.fileSha);
            MediaType type = MediaType.parse((String)MULTIPART_FORM_DATA);
            if (null != type) {
                builder.setType(type);
            }
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(this.uploadUrl);
            requestBuilder.header(HEADER_AUTHORIZATION, this.token);
            requestBuilder.header(HEADER_CONTENT_TYPE, MULTIPART_FORM_DATA);
            for (String key : FileUploader.UPLOAD_HEADERS.keySet()) {
                requestBuilder.header(key, FileUploader.UPLOAD_HEADERS.get(key));
            }
            requestBuilder.post((RequestBody)builder.build());
            Request request = requestBuilder.build();
            Response response = this.executeWithRetry(request, 5);
            if (response.code() != 200) {
                throw new AVException(-1, StringUtil.stringFromBytes(response.body().bytes()));
            }
        }
        catch (Exception e) {
            throw new AVException("Exception during file upload", e);
        }
    }

    private static JSONObject parseSliceUploadResponse(String resp) {
        if (!StringUtil.isEmpty(resp)) {
            try {
                JSONObject object = JSON.parseObject((String)resp);
                JSONObject data = object.getJSONObject("data");
                return data;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static int getCurrentSliceLength(int sliceCount, int totalSize) {
        int leftSize = totalSize - sliceCount * 524288;
        return leftSize >= 524288 ? 524288 : leftSize;
    }

    private JSONObject uploadControlSlice(String token, String url, byte[] wholeFile) throws AVException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        try {
            String fileSha = SHA1.compute(wholeFile);
            builder.addFormDataPart(PARAM_SHA, fileSha);
            builder.addFormDataPart(PARAM_OP, OP_UPLOAD_SLICE);
            builder.addFormDataPart(PARAM_FILE_SIZE, String.valueOf(wholeFile.length));
            builder.addFormDataPart(PARAM_SLICE_SIZE, String.valueOf(524288));
            MediaType type = MediaType.parse((String)MULTIPART_FORM_DATA);
            if (null != type) {
                builder.setType(type);
            }
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder.url(url);
            requestBuilder.header(HEADER_AUTHORIZATION, token);
            requestBuilder.header(HEADER_CONTENT_TYPE, MULTIPART_FORM_DATA);
            requestBuilder.post((RequestBody)builder.build());
            Request request = requestBuilder.build();
            Response response = this.executeWithRetry(request, 5);
            if (response != null) {
                byte[] responseBody = response.body().bytes();
                return QCloudUploader.parseSliceUploadResponse(StringUtil.stringFromBytes(responseBody));
            }
        }
        catch (Exception e) {
            throw new AVException(-1, "Upload file failure");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void interruptImmediately() {
        super.interruptImmediately();
        if (this.tasks == null || this.tasks.length <= 0) return;
        Future[] futureArray = this.tasks;
        synchronized (this.tasks) {
            for (int index = 0; index < this.tasks.length; ++index) {
                Future task = this.tasks[index];
                if (task == null || task.isDone() || task.isCancelled()) continue;
                task.cancel(true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static class SliceUploadTask
    implements Runnable {
        byte[] data;
        int sliceOffset;
        FileUploader.ProgressCalculator progress;
        String session;
        CountDownLatch latch;
        String token;
        String url;
        String key;
        QCloudUploader parent;

        public SliceUploadTask(QCloudUploader parent, String key, String token, String url, byte[] wholeFile, int sliceOffset, String session, FileUploader.ProgressCalculator progressCalculator, CountDownLatch latch) {
            this.data = wholeFile;
            this.sliceOffset = sliceOffset;
            this.progress = progressCalculator;
            this.session = session;
            this.latch = latch;
            this.token = token;
            this.url = url;
            this.key = key;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.upload();
        }

        public String upload() {
            block6: {
                try {
                    MultipartBody.Builder builder = new MultipartBody.Builder();
                    RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)QCloudUploader.APPLICATION_OCTET_STREAM), (byte[])this.data, (int)(this.sliceOffset * 524288), (int)QCloudUploader.getCurrentSliceLength(this.sliceOffset, this.data.length));
                    builder.addFormDataPart(QCloudUploader.FILE_CONTENT, this.key, fileBody);
                    builder.addFormDataPart(QCloudUploader.PARAM_OP, QCloudUploader.OP_UPLOAD_SLICE);
                    builder.addFormDataPart(QCloudUploader.PARAM_OFFSET, String.valueOf(this.sliceOffset * 524288));
                    builder.addFormDataPart(QCloudUploader.PARAM_SESSION, this.session);
                    MediaType type = MediaType.parse((String)QCloudUploader.MULTIPART_FORM_DATA);
                    if (null != type) {
                        builder.setType(type);
                    }
                    Request.Builder requestBuilder = new Request.Builder();
                    requestBuilder.url(this.url);
                    requestBuilder.header(QCloudUploader.HEADER_AUTHORIZATION, this.token);
                    requestBuilder.header(QCloudUploader.HEADER_CONTENT_TYPE, QCloudUploader.MULTIPART_FORM_DATA);
                    requestBuilder.post((RequestBody)builder.build());
                    Request request = requestBuilder.build();
                    Response response = this.parent.executeWithRetry(request, 5);
                    if (response != null) {
                        byte[] responseBody = response.body().bytes();
                        if (this.progress != null) {
                            this.progress.publishProgress(this.sliceOffset, 100);
                        }
                        return StringUtil.stringFromBytes(responseBody);
                    }
                }
                catch (Exception e) {
                    if (this.latch == null) break block6;
                    for (long count = this.latch.getCount(); count > 0L; --count) {
                        this.latch.countDown();
                    }
                }
            }
            return null;
        }
    }
}

