/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.ops;

import cn.leancloud.ops.AddRelationOperation;
import cn.leancloud.ops.AddUniqueOperation;
import cn.leancloud.ops.BaseOperation;
import cn.leancloud.ops.BitAndOperation;
import cn.leancloud.ops.BitOrOperation;
import cn.leancloud.ops.BitXorOperation;
import cn.leancloud.ops.CompoundOperation;
import cn.leancloud.ops.DecrementOperation;
import cn.leancloud.ops.DeleteOperation;
import cn.leancloud.ops.IncrementOperation;
import cn.leancloud.ops.NullOperation;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.ops.RemoveOperation;
import cn.leancloud.ops.RemoveRelationOperation;
import cn.leancloud.ops.SetOperation;
import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddOperation
extends BaseOperation {
    public AddOperation(String field, Object value) {
        super("Add", field, value, false);
        if (!(value instanceof Collection)) {
            this.value = Arrays.asList(value);
        }
    }

    @Override
    public Object apply(Object obj) {
        if (null == obj) {
            return this.getValue();
        }
        if (obj instanceof List || obj instanceof JSONArray) {
            if (this.value instanceof List) {
                ((Collection)obj).addAll((List)this.value);
            } else {
                ((Collection)obj).add(this.value);
            }
        } else {
            LOGGER.w("cannot apply AddOperation on non list attribute. targetValueType=" + obj.getClass().getSimpleName());
        }
        return obj;
    }

    @Override
    protected ObjectFieldOperation mergeWithPrevious(ObjectFieldOperation other) {
        if (other instanceof SetOperation || other instanceof DeleteOperation) {
            return other;
        }
        if (other instanceof AddOperation) {
            this.value = this.concatCollections(this.value, ((AddOperation)other).value);
            return this;
        }
        if (other instanceof AddUniqueOperation) {
            this.value = this.concatCollections(this.value, ((AddOperation)other).value);
            return this;
        }
        if (other instanceof RemoveOperation) {
            return new CompoundOperation(this.field, other, this);
        }
        if (other instanceof CompoundOperation) {
            return ((CompoundOperation)other).mergeWithPrevious(this);
        }
        if (other instanceof AddRelationOperation || other instanceof RemoveRelationOperation || other instanceof BitAndOperation || other instanceof BitOrOperation || other instanceof BitXorOperation || other instanceof IncrementOperation || other instanceof DecrementOperation) {
            this.reportIllegalOperations(this, other);
        }
        return NullOperation.gInstance;
    }

    @Override
    public Map<String, Object> encode() {
        HashMap<String, Object> opMap = new HashMap<String, Object>(2);
        opMap.put("__op", this.getOperation());
        opMap.put("objects", this.encodeObject(this.getValue()));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(this.getField(), opMap);
        return result;
    }
}

