/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.AVFile;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVQuery;
import cn.leancloud.AVUser;
import cn.leancloud.Transformer;
import cn.leancloud.cache.QueryResultCache;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.ops.Utils;
import cn.leancloud.query.AVQueryResult;
import cn.leancloud.service.APIService;
import cn.leancloud.sms.AVCaptchaDigest;
import cn.leancloud.sms.AVCaptchaOption;
import cn.leancloud.sms.AVCaptchaValidateResult;
import cn.leancloud.types.AVDate;
import cn.leancloud.types.AVNull;
import cn.leancloud.upload.FileUploadToken;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageClient {
    private static AVLogger LOGGER = LogUtil.getLogger(StorageClient.class);
    private APIService apiService = null;
    private boolean asynchronized = false;
    private AppConfiguration.SchedulerCreator defaultCreator = null;
    private QueryResultCache queryResultCache = QueryResultCache.getInstance();
    private AVUser currentUser = null;

    public StorageClient(APIService apiService, boolean asyncRequest, AppConfiguration.SchedulerCreator observerSchedulerCreator) {
        this.apiService = apiService;
        this.asynchronized = asyncRequest;
        this.defaultCreator = observerSchedulerCreator;
    }

    public void setCurrentUser(AVUser newUser) {
        this.currentUser = newUser;
    }

    public AVUser getCurrentUser() {
        return this.currentUser;
    }

    private Observable wrappObservable(Observable observable) {
        if (null == observable) {
            return null;
        }
        if (this.asynchronized) {
            observable = observable.subscribeOn(Schedulers.io());
        }
        if (null != this.defaultCreator) {
            observable = observable.observeOn(this.defaultCreator.create());
        }
        return observable;
    }

    private Observable wrappObservableInBackground(Observable observable) {
        if (null == observable) {
            return null;
        }
        Scheduler scheduler = Schedulers.io();
        if (this.asynchronized) {
            observable = observable.subscribeOn(scheduler);
        }
        if (null != this.defaultCreator) {
            observable = observable.observeOn(scheduler);
        }
        return observable;
    }

    public Observable<AVDate> getServerTime() {
        Observable date = this.wrappObservable(this.apiService.currentTimeMillis());
        return date;
    }

    public Observable<? extends AVObject> fetchObject(final String className, String objectId, String includeKeys) {
        Observable object = null;
        object = StringUtil.isEmpty(includeKeys) ? this.wrappObservable(this.apiService.fetchObject(className, objectId)) : this.wrappObservable(this.apiService.fetchObject(className, objectId, includeKeys));
        if (null == object) {
            return object;
        }
        return object.map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) throws Exception {
                return Transformer.transform(avObject, className);
            }
        });
    }

    public boolean hasCachedResult(String className, Map<String, String> query, long maxAgeInMilliseconds) {
        return QueryResultCache.getInstance().hasCachedResult(className, query, maxAgeInMilliseconds);
    }

    public Observable<List<AVObject>> queryObjects(final String className, final Map<String, String> query, AVQuery.CachePolicy cachePolicy, final long maxAgeInMilliseconds) {
        final String cacheKey = QueryResultCache.generateKeyForQueryCondition(className, query);
        Observable result = null;
        Observable queryResult = null;
        switch (cachePolicy) {
            case CACHE_ONLY: {
                result = this.wrappObservable(QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, true));
                break;
            }
            case CACHE_ELSE_NETWORK: {
                result = this.wrappObservable(QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, false));
                if (null == result) break;
                result = result.onErrorReturn((Function)new Function<Throwable, List<AVObject>>(){

                    public List<AVObject> apply(Throwable o) throws Exception {
                        LOGGER.d("failed to query local cache, cause: " + o.getMessage() + ", try to query networking");
                        return (List)StorageClient.this.apiService.queryObjects(className, query).map((Function)new Function<AVQueryResult, List<AVObject>>(){

                            public List<AVObject> apply(AVQueryResult o) throws Exception {
                                o.setClassName(className);
                                for (AVObject obj : o.getResults()) {
                                    obj.setClassName(className);
                                }
                                QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                                LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                                return o.getResults();
                            }
                        }).blockingFirst();
                    }
                });
                break;
            }
            case NETWORK_ELSE_CACHE: {
                queryResult = this.wrappObservable(this.apiService.queryObjects(className, query));
                if (null == queryResult) break;
                result = queryResult.map((Function)new Function<AVQueryResult, List<AVObject>>(){

                    public List<AVObject> apply(AVQueryResult o) throws Exception {
                        o.setClassName(className);
                        for (AVObject obj : o.getResults()) {
                            obj.setClassName(className);
                        }
                        QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                        LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                        return o.getResults();
                    }
                }).onErrorReturn((Function)new Function<Throwable, List<AVObject>>(){

                    public List<AVObject> apply(Throwable o) throws Exception {
                        LOGGER.d("failed to query networking, cause: " + o.getMessage() + ", try to query local cache.");
                        return (List)QueryResultCache.getInstance().getCacheResult(className, query, maxAgeInMilliseconds, true).blockingFirst();
                    }
                });
                break;
            }
            default: {
                queryResult = this.wrappObservable(this.apiService.queryObjects(className, query));
                if (null == queryResult) break;
                result = queryResult.map((Function)new Function<AVQueryResult, List<AVObject>>(){

                    public List<AVObject> apply(AVQueryResult o) throws Exception {
                        o.setClassName(className);
                        for (AVObject obj : o.getResults()) {
                            obj.setClassName(className);
                        }
                        QueryResultCache.getInstance().cacheResult(cacheKey, o.toJSONString());
                        LOGGER.d("invoke within StorageClient.queryObjects(). resultSize:" + (null != o.getResults() ? o.getResults().size() : 0));
                        return o.getResults();
                    }
                });
            }
        }
        return result;
    }

    public Observable<AVQueryResult> cloudQuery(Map<String, String> query) {
        return this.wrappObservable(this.apiService.cloudQuery(query));
    }

    public Observable<Integer> queryCount(String className, Map<String, String> query) {
        Observable queryResult = this.wrappObservable(this.apiService.queryObjects(className, query));
        if (null == queryResult) {
            return null;
        }
        return queryResult.map((Function)new Function<AVQueryResult, Integer>(){

            public Integer apply(AVQueryResult o) throws Exception {
                LOGGER.d("invoke within StorageClient.queryCount(). result:" + o + ", return:" + o.getCount());
                return o.getCount();
            }
        });
    }

    public Observable<AVNull> deleteObject(String className, String objectId) {
        return this.wrappObservable(this.apiService.deleteObject(className, objectId));
    }

    public Observable<? extends AVObject> createObject(final String className, JSONObject data, boolean fetchFlag, JSONObject where) {
        Observable object = this.wrappObservable(this.apiService.createObject(className, data, fetchFlag, where));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) {
                LOGGER.d(avObject.toString());
                return Transformer.transform(avObject, className);
            }
        });
    }

    public Observable<? extends AVObject> saveObject(final String className, String objectId, JSONObject data, boolean fetchFlag, JSONObject where) {
        Observable object = this.wrappObservable(this.apiService.updateObject(className, objectId, data, fetchFlag, where));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<AVObject, AVObject>(){

            public AVObject apply(AVObject avObject) {
                LOGGER.d("saveObject finished. intermediaObj=" + avObject.toString() + ", convert to " + className);
                return Transformer.transform(avObject, className);
            }
        });
    }

    public <E extends AVObject> Observable<E> saveWholeObject(final Class<E> clazz, String endpointClass, JSONObject object, boolean fetchFlag, JSONObject where) {
        Observable result = this.wrappObservable(this.apiService.saveWholeObject(endpointClass, object, fetchFlag, where));
        if (null == result) {
            return null;
        }
        return result.map(new Function<AVObject, E>(){

            public E apply(AVObject avObject) throws Exception {
                return Transformer.transform(avObject, clazz);
            }
        });
    }

    public Observable<AVObject> getWholeObject(String endpointClass, String objectId) {
        return this.wrappObservable(this.apiService.getWholeObject(endpointClass, objectId));
    }

    public Observable<AVNull> deleteWholeObject(String endpointClass, String objectId) {
        return this.wrappObservable(this.apiService.deleteWholeObject(endpointClass, objectId));
    }

    public Observable<AVFile> fetchFile(String objectId) {
        Observable object = this.wrappObservable(this.apiService.fetchFile(objectId));
        if (null == object) {
            return null;
        }
        return object.map((Function)new Function<AVFile, AVFile>(){

            public AVFile apply(AVFile avFile) throws Exception {
                avFile.setClassName("_File");
                return avFile;
            }
        });
    }

    public Observable<FileUploadToken> newUploadToken(JSONObject fileData) {
        return this.wrappObservableInBackground(this.apiService.createUploadToken(fileData));
    }

    public void fileCallback(JSONObject result) throws IOException {
        this.apiService.fileCallback(result).execute();
    }

    public Observable<JSONArray> batchSave(JSONObject parameter) {
        Observable result = this.wrappObservable(this.apiService.batchCreate(parameter));
        return result;
    }

    public Observable<JSONObject> batchUpdate(JSONObject parameter) {
        Observable result = this.wrappObservable(this.apiService.batchUpdate(parameter));
        return result;
    }

    public Observable<AVUser> signUp(JSONObject data) {
        return this.wrappObservable(this.apiService.signup(data));
    }

    public Observable<AVUser> signUpWithFlag(JSONObject data, boolean failOnNotExist) {
        return this.wrappObservable(this.apiService.signup(data, failOnNotExist));
    }

    public <T extends AVUser> Observable<T> signUpOrLoginByMobilephone(JSONObject data, final Class<T> clazz) {
        return this.wrappObservable(this.apiService.signupByMobilePhone(data)).map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                AVUser rst = (AVUser)Transformer.transform((AVObject)avUser, clazz);
                AVUser.changeCurrentUser(rst, true);
                return rst;
            }
        });
    }

    public <T extends AVUser> Observable<T> logIn(JSONObject data, final Class<T> clazz) {
        Observable object = this.wrappObservable(this.apiService.login(data));
        if (null == object) {
            return null;
        }
        return object.map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                AVUser rst = (AVUser)Transformer.transform((AVObject)avUser, clazz);
                AVUser.changeCurrentUser(rst, true);
                return rst;
            }
        });
    }

    public Observable<Boolean> checkAuthenticated(String sessionToken) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("session_token", sessionToken);
        Observable apiResult = this.wrappObservable(this.apiService.checkAuthenticated(param));
        if (null == apiResult) {
            return Observable.just((Object)false);
        }
        return apiResult.map((Function)new Function<AVUser, Boolean>(){

            public Boolean apply(AVUser o) throws Exception {
                if (null != o) {
                    return true;
                }
                return false;
            }
        });
    }

    public <T extends AVUser> Observable<T> createUserBySession(String sessionToken, final Class<T> clazz) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("session_token", sessionToken);
        return this.apiService.checkAuthenticated(param).map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                if (null == avUser) {
                    return null;
                }
                return (AVUser)Transformer.transform((AVObject)avUser, clazz);
            }
        });
    }

    public Observable<Boolean> refreshSessionToken(final AVUser user) {
        return this.wrappObservable(this.apiService.refreshSessionToken(user.getObjectId()).map((Function)new Function<AVUser, Boolean>(){

            public Boolean apply(AVUser avUser) throws Exception {
                if (null != avUser && !StringUtil.isEmpty(avUser.getSessionToken())) {
                    user.internalChangeSessionToken(avUser.getSessionToken());
                    return true;
                }
                return false;
            }
        }));
    }

    public Observable<AVNull> requestResetPassword(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.wrappObservable(this.apiService.requestResetPassword(map));
    }

    public Observable<AVNull> requestResetPasswordBySmsCode(String phoneNumber, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", phoneNumber);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrappObservable(this.apiService.requestResetPasswordBySmsCode(map));
    }

    public Observable<AVNull> requestEmailVerify(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.wrappObservable(this.apiService.requestEmailVerify(map));
    }

    public Observable<AVNull> requestMobilePhoneVerify(String mobilePhone, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", mobilePhone);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrappObservable(this.apiService.requestMobilePhoneVerify(map));
    }

    public Observable<AVNull> verifyMobilePhone(String verifyCode) {
        return this.wrappObservable(this.apiService.verifyMobilePhone(verifyCode));
    }

    public Observable<AVNull> requestLoginSmsCode(String phoneNumber, String validateToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mobilePhoneNumber", phoneNumber);
        if (!StringUtil.isEmpty(validateToken)) {
            map.put("validate_token", validateToken);
        }
        return this.wrappObservable(this.apiService.requestLoginSmsCode(map));
    }

    public Observable<AVNull> resetPasswordBySmsCode(String smsCode, String newPass) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("password", newPass);
        return this.wrappObservable(this.apiService.resetPasswordBySmsCode(smsCode, map));
    }

    public Observable<AVNull> updatePassword(final AVUser user, String oldPass, String newPass) {
        if (null == user) {
            return Observable.error((Throwable)new IllegalArgumentException("user is null"));
        }
        if (StringUtil.isEmpty(oldPass) || StringUtil.isEmpty(newPass)) {
            return Observable.error((Throwable)new IllegalArgumentException("old password or new password is empty"));
        }
        JSONObject param = new JSONObject();
        param.put("old_password", (Object)oldPass);
        param.put("new_password", (Object)newPass);
        return this.wrappObservable(this.apiService.updatePassword(user.getObjectId(), param).map((Function)new Function<AVUser, AVNull>(){

            public AVNull apply(AVUser var1) throws Exception {
                if (null != var1) {
                    user.internalChangeSessionToken(var1.getSessionToken());
                }
                return new AVNull();
            }
        }));
    }

    public Observable<JSONObject> followUser(String followee, String follower, Map<String, Object> attr) {
        return this.wrappObservable(this.apiService.followUser(followee, follower, attr));
    }

    public Observable<JSONObject> unfollowUser(String followee, String follower) {
        return this.wrappObservable(this.apiService.unfollowUser(followee, follower));
    }

    public Observable<AVNull> deleteStatus(String statusId) {
        return this.wrappObservable(this.apiService.deleteStatus(statusId));
    }

    public Observable<AVNull> deleteInboxStatus(Map<String, String> param) {
        return this.wrappObservable(this.apiService.deleteInboxStatus(param));
    }

    public <T> Observable<T> callRPC(String name, Object param) {
        Observable cloudCall = this.wrappObservable(this.apiService.cloudRPC(name, param));
        if (null == cloudCall) {
            return null;
        }
        return cloudCall.map(new Function<Map<String, ?>, T>(){

            public T apply(Map<String, ?> resultMap) throws Exception {
                try {
                    Object resultValue = resultMap.get("result");
                    if (resultValue instanceof Collection) {
                        return Utils.getObjectFrom((Collection)resultValue);
                    }
                    if (resultValue instanceof Map) {
                        return Utils.getObjectFrom((Map)resultValue);
                    }
                    return resultValue;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        });
    }

    public <T> Observable<T> callFunction(String name, Map<String, Object> params) {
        Observable cloudCall = this.wrappObservable(this.apiService.cloudFunction(name, params));
        if (null == cloudCall) {
            return null;
        }
        return cloudCall.map(new Function<Map<String, ?>, T>(){

            public T apply(Map<String, ?> resultMap) throws Exception {
                try {
                    Object resultValue = resultMap.get("result");
                    if (resultValue instanceof Collection) {
                        return Utils.getObjectFrom((Collection)resultValue);
                    }
                    if (resultValue instanceof Map) {
                        return Utils.getObjectFrom((Map)resultValue);
                    }
                    return resultValue;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        });
    }

    public Observable<AVCaptchaDigest> requestCaptcha(AVCaptchaOption option) {
        return this.wrappObservable(this.apiService.requestCaptcha(option.getRequestParam()));
    }

    public Observable<AVCaptchaValidateResult> verifyCaptcha(String code, String token) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(token)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or token is empty"));
        }
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("captcha_code", code);
        param.put("captcha_token", token);
        return this.wrappObservable(this.apiService.verifyCaptcha(param));
    }

    public Observable<AVNull> requestSMSCode(String mobilePhone, Map<String, Object> param) {
        param.put("mobilePhoneNumber", mobilePhone);
        return this.wrappObservable(this.apiService.requestSMSCode(param));
    }

    public Observable<AVNull> verifySMSCode(String code, String mobilePhone) {
        if (StringUtil.isEmpty(code) || StringUtil.isEmpty(mobilePhone)) {
            return Observable.error((Throwable)new IllegalArgumentException("code or mobilePhone is empty"));
        }
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("mobilePhoneNumber", mobilePhone);
        return this.wrappObservable(this.apiService.verifySMSCode(code, param));
    }
}

