/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.core.AVOSCloud;
import cn.leancloud.core.AVOSService;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.AppRouter;
import cn.leancloud.core.LoggingInterceptor;
import cn.leancloud.core.PushClient;
import cn.leancloud.core.RequestPaddingInterceptor;
import cn.leancloud.core.StorageClient;
import cn.leancloud.network.DNSDetoxicant;
import cn.leancloud.service.APIService;
import cn.leancloud.service.PushService;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.fastjson.FastJsonConverterFactory;

public class PaasClient {
    private static APIService apiService = null;
    private static StorageClient storageClient = null;
    private static OkHttpClient globalHttpClient = null;
    private static PushService pushService = null;
    private static PushClient pushClient = null;
    static AppConfiguration.SchedulerCreator defaultScheduler = null;
    static boolean asynchronized = false;

    public static void config(boolean asyncRequest, AppConfiguration.SchedulerCreator observerSchedulerCreator) {
        asynchronized = asyncRequest;
        defaultScheduler = observerSchedulerCreator;
    }

    public static OkHttpClient getGlobalOkHttpClient() {
        if (null == globalHttpClient) {
            globalHttpClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).addInterceptor((Interceptor)new RequestPaddingInterceptor()).addInterceptor((Interceptor)new LoggingInterceptor()).dns((Dns)new DNSDetoxicant()).build();
        }
        return globalHttpClient;
    }

    static void initializeGlobalClient() {
        if (null == apiService) {
            final OkHttpClient okHttpClient = PaasClient.getGlobalOkHttpClient();
            AppRouter appRouter = AppRouter.getInstance();
            appRouter.getEndpoint(AVOSCloud.getApplicationId(), AVOSService.API, false).subscribe((Consumer)new Consumer<String>(){

                public void accept(String apiHost) throws Exception {
                    Retrofit retrofit = new Retrofit.Builder().baseUrl(apiHost).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(okHttpClient).build();
                    apiService = (APIService)retrofit.create(APIService.class);
                    storageClient = new StorageClient(apiService, asynchronized, defaultScheduler);
                }
            });
        }
    }

    public static StorageClient getStorageClient() {
        if (null == apiService) {
            OkHttpClient okHttpClient = PaasClient.getGlobalOkHttpClient();
            AppRouter appRouter = AppRouter.getInstance();
            String apiHost = (String)appRouter.getEndpoint(AVOSCloud.getApplicationId(), AVOSService.API, false).blockingFirst();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(apiHost).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(okHttpClient).build();
            apiService = (APIService)retrofit.create(APIService.class);
            storageClient = new StorageClient(apiService, asynchronized, defaultScheduler);
        }
        return storageClient;
    }

    public static PushClient getPushClient() {
        if (null == pushService) {
            OkHttpClient okHttpClient = PaasClient.getGlobalOkHttpClient();
            AppRouter appRouter = AppRouter.getInstance();
            String apiHost = (String)appRouter.getEndpoint(AVOSCloud.getApplicationId(), AVOSService.PUSH, false).blockingFirst();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(apiHost).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(okHttpClient).build();
            pushService = (PushService)retrofit.create(PushService.class);
            pushClient = new PushClient(pushService, asynchronized, defaultScheduler);
        }
        return pushClient;
    }
}

