/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.core;

import cn.leancloud.AVLogger;
import cn.leancloud.core.AVOSCloud;
import cn.leancloud.utils.LogUtil;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class LoggingInterceptor
implements Interceptor {
    private static final String CURL_COMMAND = "curl -X %s \n";
    private static final String CURL_HEADER_FORMAT = " -H %s: %s \n";
    private static AVLogger LOGGER = LogUtil.getLogger(LoggingInterceptor.class);

    private String generateCURLCommandString(Request request) {
        String url = request.url().toString();
        String method = request.method();
        Headers headers = request.headers();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(CURL_COMMAND, method));
        for (String name : headers.names()) {
            if ("X-LC-Id".equals(name)) {
                sb.append(String.format(CURL_HEADER_FORMAT, name, "{your_app_id}"));
                continue;
            }
            if ("X-LC-Key".equals(name)) {
                sb.append(String.format(CURL_HEADER_FORMAT, name, "{your_app_key}"));
                continue;
            }
            if ("X-LC-Session".equals(name)) {
                sb.append(String.format(CURL_HEADER_FORMAT, name, "{your_session}"));
                continue;
            }
            if ("X-LC-Sign".equals(name)) {
                sb.append(String.format(CURL_HEADER_FORMAT, "X-LC-Key", "{your_app_key}"));
                continue;
            }
            sb.append(String.format(CURL_HEADER_FORMAT, name, headers.get(name)));
        }
        sb.append(url);
        return sb.toString();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (!AVOSCloud.isDebugEnable()) {
            return response;
        }
        LOGGER.d(String.format("Request: %s", this.generateCURLCommandString(request)));
        int responseCode = response.code();
        Headers responseHeaders = response.headers();
        String responseBody = response.body().string();
        LOGGER.d(String.format("Response: %d %n%s %n%s ", response.code(), responseHeaders, responseBody));
        return response.newBuilder().code(responseCode).headers(responseHeaders).body(ResponseBody.create((MediaType)response.body().contentType(), (String)responseBody)).build();
    }
}

