/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVFile;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.AVUser;
import cn.leancloud.ObjectValueFilter;
import cn.leancloud.ops.Utils;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;

public class ObjectTypeAdapter
implements ObjectSerializer,
ObjectDeserializer {
    private static AVLogger LOGGER = LogUtil.getLogger(ObjectTypeAdapter.class);

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        AVObject avObject = (AVObject)object;
        SerializeWriter writer = serializer.getWriter();
        writer.write(123);
        writer.writeFieldValue(' ', "className", avObject.getClassName());
        writer.writeFieldValue(',', "serverData", JSON.toJSONString(avObject.serverData, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect}));
        writer.write(125);
    }

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        String className = "";
        JSONObject serverJson = null;
        JSONObject jsonObject = parser.parseObject();
        if (jsonObject.containsKey((Object)"className")) {
            className = (String)jsonObject.get((Object)"className");
            serverJson = jsonObject.containsKey((Object)"serverData") ? jsonObject.getJSONObject("serverData") : jsonObject;
        } else {
            serverJson = jsonObject;
        }
        AVObject obj = type.toString().endsWith(AVFile.class.getCanonicalName()) ? new AVFile() : (type.toString().endsWith(AVUser.class.getCanonicalName()) ? new AVUser() : (!StringUtil.isEmpty(className) ? new AVObject(className) : new AVObject()));
        Map innerMap = serverJson.getInnerMap();
        for (String k : innerMap.keySet()) {
            Object v = innerMap.get(k);
            if (v instanceof String || v instanceof Number || v instanceof Boolean || v instanceof Byte || v instanceof Character) {
                obj.serverData.put(k, v);
                continue;
            }
            if (v instanceof Map) {
                obj.serverData.put(k, Utils.getObjectFrom(v));
                continue;
            }
            if (v instanceof Collection) {
                obj.serverData.put(k, Utils.getObjectFrom(v));
                continue;
            }
            obj.serverData.put(k, v);
        }
        return (T)obj;
    }

    public int getFastMatchToken() {
        return 14;
    }
}

