/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.ObjectValueFilter;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.codec.MD5;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.network.NetworkingDetector;
import cn.leancloud.ops.BaseOperation;
import cn.leancloud.types.AVNull;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ArchivedRequests {
    private static final AVLogger logger = LogUtil.getLogger(ArchivedRequests.class);
    private static final String ATTR_METHOD = "method";
    private static final String METHOD_DELETE = "Delete";
    private static final String METHOD_SAVE = "Save";
    private static final String ATTR_INTERNAL_ID = "internalId";
    private static final String ATTR_OBJECT = "objectJson";
    private static final String ATTR_OPERATION = "opertions";
    private static ArchivedRequests instance = null;
    private Map<String, AVObject> saveObjects = new HashMap<String, AVObject>();
    private Map<String, AVObject> deleteObjects = new HashMap<String, AVObject>();
    private Timer timer = null;

    public static synchronized ArchivedRequests getInstance() {
        if (null == instance) {
            instance = new ArchivedRequests();
        }
        return instance;
    }

    private ArchivedRequests() {
        String commandCacheDir = AppConfiguration.getCommandCacheDir();
        PersistenceUtil.sharedInstance();
        List<File> files = PersistenceUtil.listFiles(commandCacheDir);
        for (File f : files) {
            this.parseArchiveFile(f);
        }
        this.timer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                logger.i("begin to run timer task for archived request.");
                NetworkingDetector detector = AppConfiguration.getGlobalNetworkingDetector();
                if (null == detector || !detector.isConnected()) {
                    logger.i("ignore timer task bcz networking is unavailable.");
                    return;
                }
                if (ArchivedRequests.this.saveObjects.isEmpty() && ArchivedRequests.this.deleteObjects.isEmpty()) {
                    logger.i("ignore timer task bcz request queue is empty.");
                    return;
                }
                if (ArchivedRequests.this.saveObjects.size() > 0) {
                    ArchivedRequests.this.sendArchivedRequest(ArchivedRequests.this.saveObjects, false);
                }
                if (ArchivedRequests.this.deleteObjects.size() > 0) {
                    ArchivedRequests.this.sendArchivedRequest(ArchivedRequests.this.deleteObjects, true);
                }
                logger.i("end to run timer task for archived request.");
            }
        };
        this.timer.schedule(task, 10000L, 15000L);
    }

    private void sendArchivedRequest(final Map<String, AVObject> collection, final boolean isDelete) {
        if (null == collection || collection.isEmpty()) {
            return;
        }
        Collection<AVObject> objects = collection.values();
        int opLimit = objects.size() > 5 ? 5 : objects.size();
        Iterator<AVObject> iterator = objects.iterator();
        for (int opCount = 0; opCount < opLimit && iterator.hasNext(); ++opCount) {
            final AVObject obj = iterator.next();
            if (isDelete) {
                obj.deleteInBackground().subscribe((Observer)new Observer<AVNull>(){

                    public void onSubscribe(Disposable disposable) {
                    }

                    public void onNext(AVNull avNull) {
                        collection.remove(obj.internalId());
                        File archivedFile = ArchivedRequests.this.getArchivedFile(obj, isDelete);
                        boolean ret = PersistenceUtil.sharedInstance().forceDeleteFile(archivedFile);
                        if (!ret) {
                            logger.w("failed to delete file:" + archivedFile.getAbsolutePath() + " for objectInternalId: " + obj.internalId());
                        } else {
                            logger.d("succeed to delete file:" + archivedFile.getAbsolutePath() + " for objectInternalId: " + obj.internalId());
                        }
                    }

                    public void onError(Throwable throwable) {
                        logger.w("failed to delete archived request. cause: ", throwable);
                    }

                    public void onComplete() {
                    }
                });
                continue;
            }
            obj.saveInBackground().subscribe((Observer)new Observer<AVObject>(){

                public void onSubscribe(Disposable disposable) {
                }

                public void onNext(AVObject avObject) {
                    collection.remove(obj.internalId());
                    File archivedFile = ArchivedRequests.this.getArchivedFile(obj, isDelete);
                    boolean ret = PersistenceUtil.sharedInstance().forceDeleteFile(archivedFile);
                    if (!ret) {
                        logger.w("failed to delete file:" + archivedFile.getAbsolutePath() + " for objectInternalId: " + obj.internalId());
                    } else {
                        logger.d("succeed to delete file:" + archivedFile.getAbsolutePath() + " for objectInternalId: " + obj.internalId());
                    }
                }

                public void onError(Throwable throwable) {
                    logger.w("failed to save archived request. cause: ", throwable);
                }

                public void onComplete() {
                }
            });
        }
    }

    public void saveEventually(AVObject object) {
        if (null == object) {
            return;
        }
        this.saveArchivedRequest(object, false);
        this.saveObjects.put(object.internalId(), object);
    }

    public void deleteEventually(AVObject object) {
        if (null == object) {
            return;
        }
        this.saveArchivedRequest(object, true);
        this.deleteObjects.put(object.internalId(), object);
    }

    private File getArchivedFile(AVObject object, boolean isDelete) {
        String fileName = ArchivedRequests.getArchiveRequestFileName(object);
        return new File(AppConfiguration.getCommandCacheDir(), fileName);
    }

    private void saveArchivedRequest(AVObject object, boolean isDelete) {
        String content = ArchivedRequests.getArchiveContent(object, isDelete);
        File targetFile = this.getArchivedFile(object, isDelete);
        PersistenceUtil.sharedInstance().saveContentToFile(content, targetFile);
    }

    public static String getArchiveContent(AVObject object, boolean isDelete) {
        HashMap<String, String> content = new HashMap<String, String>(3);
        content.put(ATTR_METHOD, isDelete ? METHOD_DELETE : METHOD_SAVE);
        content.put(ATTR_INTERNAL_ID, object.internalId());
        content.put(ATTR_OBJECT, JSON.toJSONString((Object)object));
        content.put(ATTR_OPERATION, JSON.toJSONString(object.operations.values(), (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.QuoteFieldNames, SerializerFeature.DisableCircularReferenceDetect}));
        return JSON.toJSONString(content);
    }

    private void parseArchiveFile(File file) {
        if (null == file) {
            return;
        }
        if (!AVObject.verifyInternalId(file.getName())) {
            logger.d("ignore invalid file. " + file.getAbsolutePath());
            return;
        }
        String content = PersistenceUtil.sharedInstance().readContentFromFile(file);
        if (StringUtil.isEmpty(content)) {
            return;
        }
        try {
            Map contentMap = (Map)JSON.parseObject((String)content, Map.class);
            String method = (String)contentMap.get(ATTR_METHOD);
            AVObject resultObj = ArchivedRequests.parseAVObject(contentMap);
            logger.d("get archived request. method=" + method + ", object=" + resultObj.toString());
            if (METHOD_SAVE.equalsIgnoreCase(method)) {
                this.saveObjects.put(resultObj.internalId(), resultObj);
            } else {
                this.deleteObjects.put(resultObj.internalId(), resultObj);
            }
        }
        catch (Exception ex) {
            logger.w("encounter exception whiling parse archived file.", ex);
        }
    }

    protected static AVObject parseAVObject(String content) {
        Map contentMap = (Map)JSON.parseObject((String)content, Map.class);
        return ArchivedRequests.parseAVObject(contentMap);
    }

    private static AVObject parseAVObject(Map<String, String> contentMap) {
        String internalId = contentMap.get(ATTR_INTERNAL_ID);
        String objectJSON = contentMap.get(ATTR_OBJECT);
        String operationJSON = contentMap.get(ATTR_OPERATION);
        AVObject resultObj = (AVObject)JSON.parseObject((String)objectJSON, AVObject.class);
        if (!StringUtil.isEmpty(internalId) && !internalId.equals(resultObj.getObjectId())) {
            resultObj.setUuid(internalId);
        }
        if (!StringUtil.isEmpty(operationJSON)) {
            List ops = (List)JSON.parseObject((String)operationJSON, (TypeReference)new TypeReference<List<BaseOperation>>(){}, (Feature[])new Feature[]{Feature.IgnoreNotMatch});
            for (BaseOperation op : ops) {
                resultObj.addNewOperation(op);
            }
        }
        return resultObj;
    }

    private static String getArchiveRequestFileName(AVObject object) {
        if (StringUtil.isEmpty(object.getObjectId())) {
            return object.internalId();
        }
        return MD5.computeMD5(object.getRequestRawEndpoint());
    }
}

