/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVException;
import cn.leancloud.AVFellowshipQuery;
import cn.leancloud.AVObject;
import cn.leancloud.AVQuery;
import cn.leancloud.AVRole;
import cn.leancloud.ObjectTypeAdapter;
import cn.leancloud.ObjectValueFilter;
import cn.leancloud.Transformer;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.PaasClient;
import cn.leancloud.types.AVNull;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@JSONType(deserializer=ObjectTypeAdapter.class, serializer=ObjectTypeAdapter.class)
public class AVUser
extends AVObject {
    private static final String ATTR_USERNAME = "username";
    private static final String ATTR_PASSWORD = "password";
    private static final String ATTR_EMAIL = "email";
    private static final String ATTR_MOBILEPHONE = "mobilePhoneNumber";
    private static final String ATTR_SMSCODE = "smsCode";
    private static final String ATTR_MOBILEPHONE_VERIFIED = "mobilePhoneVerified";
    public static final String ATTR_SESSION_TOKEN = "sessionToken";
    private static final String AUTHDATA_TAG = "authData";
    private static final String AUTHDATA_ATTR_UNIONID = "unionid";
    private static final String AUTHDATA_ATTR_UNIONID_PLATFORM = "platform";
    private static final String AUTHDATA_ATTR_MAIN_ACCOUNT = "main_account";
    private static final String ILLEGALARGUMENT_MSG_FORMAT = "illegal parameter. %s must not null/empty.";
    public static final String CLASS_NAME = "_User";
    private static transient boolean enableAutomatic = false;

    public AVUser() {
        super(CLASS_NAME);
    }

    public static AVUser currentUser() {
        return AVUser.getCurrentUser();
    }

    @JSONField(serialize=false)
    public String getEmail() {
        return (String)this.get(ATTR_EMAIL);
    }

    public void setEmail(String email) {
        this.put(ATTR_EMAIL, email);
    }

    @JSONField(serialize=false)
    public String getUsername() {
        return (String)this.get(ATTR_USERNAME);
    }

    public void setUsername(String name) {
        this.put(ATTR_USERNAME, name);
    }

    @JSONField(serialize=false)
    public String getPassword() {
        return (String)this.get(ATTR_PASSWORD);
    }

    public void setPassword(String password) {
        this.put(ATTR_PASSWORD, password);
    }

    @JSONField(serialize=false)
    public String getMobilePhoneNumber() {
        return (String)this.get(ATTR_MOBILEPHONE);
    }

    public void setMobilePhoneNumber(String mobile) {
        this.put(ATTR_MOBILEPHONE, mobile);
    }

    @JSONField(serialize=false)
    public boolean isMobilePhoneVerified() {
        return this.getBoolean(ATTR_MOBILEPHONE_VERIFIED);
    }

    @JSONField(serialize=false)
    public String getSessionToken() {
        return (String)this.get(ATTR_SESSION_TOKEN);
    }

    public void internalChangeSessionToken(String token) {
        this.getServerData().put(ATTR_SESSION_TOKEN, token);
    }

    public boolean isAuthenticated() {
        String sessionToken = this.getSessionToken();
        return !StringUtil.isEmpty(sessionToken);
    }

    public void signUp() {
        this.signUpInBackground().blockingSubscribe();
    }

    public Observable<AVUser> signUpInBackground() {
        JSONObject paramData = this.generateChangedParam();
        logger.d("signup param: " + paramData.toJSONString());
        return PaasClient.getStorageClient().signUp(paramData).map((Function)new Function<AVUser, AVUser>(){

            public AVUser apply(AVUser avUser) throws Exception {
                AVUser.this.mergeRawData(avUser);
                return AVUser.this;
            }
        });
    }

    public static AVUser signUpOrLoginByMobilePhone(String mobilePhoneNumber, String smsCode) {
        return AVUser.signUpOrLoginByMobilePhone(mobilePhoneNumber, smsCode, AVUser.class);
    }

    public static <T extends AVUser> T signUpOrLoginByMobilePhone(String mobilePhoneNumber, String smsCode, Class<T> clazz) {
        return (T)((AVUser)AVUser.signUpOrLoginByMobilePhoneInBackground(mobilePhoneNumber, smsCode, clazz).blockingSingle());
    }

    public static Observable<AVUser> signUpOrLoginByMobilePhoneInBackground(String mobilePhoneNumber, String smsCode) {
        return AVUser.signUpOrLoginByMobilePhoneInBackground(mobilePhoneNumber, smsCode, AVUser.class);
    }

    public static <T extends AVUser> Observable<T> signUpOrLoginByMobilePhoneInBackground(String mobilePhoneNumber, String smsCode, Class<T> clazz) {
        if (StringUtil.isEmpty(mobilePhoneNumber)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, ATTR_MOBILEPHONE)));
        }
        if (StringUtil.isEmpty(smsCode)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, ATTR_SMSCODE)));
        }
        if (null == clazz) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "clazz")));
        }
        Map<String, Object> params = AVUser.createUserMap(null, null, null, mobilePhoneNumber, smsCode);
        JSONObject data = new JSONObject(params);
        return PaasClient.getStorageClient().signUpOrLoginByMobilephone(data, clazz);
    }

    public static Observable<AVUser> logIn(String username, String password) {
        return AVUser.logIn(username, password, AVUser.class);
    }

    public static Observable<AVUser> logInAnonymously() {
        String anonymousId = UUID.randomUUID().toString().toLowerCase();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", anonymousId);
        return AVUser.loginWithAuthData(param, "anonymous");
    }

    public static <T extends AVUser> Observable<T> logIn(String username, String password, Class<T> clazz) {
        Map<String, Object> params = AVUser.createUserMap(username, password, null, null, null);
        JSONObject data = new JSONObject(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    public static Observable<AVUser> loginByMobilePhoneNumber(String mobile, String password) {
        return AVUser.loginByMobilePhoneNumber(mobile, password, AVUser.class);
    }

    public static <T extends AVUser> Observable<T> loginByMobilePhoneNumber(String mobile, String password, Class<T> clazz) {
        Map<String, Object> params = AVUser.createUserMap(null, password, null, mobile, null);
        JSONObject data = new JSONObject(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    public static Observable<AVUser> loginBySMSCode(String mobile, String smsCode) {
        return AVUser.loginBySMSCode(mobile, smsCode, AVUser.class);
    }

    public static <T extends AVUser> Observable<T> loginBySMSCode(String mobile, String smsCode, Class<T> clazz) {
        Map<String, Object> params = AVUser.createUserMap(null, null, null, mobile, smsCode);
        JSONObject data = new JSONObject(params);
        return PaasClient.getStorageClient().logIn(data, clazz);
    }

    private static Map<String, Object> createUserMap(String username, String password, String email, String phoneNumber, String smsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtil.isEmpty(username) && StringUtil.isEmpty(phoneNumber)) {
            throw new IllegalArgumentException("Blank username and blank mobile phone number");
        }
        if (!StringUtil.isEmpty(username)) {
            map.put(ATTR_USERNAME, username);
        }
        if (!StringUtil.isEmpty(password)) {
            map.put(ATTR_PASSWORD, password);
        }
        if (!StringUtil.isEmpty(email)) {
            map.put(ATTR_EMAIL, email);
        }
        if (!StringUtil.isEmpty(phoneNumber)) {
            map.put(ATTR_MOBILEPHONE, phoneNumber);
        }
        if (!StringUtil.isEmpty(smsCode)) {
            map.put(ATTR_SMSCODE, smsCode);
        }
        return map;
    }

    private static Map<String, String> createUserMapAFAP(String username, String password, String email, String phoneNumber, String smsCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtil.isEmpty(username)) {
            map.put(ATTR_USERNAME, username);
        }
        if (!StringUtil.isEmpty(password)) {
            map.put(ATTR_PASSWORD, password);
        }
        if (!StringUtil.isEmpty(email)) {
            map.put(ATTR_EMAIL, email);
        }
        if (!StringUtil.isEmpty(phoneNumber)) {
            map.put(ATTR_MOBILEPHONE, phoneNumber);
        }
        if (!StringUtil.isEmpty(smsCode)) {
            map.put(ATTR_SMSCODE, smsCode);
        }
        return map;
    }

    public static Observable<AVUser> loginWithAuthData(Map<String, Object> authData, String platform) {
        return AVUser.loginWithAuthData(AVUser.class, authData, platform);
    }

    public static Observable<AVUser> loginWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        return AVUser.loginWithAuthData(AVUser.class, authData, platform, unionId, unionIdPlatform, asMainAccount);
    }

    public static <T extends AVUser> Observable<T> loginWithAuthData(final Class<T> clazz, Map<String, Object> authData, String platform) {
        if (null == clazz) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "clazz")));
        }
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap data = new HashMap();
        HashMap<String, Map<String, Object>> authMap = new HashMap<String, Map<String, Object>>();
        authMap.put(platform, authData);
        data.put(AUTHDATA_TAG, authMap);
        JSONObject param = new JSONObject(data);
        return PaasClient.getStorageClient().signUp(param).map(new Function<AVUser, T>(){

            public T apply(AVUser avUser) throws Exception {
                AVUser result = (AVUser)Transformer.transform((AVObject)avUser, clazz);
                AVUser.changeCurrentUser(result, true);
                return result;
            }
        });
    }

    public static <T extends AVUser> Observable<T> loginWithAuthData(Class<T> clazz, Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, asMainAccount);
        }
        return AVUser.loginWithAuthData(clazz, authData, platform);
    }

    public Observable<AVUser> loginWithAuthData(Map<String, Object> authData, String platform, boolean failOnNotExist) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        Map<String, String> userData = AVUser.createUserMapAFAP(this.getUsername(), null, this.getEmail(), this.getMobilePhoneNumber(), null);
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> authMap = new HashMap<String, Map<String, Object>>();
        authMap.put(platform, authData);
        if (!userData.isEmpty()) {
            data.putAll(userData);
        }
        data.put(AUTHDATA_TAG, authMap);
        JSONObject param = new JSONObject(data);
        return PaasClient.getStorageClient().signUpWithFlag(param, failOnNotExist).map((Function)new Function<AVUser, AVUser>(){

            public AVUser apply(AVUser avUser) throws Exception {
                AVUser.this.resetByRawData(avUser);
                AVUser.changeCurrentUser(AVUser.this, true);
                return AVUser.this;
            }
        });
    }

    public Observable<AVUser> loginWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount, boolean failOnNotExist) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, asMainAccount);
        }
        return this.loginWithAuthData(authData, platform, failOnNotExist);
    }

    public Observable<AVUser> associateWithAuthData(Map<String, Object> authData, String platform) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        HashMap<String, Map<String, Object>> authDataAttr = new HashMap<String, Map<String, Object>>();
        authDataAttr.put(platform, authData);
        Object existedAuthData = this.get(AUTHDATA_TAG);
        if (existedAuthData instanceof Map) {
            authDataAttr.putAll((Map)existedAuthData);
        }
        this.put(AUTHDATA_TAG, authDataAttr);
        return this.saveInBackground();
    }

    public Observable<AVUser> associateWithAuthData(Map<String, Object> authData, String platform, String unionId, String unionIdPlatform, boolean asMainAccount) {
        if (null == authData || authData.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_TAG)));
        }
        if (StringUtil.isEmpty(unionId)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionId")));
        }
        if (StringUtil.isEmpty(unionIdPlatform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, "unionIdPlatform")));
        }
        authData.put(AUTHDATA_ATTR_UNIONID, unionId);
        authData.put(AUTHDATA_ATTR_UNIONID_PLATFORM, unionIdPlatform);
        if (asMainAccount) {
            authData.put(AUTHDATA_ATTR_MAIN_ACCOUNT, true);
        }
        return this.associateWithAuthData(authData, platform);
    }

    public Observable<AVUser> dissociateWithAuthData(final String platform) {
        if (StringUtil.isEmpty(platform)) {
            return Observable.error((Throwable)new IllegalArgumentException(String.format(ILLEGALARGUMENT_MSG_FORMAT, AUTHDATA_ATTR_UNIONID_PLATFORM)));
        }
        String objectId = this.getObjectId();
        if (StringUtil.isEmpty(objectId) || !this.isAuthenticated()) {
            return Observable.error((Throwable)new AVException(206, "the user object missing a valid session"));
        }
        this.remove("authData." + platform);
        return this.saveInBackground().map((Function)new Function<AVObject, AVUser>(){

            public AVUser apply(@NonNull AVObject var1) throws Exception {
                Map authData = (Map)AVUser.this.get(AVUser.AUTHDATA_TAG);
                if (authData != null) {
                    authData.remove(platform);
                }
                return AVUser.this;
            }
        });
    }

    public Observable<Boolean> checkAuthenticatedInBackground() {
        String sessionToken = this.getSessionToken();
        if (StringUtil.isEmpty(sessionToken)) {
            logger.d("sessionToken is not existed.");
            return Observable.just((Object)false);
        }
        return PaasClient.getStorageClient().checkAuthenticated(sessionToken);
    }

    public Observable<Boolean> refreshSessionTokenInBackground() {
        return PaasClient.getStorageClient().refreshSessionToken(this);
    }

    public static Observable<AVUser> becomeWithSessionTokenInBackground(String sessionToken) {
        return AVUser.becomeWithSessionTokenInBackground(sessionToken, AVUser.class);
    }

    public static <T extends AVUser> Observable<T> becomeWithSessionTokenInBackground(String sessionToken, Class<T> clazz) {
        return PaasClient.getStorageClient().createUserBySession(sessionToken, clazz);
    }

    public static void logOut() {
        AVUser.changeCurrentUser(null, true);
    }

    public static <T extends AVUser> AVQuery<T> getUserQuery(Class<T> clazz) {
        return new AVQuery<T>(CLASS_NAME, clazz);
    }

    public static AVQuery<AVUser> getQuery() {
        return AVUser.getQuery(AVUser.class);
    }

    public Observable<List<AVRole>> getRolesInBackground() {
        AVQuery roleQuery = new AVQuery("_Role");
        roleQuery.whereEqualTo("users", this);
        return roleQuery.findInBackground();
    }

    public static void enableAutomaticUser() {
        enableAutomatic = true;
    }

    public static boolean isEnableAutomatic() {
        return enableAutomatic;
    }

    public static void disableAutomaticUser() {
        enableAutomatic = false;
    }

    private static File currentUserArchivePath() {
        return new File(AppConfiguration.getDocumentDir() + "/currentUser");
    }

    private static boolean userArchiveExist() {
        return AVUser.currentUserArchivePath().exists();
    }

    public static synchronized void changeCurrentUser(AVUser newUser, boolean save) {
        if (null != newUser) {
            newUser.setPassword(null);
        }
        File currentUserArchivePath = AVUser.currentUserArchivePath();
        if (null != newUser && save) {
            String jsonString = JSON.toJSONString((Object)newUser, (SerializeFilter)ObjectValueFilter.instance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.DisableCircularReferenceDetect});
            logger.d(jsonString);
            PersistenceUtil.sharedInstance().saveContentToFile(jsonString, currentUserArchivePath);
        } else if (save) {
            PersistenceUtil.sharedInstance().removeLock(currentUserArchivePath.getAbsolutePath());
            boolean deleteRst = currentUserArchivePath.delete();
            if (!deleteRst) {
                logger.w("failed to delete currentUser cache file.");
            }
        }
        PaasClient.getStorageClient().setCurrentUser(newUser);
    }

    public static AVUser getCurrentUser() {
        return AVUser.getCurrentUser(AVUser.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T extends AVUser> T getCurrentUser(Class<T> userClass) {
        AVUser user = PaasClient.getStorageClient().getCurrentUser();
        if (null != user && userClass.isAssignableFrom(user.getClass())) {
            return (T)user;
        }
        if (AVUser.userArchiveExist()) {
            File currentUserArchivePath = AVUser.currentUserArchivePath();
            Class<AVUser> clazz = AVUser.class;
            // MONITORENTER : cn.leancloud.AVUser.class
            String jsonString = PersistenceUtil.sharedInstance().readContentFromFile(currentUserArchivePath);
            if (!StringUtil.isEmpty(jsonString)) {
                if (jsonString.indexOf("@type") >= 0) {
                    try {
                        AVUser newUser = (AVUser)userClass.newInstance();
                        Map jsonData = (Map)JSON.parseObject((String)jsonString, Map.class);
                        Object serverDataString = jsonData.get("serverData");
                        if (serverDataString instanceof String) {
                            Map rawData = (Map)JSON.parseObject((String)((String)serverDataString), Map.class);
                            rawData.remove("@type");
                            newUser.resetServerData(rawData);
                        } else {
                            newUser.resetServerData(jsonData);
                            AVUser.changeCurrentUser(newUser, true);
                        }
                        user = newUser;
                        PaasClient.getStorageClient().setCurrentUser(user);
                    }
                    catch (Exception ex) {
                        logger.w("failed to deserialize AVUser instance.", ex);
                    }
                } else {
                    try {
                        AVUser newUser = (AVUser)userClass.newInstance();
                        Map rawData = (Map)JSON.parseObject((String)jsonString, Map.class);
                        newUser.resetServerData(rawData);
                        AVUser.changeCurrentUser(newUser, true);
                        user = newUser;
                    }
                    catch (Exception ex) {
                        logger.w(ex);
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (!enableAutomatic) return (T)user;
        if (null != user) return (T)user;
        try {
            user = (AVUser)userClass.newInstance();
            AVUser.changeCurrentUser(user, true);
            return (T)user;
        }
        catch (Exception ex) {
            logger.w(ex);
        }
        return (T)user;
    }

    public static Observable<AVNull> requestPasswordResetInBackground(String email) {
        return PaasClient.getStorageClient().requestResetPassword(email);
    }

    public static Observable<AVNull> requestPasswordResetBySmsCodeInBackground(String phoneNumber) {
        return AVUser.requestPasswordResetBySmsCodeInBackground(phoneNumber, null);
    }

    public static Observable<AVNull> requestPasswordResetBySmsCodeInBackground(String phoneNumber, String validateToken) {
        return PaasClient.getStorageClient().requestResetPasswordBySmsCode(phoneNumber, validateToken);
    }

    public static Observable<AVNull> resetPasswordBySmsCodeInBackground(String smsCode, String newPassword) {
        return PaasClient.getStorageClient().resetPasswordBySmsCode(smsCode, newPassword);
    }

    public Observable<AVNull> updatePasswordInBackground(String oldPass, String newPass) {
        return PaasClient.getStorageClient().updatePassword(this, oldPass, newPass);
    }

    public static Observable<AVNull> requestEmailVerifyInBackground(String email) {
        return PaasClient.getStorageClient().requestEmailVerify(email);
    }

    public static Observable<AVNull> requestMobilePhoneVerifyInBackground(String mobilePhone) {
        return AVUser.requestMobilePhoneVerifyInBackground(mobilePhone, null);
    }

    public static Observable<AVNull> requestMobilePhoneVerifyInBackground(String mobilePhone, String validateToken) {
        return PaasClient.getStorageClient().requestMobilePhoneVerify(mobilePhone, validateToken);
    }

    public static Observable<AVNull> requestLoginSmsCodeInBackground(String phoneNumber) {
        return AVUser.requestLoginSmsCodeInBackground(phoneNumber, null);
    }

    public static Observable<AVNull> requestLoginSmsCodeInBackground(String phoneNumber, String validateToken) {
        return PaasClient.getStorageClient().requestLoginSmsCode(phoneNumber, validateToken);
    }

    public static Observable<AVNull> verifyMobilePhoneInBackground(String verifyCode) {
        return PaasClient.getStorageClient().verifyMobilePhone(verifyCode);
    }

    public Observable<JSONObject> followInBackground(String userObjectId) {
        return this.followInBackground(userObjectId, null);
    }

    public Observable<JSONObject> followInBackground(String userObjectId, Map<String, Object> attributes) {
        return PaasClient.getStorageClient().followUser(this.getObjectId(), userObjectId, attributes);
    }

    public Observable<JSONObject> unfollowInBackground(String userObjectId) {
        return PaasClient.getStorageClient().unfollowUser(this.getObjectId(), userObjectId);
    }

    public <T extends AVUser> AVQuery<T> followerQuery(Class<T> clazz) {
        return AVUser.followerQuery(this.getObjectId(), clazz);
    }

    public <T extends AVUser> AVQuery<T> followeeQuery(Class<T> clazz) {
        return AVUser.followeeQuery(this.getObjectId(), clazz);
    }

    public static <T extends AVUser> AVQuery<T> followerQuery(String userObjectId, Class<T> clazz) {
        if (StringUtil.isEmpty(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId");
        }
        AVFellowshipQuery<T> query = new AVFellowshipQuery<T>("_Follower", clazz);
        query.whereEqualTo("user", AVUser.createWithoutData(CLASS_NAME, userObjectId));
        query.setFriendshipTag("follower");
        return query;
    }

    public static <T extends AVUser> AVQuery<T> followeeQuery(String userObjectId, Class<T> clazz) {
        if (StringUtil.isEmpty(userObjectId)) {
            throw new IllegalArgumentException("Blank user objectId");
        }
        AVFellowshipQuery<T> query = new AVFellowshipQuery<T>("_Followee", clazz);
        query.whereEqualTo("user", AVUser.createWithoutData(CLASS_NAME, userObjectId));
        query.setFriendshipTag("followee");
        return query;
    }

    public static enum SNS_PLATFORM {
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        QQ("qq"),
        WEIBO("weibo"),
        WECHAT("weixin");

        private String name;

        private SNS_PLATFORM(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

