/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVACL;
import cn.leancloud.AVException;
import cn.leancloud.AVObject;
import cn.leancloud.AVUser;
import cn.leancloud.ObjectTypeAdapter;
import cn.leancloud.cache.FileCache;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.callback.ProgressCallback;
import cn.leancloud.codec.MD5;
import cn.leancloud.core.AVOSCloud;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.PaasClient;
import cn.leancloud.ops.ObjectFieldOperation;
import cn.leancloud.ops.OperationBuilder;
import cn.leancloud.upload.FileDownloader;
import cn.leancloud.upload.FileUploadToken;
import cn.leancloud.upload.FileUploader;
import cn.leancloud.upload.Uploader;
import cn.leancloud.upload.UrlDirectlyUploader;
import cn.leancloud.utils.FileUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

@JSONType(deserializer=ObjectTypeAdapter.class, serializer=ObjectTypeAdapter.class)
public final class AVFile
extends AVObject {
    public static final String CLASS_NAME = "_File";
    private static final String FILE_SUM_KEY = "_checksum";
    private static final String FILE_NAME_KEY = "_name";
    private static final String FILE_LENGTH_KEY = "size";
    private static final String FILE_SOURCE_KEY = "__source";
    private static final String FILE_SOURCE_EXTERNAL = "external";
    private static final String THUMBNAIL_FMT = "?imageView/%d/w/%d/h/%d/q/%d/format/%s";
    private static final String KEY_FILE_NAME = "name";
    private static final String KEY_METADATA = "metaData";
    private static final String KEY_URL = "url";
    private static final String KEY_BUCKET = "bucket";
    private static final String KEY_PROVIDER = "provider";
    private static final String KEY_MIME_TYPE = "mime_type";
    private static final String KEY_FILE_KEY = "key";
    @JSONField(serialize=false)
    private String localPath = "";
    @JSONField(serialize=false)
    private String cachePath = "";

    public static void setUploadHeader(String key, String value) {
        FileUploader.setUploadHeader(key, value);
    }

    public AVFile() {
        super(CLASS_NAME);
        if (AppConfiguration.getDefaultACL() != null) {
            this.acl = new AVACL(AppConfiguration.getDefaultACL());
        }
    }

    public AVFile(String name, byte[] data) {
        this();
        if (null == data) {
            logger.w("data is illegal(null)");
            throw new IllegalArgumentException("data is illegal(null)");
        }
        this.internalPut(KEY_FILE_NAME, name);
        this.addMetaData(FILE_NAME_KEY, name);
        String md5 = MD5.computeMD5(data);
        this.localPath = FileCache.getIntance().saveData(md5, data);
        this.addMetaData(FILE_SUM_KEY, md5);
        this.addMetaData(FILE_LENGTH_KEY, data.length);
        this.internalPut(KEY_MIME_TYPE, FileUtil.getMimeTypeFromFilename(name));
        logger.d("localpath=" + this.localPath);
    }

    public AVFile(String name, File localFile) {
        this();
        if (null == localFile || !localFile.exists() || !localFile.isFile()) {
            logger.w("local file is illegal");
            throw new IllegalArgumentException("local file is illegal.");
        }
        this.internalPut(KEY_FILE_NAME, name);
        this.addMetaData(FILE_NAME_KEY, name);
        String md5 = MD5.computeFileMD5(localFile);
        this.localPath = localFile.getAbsolutePath();
        this.addMetaData(FILE_SUM_KEY, md5);
        this.addMetaData(FILE_LENGTH_KEY, localFile.length());
        this.internalPut(KEY_MIME_TYPE, FileUtil.getMimeTypeFromPath(this.localPath));
    }

    public AVFile(String name, String url) {
        this(name, url, null);
    }

    public AVFile(String name, String url, Map<String, Object> metaData) {
        this(name, url, metaData, true);
    }

    protected AVFile(String name, String url, Map<String, Object> metaData, boolean external) {
        this();
        this.internalPut(KEY_FILE_NAME, name);
        this.addMetaData(FILE_NAME_KEY, name);
        this.internalPut(KEY_URL, url);
        HashMap<String, Object> meta = new HashMap<String, Object>();
        if (null != metaData) {
            meta.putAll(metaData);
        }
        if (external) {
            meta.put(FILE_SOURCE_KEY, FILE_SOURCE_EXTERNAL);
        }
        this.internalPut(KEY_METADATA, meta);
        this.internalPut(KEY_MIME_TYPE, FileUtil.getMimeTypeFromUrl(url));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private Object internalGet(String key) {
        Object value = this.serverData.get(key);
        ObjectFieldOperation op = (ObjectFieldOperation)this.operations.get(key);
        if (null != op) {
            value = op.apply(value);
        }
        return value;
    }

    private void internalPut(String key, Object value) {
        ObjectFieldOperation op = OperationBuilder.gBuilder.create(OperationBuilder.OperationType.Set, key, value);
        this.addNewOperation(op);
    }

    private void internalPutDirectly(String key, Object value) {
        this.serverData.put(key, value);
    }

    public static Observable<AVFile> withObjectIdInBackground(String objectId) {
        return PaasClient.getStorageClient().fetchFile(objectId);
    }

    public String getName() {
        return (String)this.internalGet(KEY_FILE_NAME);
    }

    public void setName(String name) {
        this.internalPut(KEY_FILE_NAME, name);
    }

    public Map<String, Object> getMetaData() {
        HashMap result = (HashMap)this.internalGet(KEY_METADATA);
        if (null == result) {
            result = new HashMap();
            this.internalPut(KEY_METADATA, result);
        }
        return result;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.internalPut(KEY_METADATA, metaData);
    }

    public void addMetaData(String key, Object val) {
        Map<String, Object> metaData = this.getMetaData();
        metaData.put(key, val);
    }

    public Object getMetaData(String key) {
        return this.getMetaData().get(key);
    }

    public Object removeMetaData(String key) {
        return this.getMetaData().remove(key);
    }

    public void clearMetaData() {
        this.getMetaData().clear();
    }

    public int getSize() {
        Number size = (Number)this.getMetaData(FILE_LENGTH_KEY);
        if (size != null) {
            return size.intValue();
        }
        return -1;
    }

    public String getMimeType() {
        return (String)this.internalGet(KEY_MIME_TYPE);
    }

    public void setMimeType(String mimeType) {
        this.internalPut(KEY_MIME_TYPE, mimeType);
    }

    public String getKey() {
        return (String)this.internalGet(KEY_FILE_KEY);
    }

    public String getBucket() {
        return (String)this.internalGet(KEY_BUCKET);
    }

    public String getUrl() {
        return (String)this.internalGet(KEY_URL);
    }

    public String getProvider() {
        return (String)this.internalGet(KEY_PROVIDER);
    }

    @Override
    public void put(String key, Object value) {
        throw new UnsupportedOperationException("cannot invoke put method in AVFile");
    }

    @Override
    public Object get(String key) {
        throw new UnsupportedOperationException("cannot invoke get method in AVFile");
    }

    @Override
    public void remove(String key) {
        throw new UnsupportedOperationException("cannot invoke remove method in AVFile");
    }

    @Override
    public void increment(String key) {
        throw new UnsupportedOperationException("cannot invoke increment method in AVFile");
    }

    @Override
    public void increment(String key, Number value) {
        throw new UnsupportedOperationException("cannot invoke increment(Number) method in AVFile");
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height) {
        return this.getThumbnailUrl(scaleToFit, width, height, 100, "png");
    }

    public String getThumbnailUrl(boolean scaleToFit, int width, int height, int quality, String fmt) {
        if (AVOSCloud.getRegion() != AVOSCloud.REGION.NorthChina) {
            logger.w("We only support this method for qiniu storage.");
            throw new UnsupportedOperationException("We only support this method for qiniu storage.");
        }
        if (width < 0 || height < 0) {
            logger.w("Invalid width or height.");
            throw new IllegalArgumentException("Invalid width or height.");
        }
        if (quality < 1 || quality > 100) {
            logger.w("Invalid quality,valid range is 0-100.");
            throw new IllegalArgumentException("Invalid quality,valid range is 0-100.");
        }
        if (fmt == null || StringUtil.isEmpty(fmt.trim())) {
            fmt = "png";
        }
        int mode = scaleToFit ? 2 : 1;
        return this.getUrl() + String.format(THUMBNAIL_FMT, mode, width, height, quality, fmt);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("__type", CLASS_NAME);
        result.put(KEY_METADATA, this.getMetaData());
        if (!StringUtil.isEmpty(this.getUrl())) {
            result.put(KEY_URL, this.getUrl());
        }
        if (!StringUtil.isEmpty(this.getObjectId())) {
            result.put("objectId", this.getObjectId());
        }
        result.put("id", this.getName());
        return result;
    }

    public synchronized void saveInBackground(ProgressCallback progressCallback) {
        if (StringUtil.isEmpty(this.objectId)) {
            Uploader uploader = this.getUploader(null, progressCallback);
            uploader.execute();
        } else if (null != progressCallback) {
            progressCallback.internalDone(100, null);
        }
    }

    public Observable<AVFile> saveInBackground() {
        JSONObject paramData = this.generateChangedParam();
        final String fileKey = FileUtil.generateFileKey(this.getName());
        paramData.put(KEY_FILE_KEY, (Object)fileKey);
        paramData.put("__type", (Object)"File");
        if (StringUtil.isEmpty(this.getObjectId())) {
            logger.d("createToken params: " + paramData.toJSONString() + ", " + this);
            return PaasClient.getStorageClient().newUploadToken(paramData).map((Function)new Function<FileUploadToken, AVFile>(){

                public AVFile apply(@NonNull FileUploadToken fileUploadToken) throws Exception {
                    AVObject.logger.d("[Thread:" + Thread.currentThread().getId() + "]" + fileUploadToken.toString() + ", " + AVFile.this);
                    AVFile.this.setObjectId(fileUploadToken.getObjectId());
                    AVFile.this.internalPutDirectly("objectId", fileUploadToken.getObjectId());
                    AVFile.this.internalPutDirectly(AVFile.KEY_BUCKET, fileUploadToken.getBucket());
                    AVFile.this.internalPutDirectly(AVFile.KEY_PROVIDER, fileUploadToken.getProvider());
                    AVFile.this.internalPutDirectly(AVFile.KEY_FILE_KEY, fileKey);
                    Uploader uploader = AVFile.this.getUploader(fileUploadToken, null);
                    AVFile.this.internalPutDirectly(AVFile.KEY_URL, fileUploadToken.getUrl());
                    AVException exception = uploader.execute();
                    JSONObject completeResult = new JSONObject();
                    completeResult.put("result", (Object)(null == exception ? 1 : 0));
                    completeResult.put("token", (Object)fileUploadToken.getToken());
                    AVObject.logger.d("file upload result: " + completeResult.toJSONString());
                    try {
                        PaasClient.getStorageClient().fileCallback(completeResult);
                        if (null != exception) {
                            AVObject.logger.w("failed to invoke fileCallback. cause:", exception);
                            throw exception;
                        }
                        return AVFile.this;
                    }
                    catch (IOException ex) {
                        AVObject.logger.w(ex);
                        throw ex;
                    }
                }
            });
        }
        logger.d("file has been upload to cloud, ignore request.");
        return Observable.just((Object)this);
    }

    private Uploader getUploader(FileUploadToken uploadToken, ProgressCallback progressCallback) {
        if (StringUtil.isEmpty(this.getUrl())) {
            return new FileUploader(this, uploadToken, progressCallback);
        }
        return new UrlDirectlyUploader(this, progressCallback);
    }

    @JSONField(serialize=false)
    public byte[] getData() {
        String filePath = "";
        if (!StringUtil.isEmpty(this.localPath)) {
            filePath = this.localPath;
        } else if (!StringUtil.isEmpty(this.cachePath)) {
            filePath = this.cachePath;
        } else if (!StringUtil.isEmpty(this.getUrl())) {
            File cacheFile = FileCache.getIntance().getCacheFile(this.getUrl());
            if (null == cacheFile || !cacheFile.exists()) {
                FileDownloader downloader = new FileDownloader();
                downloader.execute(this.getUrl(), cacheFile);
            }
            if (null != cacheFile) {
                filePath = cacheFile.getAbsolutePath();
            }
        }
        if (!StringUtil.isEmpty(filePath)) {
            return PersistenceUtil.sharedInstance().readContentBytesFromFile(new File(filePath));
        }
        return new byte[0];
    }

    @JSONField(serialize=false)
    public InputStream getDataStream() {
        String filePath = "";
        if (!StringUtil.isEmpty(this.localPath)) {
            filePath = this.localPath;
        } else if (!StringUtil.isEmpty(this.cachePath)) {
            filePath = this.cachePath;
        } else if (!StringUtil.isEmpty(this.getUrl())) {
            File cacheFile = FileCache.getIntance().getCacheFile(this.getUrl());
            if (null == cacheFile || !cacheFile.exists()) {
                FileDownloader downloader = new FileDownloader();
                downloader.execute(this.getUrl(), cacheFile);
            }
            if (null != cacheFile) {
                filePath = cacheFile.getAbsolutePath();
            }
        }
        if (!StringUtil.isEmpty(filePath)) {
            logger.d("dest file path=" + filePath);
            return FileCache.getIntance().getInputStreamFromFile(new File(filePath));
        }
        logger.w("failed to get dataStream.");
        return null;
    }

    public static AVFile withAbsoluteLocalPath(String name, String absoluteLocalFilePath) throws FileNotFoundException {
        return AVFile.withFile(name, new File(absoluteLocalFilePath));
    }

    public static AVFile withFile(String name, File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null file object.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        AVFile avFile = new AVFile();
        avFile.setName(name);
        long fileSize = file.length();
        String fileMD5 = "";
        try {
            InputStream is = PersistenceUtil.getInputStreamFromFile(file);
            MD5 md5 = MD5.getInstance();
            md5.prepare();
            if (null != is) {
                int len;
                byte[] buf = new byte[0x200000];
                while ((len = is.read(buf)) != -1) {
                    md5.update(buf, 0, len);
                }
                byte[] md5bytes = md5.digest();
                fileMD5 = MD5.hexEncodeBytes(md5bytes);
                is.close();
            }
        }
        catch (Exception ex) {
            fileMD5 = "";
        }
        avFile.addMetaData(FILE_LENGTH_KEY, fileSize);
        avFile.addMetaData(FILE_SUM_KEY, fileMD5);
        AVUser currentUser = AVUser.getCurrentUser();
        avFile.addMetaData("owner", currentUser != null ? currentUser.getObjectId() : "");
        avFile.addMetaData(FILE_NAME_KEY, name);
        return avFile;
    }
}

