/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.AVUser;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AVACL {
    private static final String PUBLIC_KEY = "*";
    private static final String ROLE_PREFIX = "role:";
    private static final String KEY_READ_PERMISSION = "read";
    private static final String KEY_WRITE_PERMISSION = "write";
    private final Map<String, Permissions> permissionsById = new HashMap<String, Permissions>();

    public AVACL() {
    }

    public AVACL(JSONObject json) {
        if (null != json) {
            Set entries = json.entrySet();
            for (Map.Entry entry : entries) {
                this.permissionsById.put((String)entry.getKey(), (Permissions)entry.getValue());
            }
        }
    }

    public AVACL(AVACL other) {
        this.permissionsById.putAll(other.permissionsById);
    }

    public AVACL(AVUser owner) {
        this.setReadAccess(owner, true);
        this.setWriteAccess(owner, true);
    }

    public Map<String, Permissions> getPermissionsById() {
        return this.permissionsById;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AVACL)) {
            return false;
        }
        AVACL avacl = (AVACL)o;
        return Objects.equals(this.getPermissionsById(), avacl.getPermissionsById());
    }

    public int hashCode() {
        return Objects.hash(this.getPermissionsById());
    }

    public JSONObject toJSONObject() {
        String jsonStr = JSON.toJSONString(this.permissionsById, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero});
        return JSON.parseObject((String)jsonStr);
    }

    private void setPermissionsIfNonEmpty(String userId, boolean readPermission, boolean writePermission) {
        if (!readPermission && !writePermission) {
            this.permissionsById.remove(userId);
        } else {
            this.permissionsById.put(userId, new Permissions(readPermission, writePermission));
        }
    }

    public void setPublicReadAccess(boolean allowed) {
        this.setReadAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicReadAccess() {
        return this.getReadAccess(PUBLIC_KEY);
    }

    public void setPublicWriteAccess(boolean allowed) {
        this.setWriteAccess(PUBLIC_KEY, allowed);
    }

    public boolean getPublicWriteAccess() {
        return this.getWriteAccess(PUBLIC_KEY);
    }

    public void setReadAccess(String userId, boolean allowed) {
        if (StringUtil.isEmpty(userId)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for null userId");
        }
        boolean writePermission = this.getWriteAccess(userId);
        this.setPermissionsIfNonEmpty(userId, allowed, writePermission);
    }

    public boolean getReadAccess(String userId) {
        if (StringUtil.isEmpty(userId)) {
            return false;
        }
        Permissions permissions = this.permissionsById.get(userId);
        return permissions != null && permissions.getReadPermission();
    }

    public void setWriteAccess(String userId, boolean allowed) {
        if (StringUtil.isEmpty(userId)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for null userId");
        }
        boolean readPermission = this.getReadAccess(userId);
        this.setPermissionsIfNonEmpty(userId, readPermission, allowed);
    }

    public boolean getWriteAccess(String userId) {
        if (StringUtil.isEmpty(userId)) {
            return false;
        }
        Permissions permissions = this.permissionsById.get(userId);
        return permissions != null && permissions.getWritePermission();
    }

    public void setReadAccess(AVUser user, boolean allowed) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for a user with null id");
        }
        this.setReadAccess(user.getObjectId(), allowed);
    }

    public boolean getReadAccess(AVUser user) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            return false;
        }
        return this.getReadAccess(user.getObjectId());
    }

    public void setWriteAccess(AVUser user, boolean allowed) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess for a user with null id");
        }
        this.setWriteAccess(user.getObjectId(), allowed);
    }

    public boolean getWriteAccess(AVUser user) {
        if (null == user || StringUtil.isEmpty(user.getObjectId())) {
            return false;
        }
        return this.getWriteAccess(user.getObjectId());
    }

    public void setRoleReadAccess(String role, boolean allowed) {
        if (StringUtil.isEmpty(role)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess to a empty role");
        }
        this.setReadAccess(ROLE_PREFIX + role, allowed);
    }

    public boolean getRoleReadAccess(String role) {
        if (StringUtil.isEmpty(role)) {
            return false;
        }
        return this.getReadAccess(ROLE_PREFIX + role);
    }

    public void setRoleWriteAccess(String role, boolean allowed) {
        if (StringUtil.isEmpty(role)) {
            throw new IllegalArgumentException("cannot setRead/WriteAccess to a empty role");
        }
        this.setWriteAccess(ROLE_PREFIX + role, allowed);
    }

    public boolean getRoleWriteAccess(String role) {
        if (StringUtil.isEmpty(role)) {
            return false;
        }
        return this.getWriteAccess(ROLE_PREFIX + role);
    }

    private static class Permissions
    extends HashMap<String, Boolean> {
        Permissions(boolean read, boolean write) {
            if (read) {
                this.put(AVACL.KEY_READ_PERMISSION, read);
            }
            if (write) {
                this.put(AVACL.KEY_WRITE_PERMISSION, write);
            }
        }

        Permissions(Permissions permissions) {
            if (null == permissions) {
                return;
            }
            if (permissions.getReadPermission()) {
                this.put(AVACL.KEY_READ_PERMISSION, true);
            }
            if (permissions.getWritePermission()) {
                this.put(AVACL.KEY_WRITE_PERMISSION, true);
            }
        }

        boolean getReadPermission() {
            return (Boolean)this.get(AVACL.KEY_READ_PERMISSION);
        }

        boolean getWritePermission() {
            return (Boolean)this.get(AVACL.KEY_WRITE_PERMISSION);
        }
    }
}

