/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import cn.leancloud.LCLogger;
import cn.leancloud.network.NetworkingDetector;
import cn.leancloud.util.AndroidUtil;
import cn.leancloud.utils.LogUtil;

public class AndroidNetworkingDetector
implements NetworkingDetector {
    private static LCLogger LOGGER = LogUtil.getLogger(AndroidNetworkingDetector.class);
    private Context context = null;

    public AndroidNetworkingDetector(Context context) {
        this.context = context;
    }

    public boolean isConnected() {
        try {
            int hasPermission = AndroidUtil.checkPermission(this.context, "android.permission.ACCESS_NETWORK_STATE");
            if (0 != hasPermission) {
                LOGGER.w("android.Manifest.permission.ACCESS_NETWORK_STATE is not granted.");
            } else {
                ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (null != networkInfo && networkInfo.isConnected()) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.w("failed to detect networking status.", (Throwable)ex);
        }
        return false;
    }

    public NetworkingDetector.NetworkType getNetworkType() {
        NetworkingDetector.NetworkType result = NetworkingDetector.NetworkType.None;
        int hasPermission = AndroidUtil.checkPermission(this.context, "android.permission.ACCESS_NETWORK_STATE");
        if (0 != hasPermission) {
            LOGGER.w("android.Manifest.permission.ACCESS_NETWORK_STATE is not granted.");
        } else {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (null != networkInfo) {
                switch (networkInfo.getType()) {
                    case 0: {
                        result = NetworkingDetector.NetworkType.Mobile;
                        break;
                    }
                    case 1: {
                        result = NetworkingDetector.NetworkType.WIFI;
                        break;
                    }
                }
            }
        }
        return result;
    }
}

