/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import cn.leancloud.LCLogger;
import cn.leancloud.util.AndroidUtil;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;

public class LCManifestUtils {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCManifestUtils.class);

    public static boolean checkPermission(Context context, String permission) {
        boolean hasPermission;
        boolean bl = hasPermission = 0 == AndroidUtil.checkPermission(context, permission);
        if (!hasPermission) {
            LCManifestUtils.printErrorLog("permission " + permission + " is missing!");
        }
        return hasPermission;
    }

    public static boolean checkService(Context context, Class<?> service) {
        try {
            ServiceInfo info = context.getPackageManager().getServiceInfo(new ComponentName(context, service), 0);
            return null != info;
        }
        catch (PackageManager.NameNotFoundException e) {
            LCManifestUtils.printErrorLog("service " + service.getName() + " is missing!");
            return false;
        }
    }

    public static boolean checkReceiver(Context context, Class<?> receiver) {
        try {
            ActivityInfo info = context.getPackageManager().getReceiverInfo(new ComponentName(context, receiver), 0);
            return null != info;
        }
        catch (PackageManager.NameNotFoundException e) {
            LCManifestUtils.printErrorLog("receiver " + receiver.getName() + " is missing!");
            return false;
        }
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

