/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.content.Context;
import android.os.Handler;
import cn.leancloud.AVLogger;
import cn.leancloud.cache.AndroidSystemSetting;
import cn.leancloud.cache.SystemSetting;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.core.AVOSCloud;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.core.AppRouter;
import cn.leancloud.core.RequestPaddingInterceptor;
import cn.leancloud.core.RequestSignature;
import cn.leancloud.internal.ThreadModel;
import cn.leancloud.logging.DefaultLoggerAdapter;
import cn.leancloud.logging.InternalLoggerAdapter;
import cn.leancloud.network.AndroidNetworkingDetector;
import cn.leancloud.network.NetworkingDetector;
import cn.leancloud.sign.NativeSignHelper;
import cn.leancloud.sign.SecureRequestSignature;
import cn.leancloud.util.AndroidMimeTypeDetector;
import cn.leancloud.util.AndroidUtil;
import cn.leancloud.utils.FileUtil;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.lang.reflect.Method;

public class AVOSCloud
extends cn.leancloud.core.AVOSCloud {
    private static Context context = null;
    protected static Handler handler = null;

    public static Context getContext() {
        return context;
    }

    public static void setContext(Context context) {
        AVOSCloud.context = context;
    }

    public static Handler getHandler() {
        return handler;
    }

    public static void initialize(Context context, String appId, String appKey) {
        if (!AVOSCloud.hasCustomizedServerURL(appId)) {
            throw new IllegalStateException("Please call AVOSCloud#initialize(context, appid, appkey, serverURL) instead of AVOSCloud#initialize(context, appid, appkey), or call AVOSCloud#setServer(service, host) at first.");
        }
        if (null == handler && !AndroidUtil.isMainThread()) {
            throw new IllegalStateException("Please call AVOSCloud#initialize() in main thread.");
        }
        if (null == handler) {
            handler = new Handler();
        }
        AppConfiguration.setLogAdapter((InternalLoggerAdapter)new DefaultLoggerAdapter());
        AppConfiguration.setGlobalNetworkingDetector((NetworkingDetector)new AndroidNetworkingDetector(context));
        AppConfiguration.setMimeTypeDetector((FileUtil.MimeTypeDetector)new AndroidMimeTypeDetector());
        ThreadModel.MainThreadChecker checker = new ThreadModel.MainThreadChecker(){

            public boolean isMainThread() {
                return AndroidUtil.isMainThread();
            }
        };
        ThreadModel.ThreadShuttle shuttle = new ThreadModel.ThreadShuttle(){

            public void launch(Runnable runnable) {
                AVOSCloud.getHandler().post(runnable);
            }
        };
        AVCallback.setMainThreadChecker((ThreadModel.MainThreadChecker)checker, (ThreadModel.ThreadShuttle)shuttle);
        AVLogger logger = LogUtil.getLogger(AVOSCloud.class);
        logger.i("[LeanCloud] initialize mainThreadChecker and threadShuttle within AVCallback.");
        String appIdPrefix = StringUtil.isEmpty((String)appId) ? "" : appId.substring(0, 8);
        String importantFileDir = context.getFilesDir().getAbsolutePath();
        String baseDir = context.getCacheDir().getAbsolutePath();
        String documentDir = context.getDir(appIdPrefix + "Paas", 0).getAbsolutePath();
        String fileCacheDir = baseDir + "/" + appIdPrefix + "avfile";
        String commandCacheDir = baseDir + "/" + appIdPrefix + "CommandCache";
        String analyticsDir = baseDir + "/" + appIdPrefix + "Analysis";
        String queryResultCacheDir = baseDir + "/" + appIdPrefix + "PaasKeyValueCache";
        AndroidSystemSetting defaultSetting = new AndroidSystemSetting(context);
        AppConfiguration.configCacheSettings((String)importantFileDir, (String)documentDir, (String)fileCacheDir, (String)queryResultCacheDir, (String)commandCacheDir, (String)analyticsDir, (SystemSetting)defaultSetting);
        AppConfiguration.setApplicationPackageName((String)context.getPackageName());
        logger.d("docDir=" + documentDir + ", fileDir=" + fileCacheDir + ", cmdDir=" + commandCacheDir + ", statDir=" + analyticsDir);
        AppConfiguration.config((boolean)true, (AppConfiguration.SchedulerCreator)new AppConfiguration.SchedulerCreator(){

            public Scheduler create() {
                return AndroidSchedulers.mainThread();
            }
        });
        cn.leancloud.core.AVOSCloud.initialize((String)appId, (String)appKey);
        try {
            Class<?> androidInit = context.getClassLoader().loadClass("cn.leancloud.im.AndroidInitializer");
            Method initMethod = androidInit.getDeclaredMethod("init", Context.class);
            initMethod.invoke(null, context);
            logger.d("succeed to call cn.leancloud.im.AndroidInitializer#init(Context)");
        }
        catch (ClassNotFoundException ex) {
            logger.d("not found class: cn.leancloud.im.AndroidInitializer.");
        }
        catch (NoSuchMethodException ex) {
            logger.d("invalid AndroidInitializer, init(Context) method not found.");
        }
        catch (Exception ex) {
            logger.d("failed to call AndroidInitializer#init(Context), cause:" + ex.getMessage());
        }
        AVOSCloud.setContext(context);
    }

    public static void initialize(Context context, String appId, String appKey, String serverURL) {
        AVOSCloud.setServerURLs((String)serverURL);
        AVOSCloud.initialize(context, appId, appKey);
    }

    public static void initializeSecurely(Context context, String appId, String serverURL) {
        AVOSCloud.setServerURLs((String)serverURL);
        NativeSignHelper.initialize(context);
        RequestPaddingInterceptor.changeRequestSignature((RequestSignature)new SecureRequestSignature());
        AVOSCloud.initialize(context, appId, null);
    }

    protected static boolean hasCustomizedServerURL(String applicationId) {
        AVOSCloud.REGION region = AppRouter.getAppRegion((String)applicationId);
        if (AVOSCloud.REGION.NorthAmerica == region || AVOSCloud.REGION.NorthAmerica == AVOSCloud.getRegion()) {
            return true;
        }
        return AppRouter.getInstance().hasFrozenEndpoint();
    }
}

