/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.os.Parcel;
import android.os.Parcelable;
import cn.leancloud.AVLogger;
import cn.leancloud.AVObject;
import cn.leancloud.ArchivedRequests;
import cn.leancloud.Transformer;
import cn.leancloud.utils.LogUtil;

public class AVParcelableObject
implements Parcelable {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVParcelableObject.class);
    private AVObject instance = null;
    public static final transient Parcelable.Creator<AVParcelableObject> CREATOR = AVObjectCreator.instance;

    public AVParcelableObject(AVObject object) {
        this.instance = object;
    }

    public AVParcelableObject() {
    }

    public AVObject object() {
        return this.instance;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int i) {
        String archivedContent = ArchivedRequests.getArchiveContent((AVObject)this.instance, (boolean)false);
        out.writeString(this.instance.getClassName());
        out.writeString(archivedContent);
        LOGGER.d("writeToParcel with archivedContent: " + archivedContent);
    }

    public static class AVObjectCreator
    implements Parcelable.Creator<AVParcelableObject> {
        public static AVObjectCreator instance = new AVObjectCreator();

        private AVObjectCreator() {
        }

        public AVParcelableObject createFromParcel(Parcel parcel) {
            String className = parcel.readString();
            String content = parcel.readString();
            LOGGER.d("createFromParcel with archivedContent: " + content + ", className: " + className);
            AVObject rawObject = ArchivedRequests.parseAVObject((String)content);
            return new AVParcelableObject(Transformer.transform((AVObject)rawObject, (String)className));
        }

        public AVParcelableObject[] newArray(int i) {
            return new AVParcelableObject[i];
        }
    }
}

