/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.content.Context;
import android.os.Handler;
import cn.leancloud.AVFile;
import cn.leancloud.AVObject;
import cn.leancloud.AVUser;
import cn.leancloud.ObjectTypeAdapter;
import cn.leancloud.cache.AndroidSystemSetting;
import cn.leancloud.cache.SystemSetting;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.internal.ThreadModel;
import cn.leancloud.logging.DefaultLoggerAdapter;
import cn.leancloud.logging.InternalLoggerAdapter;
import cn.leancloud.network.AndroidNetworkingDetector;
import cn.leancloud.network.NetworkingDetector;
import cn.leancloud.util.AndroidMimeTypeDetector;
import cn.leancloud.util.AndroidUtil;
import cn.leancloud.utils.FileUtil;
import cn.leancloud.utils.LogUtil;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;

public class AVOSCloud
extends cn.leancloud.core.AVOSCloud {
    private static Context context = null;
    protected static Handler handler = null;

    public static Context getContext() {
        return context;
    }

    public static void setContext(Context context) {
        AVOSCloud.context = context;
    }

    public static Handler getHandler() {
        return handler;
    }

    public static void initialize(Context context, String appId, String appKey) {
        if (null == handler && !AndroidUtil.isMainThread()) {
            throw new IllegalStateException("Please call AVOSCloud.initialize in main thread.");
        }
        if (null == handler) {
            handler = new Handler();
        }
        ParserConfig.getGlobalInstance().putDeserializer(AVObject.class, (ObjectDeserializer)new ObjectTypeAdapter());
        ParserConfig.getGlobalInstance().putDeserializer(AVUser.class, (ObjectDeserializer)new ObjectTypeAdapter());
        ParserConfig.getGlobalInstance().putDeserializer(AVFile.class, (ObjectDeserializer)new ObjectTypeAdapter());
        AppConfiguration.setLogAdapter((InternalLoggerAdapter)new DefaultLoggerAdapter());
        AppConfiguration.setGlobalNetworkingDetector((NetworkingDetector)new AndroidNetworkingDetector(context));
        AppConfiguration.setMimeTypeDetector((FileUtil.MimeTypeDetector)new AndroidMimeTypeDetector());
        ThreadModel.MainThreadChecker checker = new ThreadModel.MainThreadChecker(){

            public boolean isMainThread() {
                return AndroidUtil.isMainThread();
            }
        };
        ThreadModel.ThreadShuttle shuttle = new ThreadModel.ThreadShuttle(){

            public void launch(Runnable runnable) {
                AVOSCloud.getHandler().post(runnable);
            }
        };
        AVCallback.setMainThreadChecker((ThreadModel.MainThreadChecker)checker, (ThreadModel.ThreadShuttle)shuttle);
        LogUtil.getLogger(AVOSCloud.class).i("[LeanCloud] initialize mainThreadChecker and threadShuttle within AVCallback.");
        String importantFileDir = context.getFilesDir().getAbsolutePath();
        String baseDir = context.getCacheDir().getAbsolutePath();
        String documentDir = context.getDir("PaaS", 0).getAbsolutePath();
        String fileCacheDir = baseDir + "/avfile/";
        String commandCacheDir = baseDir + "/CommandCache";
        String analyticsDir = baseDir + "/Analysis";
        String queryResultCacheDir = baseDir + "/PaasKeyValueCache";
        AndroidSystemSetting defaultSetting = new AndroidSystemSetting(context);
        AppConfiguration.configCacheSettings((String)importantFileDir, (String)documentDir, (String)fileCacheDir, (String)queryResultCacheDir, (String)commandCacheDir, (String)analyticsDir, (SystemSetting)defaultSetting);
        AppConfiguration.setApplicationPackagename((String)context.getPackageName());
        LogUtil.getLogger(AVOSCloud.class).d("docDir=" + documentDir + ", fileDir=" + fileCacheDir + ", cmdDir=" + commandCacheDir + ", statDir=" + analyticsDir);
        AppConfiguration.config((boolean)true, (AppConfiguration.SchedulerCreator)new AppConfiguration.SchedulerCreator(){

            public Scheduler create() {
                return AndroidSchedulers.mainThread();
            }
        });
        cn.leancloud.core.AVOSCloud.initialize((String)appId, (String)appKey);
        AVOSCloud.setContext(context);
    }
}

