/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import cn.leancloud.push.LCConnectivityListener;
import cn.leancloud.util.AndroidUtil;
import cn.leancloud.utils.LogUtil;

public class LCConnectivityReceiver
extends BroadcastReceiver {
    private final LCConnectivityListener listener;
    private boolean connectivityBroken = false;

    public LCConnectivityReceiver(LCConnectivityListener listener) {
        this.listener = listener;
    }

    public boolean isConnectivityBroken() {
        return this.connectivityBroken;
    }

    public void onReceive(Context context, Intent intent) {
        if (null == this.listener || null == context) {
            return;
        }
        int hasPermission = AndroidUtil.checkPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE");
        if (0 != hasPermission) {
            LogUtil.getLogger(LCConnectivityReceiver.class).w("android.Manifest.permission.ACCESS_NETWORK_STATE is not granted.");
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (null == activeNetwork || !activeNetwork.isConnected()) {
                this.listener.onNotConnected(context);
                this.connectivityBroken = true;
                return;
            }
            this.connectivityBroken = false;
            if (activeNetwork.getType() == 0) {
                this.listener.onMobile(context);
            } else if (activeNetwork.getType() == 1) {
                this.listener.onWifi(context);
            } else {
                this.listener.onOtherConnected(context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

