/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push;

import android.content.Intent;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import cn.leancloud.LCLogger;
import cn.leancloud.LeanCloud;
import cn.leancloud.cache.PersistenceUtil;
import cn.leancloud.codec.Base64Decoder;
import cn.leancloud.codec.Base64Encoder;
import cn.leancloud.json.JSON;
import cn.leancloud.push.PushService;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class NotifyUtil {
    private static LCLogger LOGGER = LogUtil.getLogger(NotifyUtil.class);
    protected static HandlerThread thread = new HandlerThread("com.avos.avoscloud.notify");
    static final int SERVICE_RESTART = 1024;
    static final String SERVICE_RESTART_ACTION = "com.avos.avoscloud.notify.action";
    static Handler notifyHandler;

    private static void registerApp() {
        Set<String> appSet = NotifyUtil.getRegisteredApps();
        if (appSet != null && LeanCloud.getContext() != null) {
            appSet.add(Base64Encoder.encode((String)LeanCloud.getContext().getPackageName()));
            PersistenceUtil.sharedInstance().saveContentToFile(JSON.toJSONString(appSet), NotifyUtil.getRegisterAppsFile());
        }
    }

    private static Set<String> getRegisteredApps() {
        String registerApps;
        if (LeanCloud.getContext() == null) {
            return null;
        }
        File registerFile = NotifyUtil.getRegisterAppsFile();
        HashSet<String> appSet = new HashSet<String>();
        if (registerFile.exists() && !StringUtil.isEmpty((String)(registerApps = PersistenceUtil.sharedInstance().readContentFromFile(registerFile)))) {
            try {
                appSet.addAll((Collection)JSON.parseObject((String)registerApps, Set.class));
            }
            catch (Exception e) {
                LOGGER.e("getRegisteredApps", (Throwable)e);
            }
            return appSet;
        }
        return appSet;
    }

    private static File getRegisterAppsFile() {
        File file = new File(Environment.getExternalStorageDirectory() + "/Android/data/leancloud/", "dontpanic.cp");
        if (file.exists()) {
            return file;
        }
        File folder = new File(Environment.getExternalStorageDirectory() + "/Android/data/leancloud/");
        folder.mkdirs();
        return file;
    }

    static {
        thread.start();
        notifyHandler = new Handler(thread.getLooper()){

            public void handleMessage(Message m) {
                if (m.what == 1024 && LeanCloud.getContext() != null) {
                    this.removeMessages(1024);
                    try {
                        Set registeredApps = NotifyUtil.getRegisteredApps();
                        for (String encodedAppPackage : registeredApps) {
                            String appPackage = Base64Decoder.decode((String)encodedAppPackage);
                            if (LeanCloud.getContext().getPackageName().equals(appPackage)) continue;
                            Intent intent = new Intent();
                            intent.setClassName(appPackage, PushService.class.getName());
                            intent.setAction(NotifyUtil.SERVICE_RESTART_ACTION);
                            LOGGER.d("try to start:" + appPackage + " from:" + LeanCloud.getContext().getPackageName());
                            try {
                                LeanCloud.getContext().startService(intent);
                            }
                            catch (Exception ex) {
                                LOGGER.e("failed to startService. cause: " + ex.getMessage());
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NotifyUtil.registerApp();
                }
            }
        };
    }
}

