/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im;

import android.content.Context;
import android.os.Build;
import cn.leancloud.LCLogger;
import cn.leancloud.LeanCloud;
import cn.leancloud.im.AndroidDatabaseDelegateFactory;
import cn.leancloud.im.AndroidFileMetaAccessor;
import cn.leancloud.im.AndroidOperationTube;
import cn.leancloud.im.DatabaseDelegateFactory;
import cn.leancloud.im.FileMetaAccessor;
import cn.leancloud.im.InternalConfiguration;
import cn.leancloud.im.LCIMEventHandler;
import cn.leancloud.im.LCIMOptions;
import cn.leancloud.im.OperationTube;
import cn.leancloud.im.SystemReporter;
import cn.leancloud.internal.ThreadModel;
import cn.leancloud.livequery.LCLiveQueryEventHandler;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.push.LCNotificationManager;
import cn.leancloud.push.LCPushMessageListener;
import cn.leancloud.util.AndroidUtil;
import cn.leancloud.utils.LogUtil;

public class AndroidInitializer {
    private static LCLogger LOGGER = LogUtil.getLogger(AndroidInitializer.class);

    private static void init() {
        ThreadModel.MainThreadChecker checker = new ThreadModel.MainThreadChecker(){

            public boolean isMainThread() {
                return AndroidUtil.isMainThread();
            }
        };
        ThreadModel.ThreadShuttle shuttle = new ThreadModel.ThreadShuttle(){

            public void launch(Runnable runnable) {
                LeanCloud.getHandler().post(runnable);
            }
        };
        LOGGER.i("[LeanCloud] initialize mainThreadChecker and threadShuttle within AVIMEventHandler.");
        LCIMEventHandler.setMainThreadChecker((ThreadModel.MainThreadChecker)checker, (ThreadModel.ThreadShuttle)shuttle);
        LOGGER.i("[LeanCloud] initialize mainThreadChecker and threadShuttle within AVLiveQueryEventHandler.");
        LCLiveQueryEventHandler.setMainThreadChecker((ThreadModel.MainThreadChecker)checker, (ThreadModel.ThreadShuttle)shuttle);
        LCPushMessageListener.getInstance().setNotificationManager((LCNotificationManager)AndroidNotificationManager.getInstance());
        LOGGER.i("[LeanCloud] initialize Android System Reporter.");
        LCIMOptions.getGlobalOptions().setSystemReporter((SystemReporter)new AndroidSystemReporter());
    }

    public static void init(Context context) {
        if (InternalConfiguration.getDatabaseDelegateFactory() != null) {
            LOGGER.i("[LeanCloud] re-initialize InternalConfiguration.");
            return;
        }
        AndroidInitializer.init();
        LOGGER.i("[LeanCloud] initialize InternalConfiguration within AVIMEventHandler.");
        LCIMOptions.getGlobalOptions().setMessageQueryCacheEnabled(true);
        InternalConfiguration.setFileMetaAccessor((FileMetaAccessor)new AndroidFileMetaAccessor());
        InternalConfiguration.setOperationTube((OperationTube)new AndroidOperationTube());
        InternalConfiguration.setDatabaseDelegateFactory((DatabaseDelegateFactory)new AndroidDatabaseDelegateFactory(context));
    }

    private static class AndroidSystemReporter
    implements SystemReporter {
        public SystemReporter.SystemInfo getInfo() {
            boolean isProbablyAnEmulator = Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.BOARD == "QC_Reference_Phone" || Build.MANUFACTURER.contains("Genymotion") || Build.HOST.startsWith("Build") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk" == Build.PRODUCT;
            SystemReporter.SystemInfo result = new SystemReporter.SystemInfo();
            result.setBrand(Build.BRAND);
            result.setManufacturer(Build.MANUFACTURER);
            result.setModel(Build.MODEL);
            result.setOsAPILevel(Build.VERSION.SDK_INT);
            result.setOsCodeName(Build.VERSION.CODENAME);
            result.setRunOnEmulator(isProbablyAnEmulator);
            return result;
        }
    }
}

