/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im.v2;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import cn.leancloud.LCLogger;
import cn.leancloud.codec.Base64Decoder;
import cn.leancloud.im.DatabaseDelegate;
import cn.leancloud.im.v2.LCIMBinaryMessage;
import cn.leancloud.im.v2.LCIMChatRoom;
import cn.leancloud.im.v2.LCIMClient;
import cn.leancloud.im.v2.LCIMConversation;
import cn.leancloud.im.v2.LCIMMessage;
import cn.leancloud.im.v2.LCIMMessageManager;
import cn.leancloud.im.v2.LCIMMessageStorage;
import cn.leancloud.im.v2.LCIMServiceConversation;
import cn.leancloud.im.v2.LCIMTemporaryConversation;
import cn.leancloud.json.JSON;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndroidDatabaseDelegate
implements DatabaseDelegate {
    private static final LCLogger LOGGER = LogUtil.getLogger(AndroidDatabaseDelegate.class);
    private DBHelper dbHelper;
    private String clientId;

    public AndroidDatabaseDelegate(Context context, String clientId) {
        this.dbHelper = new DBHelper(context, clientId);
        this.clientId = clientId;
    }

    private ContentValues transferMap(Map<String, Object> attrs) {
        ContentValues values = new ContentValues();
        for (Map.Entry<String, Object> entry : attrs.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Long) {
                values.put(entry.getKey(), (Long)value);
                continue;
            }
            if (value instanceof String) {
                values.put(entry.getKey(), (String)value);
                continue;
            }
            if (value instanceof Byte) {
                values.put(entry.getKey(), (Byte)value);
                continue;
            }
            if (value instanceof Integer) {
                values.put(entry.getKey(), (Integer)value);
                continue;
            }
            if (value instanceof Float) {
                values.put(entry.getKey(), (Float)value);
                continue;
            }
            if (value instanceof Double) {
                values.put(entry.getKey(), (Double)value);
                continue;
            }
            if (value instanceof Boolean) {
                values.put(entry.getKey(), (Boolean)value);
                continue;
            }
            if (!(value instanceof byte[])) continue;
            values.put(entry.getKey(), (byte[])value);
        }
        return values;
    }

    public int update(String table, Map<String, Object> attrs, String whereClause, String[] whereArgs) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues values = this.transferMap(attrs);
            return db.update(table, values, whereClause, whereArgs);
        }
        catch (Exception ex) {
            LOGGER.w("failed to execute update instrument. cause: " + ex.getMessage());
            return 0;
        }
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            return db.delete(table, whereClause, whereArgs);
        }
        catch (Exception ex) {
            LOGGER.w("failed to execute delete instrument. cause: " + ex.getMessage());
            return 0;
        }
    }

    public int insert(String table, Map<String, Object> attrs) {
        try {
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            ContentValues values = this.transferMap(attrs);
            return (int)db.insertWithOnConflict(table, null, values, 4);
        }
        catch (Exception ex) {
            LOGGER.w("failed to execute insert instrument. cause: " + ex.getMessage());
            return -1;
        }
    }

    public int queryCount(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        int resultCount = 0;
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            Cursor cursor = db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy);
            resultCount = cursor.getCount();
            cursor.close();
        }
        catch (Exception e) {
            LOGGER.w("failed to execute count query. cause: " + e.getMessage());
        }
        return resultCount;
    }

    public long countForQuery(String query, String[] selectionArgs) {
        if (StringUtil.isEmpty((String)query)) {
            return 0L;
        }
        SQLiteDatabase db = this.dbHelper.getReadableDatabase();
        return DatabaseUtils.longForQuery((SQLiteDatabase)db, (String)query, (String[])selectionArgs);
    }

    public LCIMMessageStorage.MessageQueryResult queryMessages(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        ArrayList<LCIMMessage> resultMessage = new ArrayList<LCIMMessage>();
        ArrayList<Boolean> resultBreakpoint = new ArrayList<Boolean>();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            Cursor cursor = db.query("messages", columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            boolean breakpoint = false;
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    LCIMMessage message = this.createMessageFromCursor(cursor);
                    breakpoint = cursor.getInt(cursor.getColumnIndex("breakpoint")) != 0;
                    resultMessage.add(message);
                    resultBreakpoint.add(breakpoint);
                    cursor.moveToNext();
                }
            }
            cursor.close();
        }
        catch (Exception e) {
            LOGGER.w("failed to execute message query. cause: " + e.getMessage());
        }
        LCIMMessageStorage.MessageQueryResult result = new LCIMMessageStorage.MessageQueryResult();
        result.messages = resultMessage;
        result.breakpoints = resultBreakpoint;
        return result;
    }

    private LCIMMessage createMessageFromCursor(Cursor cursor) {
        String mid = cursor.getString(cursor.getColumnIndex("message_id"));
        long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
        String cid = cursor.getString(cursor.getColumnIndex("conversation_id"));
        String from = cursor.getString(cursor.getColumnIndex("from_peer_id"));
        long deliveredAt = cursor.getLong(cursor.getColumnIndex("receipt_timestamp"));
        long readAt = cursor.getLong(cursor.getColumnIndex("readAt"));
        long updateAt = cursor.getLong(cursor.getColumnIndex("updateAt"));
        byte[] payload = cursor.getBlob(cursor.getColumnIndex("payload"));
        String uniqueToken = cursor.getString(cursor.getColumnIndex("dtoken"));
        int status = cursor.getInt(cursor.getColumnIndex("status"));
        int mentionAll = cursor.getInt(cursor.getColumnIndex("mentionAll"));
        String mentionListStr = cursor.getString(cursor.getColumnIndex("mentionList"));
        int innerType = cursor.getInt(cursor.getColumnIndex("iType"));
        LCIMBinaryMessage message = null;
        if (innerType == 1) {
            message = new LCIMBinaryMessage(cid, from, timestamp, deliveredAt, readAt);
            message.setBytes(payload);
        } else {
            message = new LCIMMessage(cid, from, timestamp, deliveredAt, readAt);
            message.setContent(new String(payload));
        }
        message.setMessageId(mid);
        message.setUniqueToken(uniqueToken);
        message.setMessageStatus(LCIMMessage.MessageStatus.getMessageStatus((int)status));
        message.setUpdateAt(updateAt);
        message.setMentionAll(mentionAll == 1);
        message.setCurrentClient(this.clientId);
        if (!StringUtil.isEmpty((String)mentionListStr)) {
            message.setMentionListString(mentionListStr);
        }
        return LCIMMessageManager.parseTypedMessage((LCIMMessage)message);
    }

    public List<LCIMConversation> queryConversations(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        LinkedList<LCIMConversation> conversations = new LinkedList<LCIMConversation>();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            Cursor cursor = db.query("conversations", columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    LCIMConversation conversation = this.parseConversationFromCursor(cursor);
                    conversations.add(conversation);
                    cursor.moveToNext();
                }
            }
            cursor.close();
        }
        catch (Exception e) {
            LOGGER.w("failed to execute conversation query. cause: " + e.getMessage());
        }
        return conversations;
    }

    public List<LCIMConversation> rawQueryConversations(String sql, String[] selectionArgs) {
        LinkedList<LCIMConversation> conversations = new LinkedList<LCIMConversation>();
        try {
            SQLiteDatabase db = this.dbHelper.getReadableDatabase();
            Cursor cursor = db.rawQuery(sql, selectionArgs);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    LCIMConversation conversation = this.parseConversationFromCursor(cursor);
                    conversations.add(conversation);
                    cursor.moveToNext();
                }
            } else {
                LOGGER.d("rawQuery cursor is empty.");
            }
            cursor.close();
        }
        catch (Exception e) {
            LOGGER.w("failed to execute raw query. cause: " + e.getMessage());
        }
        return conversations;
    }

    private LCIMConversation parseConversationFromCursor(Cursor cursor) {
        String conversationId = cursor.getString(cursor.getColumnIndex("conversation_id"));
        String createdAt = cursor.getString(cursor.getColumnIndex("createdAt"));
        String updatedAt = cursor.getString(cursor.getColumnIndex("updatedAt"));
        String membersStr = cursor.getString(cursor.getColumnIndex("members"));
        String attrsStr = cursor.getString(cursor.getColumnIndex("attr"));
        String instanceData = cursor.getString(cursor.getColumnIndex("instanceData"));
        String creator = cursor.getString(cursor.getColumnIndex("creator"));
        long lastMessageTS = cursor.getLong(cursor.getColumnIndex("lm"));
        int transientValue = cursor.getInt(cursor.getColumnIndex("isTransient"));
        int unreadCount = cursor.getInt(cursor.getColumnIndex("unread_count"));
        int mentioned = cursor.getInt(cursor.getColumnIndex("mentioned"));
        long readAt = cursor.getLong(cursor.getColumnIndex("readAt"));
        long deliveredAt = cursor.getLong(cursor.getColumnIndex("deliveredAt"));
        String lastMessage = cursor.getString(cursor.getColumnIndex("last_message"));
        int lastMessageInnerType = cursor.getInt(cursor.getColumnIndex("last_msg_iType"));
        int system = cursor.getInt(cursor.getColumnIndex("sys"));
        int temporary = cursor.getInt(cursor.getColumnIndex("temp"));
        Object conversation = null;
        if (temporary > 0) {
            conversation = new LCIMTemporaryConversation(LCIMClient.getInstance((String)this.clientId), conversationId);
            long tempExpiredAt = cursor.getLong(cursor.getColumnIndex("temp_ttl"));
            conversation.setTemporaryExpiredat(tempExpiredAt);
        } else {
            conversation = system > 0 ? new LCIMServiceConversation(LCIMClient.getInstance((String)this.clientId), conversationId) : (transientValue > 0 ? new LCIMChatRoom(LCIMClient.getInstance((String)this.clientId), conversationId) : new LCIMConversation(LCIMClient.getInstance((String)this.clientId), conversationId));
        }
        try {
            if (!StringUtil.isEmpty((String)instanceData)) {
                conversation.instanceData.putAll((Map)JSON.parseObject((String)instanceData, HashMap.class));
            }
            conversation.setCreatedAt(createdAt);
            conversation.setUpdatedAt(updatedAt);
            if (!StringUtil.isEmpty((String)membersStr)) {
                ArrayList members = new ArrayList();
                members.addAll((Collection)JSON.parseObject((String)membersStr, Set.class));
                conversation.setMembers(members);
            }
            if (!StringUtil.isEmpty((String)attrsStr)) {
                conversation.setAttributesForInit((Map)JSON.parseObject((String)attrsStr, HashMap.class));
            }
            if (lastMessageInnerType != 1) {
                LCIMMessage msg;
                conversation.lastMessage = msg = (LCIMMessage)JSON.parseObject((String)lastMessage, LCIMMessage.class);
            } else {
                LCIMBinaryMessage binaryMsg = new LCIMBinaryMessage(conversationId, null);
                binaryMsg.setBytes(Base64Decoder.decodeToBytes((String)lastMessage));
                conversation.lastMessage = binaryMsg;
            }
        }
        catch (Exception e) {
            LOGGER.w("failed to parse conversation query result. cause: " + e.getMessage());
        }
        conversation.setCreator(creator);
        conversation.lastMessageAt = new Date(lastMessageTS);
        conversation.unreadMessagesCount = unreadCount;
        conversation.unreadMessagesMentioned = mentioned == 1;
        conversation.lastReadAt = readAt;
        conversation.lastDeliveredAt = deliveredAt;
        return conversation;
    }

    static class DBHelper
    extends SQLiteOpenHelper {
        static final String MESSAGE_CREATE_SQL = "CREATE TABLE IF NOT EXISTS messages (conversation_id VARCHAR(32) NOT NULL, message_id VARCHAR(32) NOT NULL, timestamp NUMBERIC, from_peer_id TEXT NOT NULL, receipt_timestamp NUMBERIC, readAt NUMBERIC, updateAt NUMBERIC, payload BLOB, status INTEGER, breakpoint INTEGER, dtoken VARCHAR(32), mentionAll INTEGER default 0, mentionList TEXT NULL, iType INTEGER default 0, PRIMARY KEY(conversation_id,message_id)) ";
        static final String MESSAGE_UNIQUE_INDEX_SQL = "CREATE UNIQUE INDEX IF NOT EXISTS message_index on messages (conversation_id, timestamp, message_id) ";
        static final String CONVERSATION_CREATE_SQL = "CREATE TABLE IF NOT EXISTS conversations (conversation_id VARCHAR(32) NOT NULL,expireAt NUMBERIC,attr BLOB,instanceData BLOB,updatedAt VARCHAR(64),createdAt VARCHAR(64),creator TEXT,members TEXT,isTransient INTEGER,unread_count INTEGER,readAt NUMBERIC,deliveredAt NUMBERIC,lm NUMBERIC,last_message TEXT,mentioned INTEGER default 0,last_msg_iType INTEGER default 0, sys INTEGER default 0, temp INTEGER default 0, temp_ttl NUMBERIC, PRIMARY KEY(conversation_id))";
        static final String CONVERSATION_ALL_COLUMN = "conversation_id,expireAt,attr,instanceData,updatedAt,createdAt,creator,members,isTransient,unread_count,readAt,deliveredAt,lm,last_message,mentioned,last_msg_iType,sys,temp,temp_ttl";

        public DBHelper(Context context, String clientId) {
            super(context, DBHelper.getDatabasePath(clientId), null, 11);
        }

        private static String getDatabasePath(String clientId) {
            return "com.avos.avoscloud.im.v2." + clientId;
        }

        private static String getAddColumnSql(String table, String column, String type) {
            return String.format("ALTER TABLE %s ADD COLUMN %s %s;", table, column, type);
        }

        private static String getAddColumnSql(String table, String column, String type, String defaultV) {
            return String.format("ALTER TABLE %s ADD COLUMN %s %s default %s;", table, column, type, defaultV);
        }

        public void onCreate(SQLiteDatabase sqLiteDatabase) {
            sqLiteDatabase.execSQL(MESSAGE_CREATE_SQL);
            sqLiteDatabase.execSQL(MESSAGE_UNIQUE_INDEX_SQL);
            sqLiteDatabase.execSQL(CONVERSATION_CREATE_SQL);
            LOGGER.i("Succeed to create sqlite tables with version: 11");
        }

        public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
            if (oldVersion == 1) {
                this.upgradeToVersion2(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 2) {
                this.upgradeToVersion3(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 3) {
                this.upgradeToVersion4(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 4) {
                this.upgradeToVersion5(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 5) {
                this.upgradeToVersion6(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 6) {
                this.upgradeToVersion7(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 7) {
                this.upgradeToVersion8(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 8) {
                this.upgradeToVersion9(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 9) {
                this.upgradeToVersion10(sqLiteDatabase);
                ++oldVersion;
            }
            if (oldVersion == 10) {
                this.upgradeToVersion11(sqLiteDatabase);
                ++oldVersion;
            }
        }

        private void upgradeToVersion2(SQLiteDatabase db) {
            db.execSQL(CONVERSATION_CREATE_SQL);
            LOGGER.i("Succeed to upgrade sqlite to version2.");
        }

        private void upgradeToVersion3(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "messages", "dtoken")) {
                    db.execSQL(DBHelper.getAddColumnSql("messages", "dtoken", "VARCHAR(32)"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version3.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion4(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "conversations", "last_message")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "last_message", "TEXT"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version4.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion5(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "conversations", "instanceData")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "instanceData", "BLOB"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version5.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion6(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "conversations", "unread_count")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "unread_count", "INTEGER"));
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "readAt", "NUMBERIC"));
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "deliveredAt", "NUMBERIC"));
                }
                if (!DBHelper.columnExists(db, "messages", "readAt")) {
                    db.execSQL(DBHelper.getAddColumnSql("messages", "readAt", "NUMBERIC"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version6.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion7(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "messages", "updateAt")) {
                    db.execSQL(DBHelper.getAddColumnSql("messages", "updateAt", "NUMBERIC"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version7.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion8(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "messages", "mentionAll")) {
                    db.execSQL(DBHelper.getAddColumnSql("messages", "mentionAll", "INTEGER", "0"));
                }
                if (!DBHelper.columnExists(db, "messages", "mentionList")) {
                    db.execSQL(DBHelper.getAddColumnSql("messages", "mentionList", "TEXT"));
                }
                if (!DBHelper.columnExists(db, "conversations", "mentioned")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "mentioned", "INTEGER", "0"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version8.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion9(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "messages", "iType")) {
                    db.execSQL(DBHelper.getAddColumnSql("messages", "iType", "INTEGER", "0"));
                }
                if (!DBHelper.columnExists(db, "conversations", "last_msg_iType")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "last_msg_iType", "INTEGER", "0"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version9.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion10(SQLiteDatabase db) {
            try {
                if (!DBHelper.columnExists(db, "conversations", "sys")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "sys", "INTEGER", "0"));
                }
                if (!DBHelper.columnExists(db, "conversations", "temp")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "temp", "INTEGER", "0"));
                }
                if (!DBHelper.columnExists(db, "conversations", "temp_ttl")) {
                    db.execSQL(DBHelper.getAddColumnSql("conversations", "temp_ttl", "NUMBERIC"));
                }
                LOGGER.i("Succeed to upgrade sqlite to version10.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private void upgradeToVersion11(SQLiteDatabase db) {
            try {
                String modifyColumsSql = "BEGIN TRANSACTION;ALTER TABLE conversations RENAME TO _conversation_old;CREATE TABLE IF NOT EXISTS conversations (conversation_id VARCHAR(32) NOT NULL,expireAt NUMBERIC,attr BLOB,instanceData BLOB,updatedAt VARCHAR(64),createdAt VARCHAR(64),creator TEXT,members TEXT,isTransient INTEGER,unread_count INTEGER,readAt NUMBERIC,deliveredAt NUMBERIC,lm NUMBERIC,last_message TEXT,mentioned INTEGER default 0,last_msg_iType INTEGER default 0, sys INTEGER default 0, temp INTEGER default 0, temp_ttl NUMBERIC, PRIMARY KEY(conversation_id));INSERT INFO conversations(conversation_id,expireAt,attr,instanceData,updatedAt,createdAt,creator,members,isTransient,unread_count,readAt,deliveredAt,lm,last_message,mentioned,last_msg_iType,sys,temp,temp_ttl) SELECT conversation_id,expireAt,attr,instanceData,updatedAt,createdAt,creator,members,isTransient,unread_count,readAt,deliveredAt,lm,last_message,mentioned,last_msg_iType,sys,temp,temp_ttl FROM _conversation_old;DROP TABLE _conversation_old;COMMIT;";
                db.execSQL(modifyColumsSql);
                LOGGER.i("Succeed to upgrade sqlite to version11.");
            }
            catch (Exception ex) {
                LOGGER.w("failed to execute upgrade instrument. cause: " + ex.getMessage());
            }
        }

        private static boolean columnExists(SQLiteDatabase db, String table, String column) {
            try {
                Cursor cursor = db.query(table, null, null, null, null, null, null);
                return cursor.getColumnIndex(column) != -1;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

