/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im.v2.audio;

import android.media.MediaRecorder;
import cn.leancloud.LCLogger;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.io.File;
import java.io.IOException;

public class LCIMAudioRecorder {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCIMAudioRecorder.class);
    private static final long MIN_INTERVAL_TIME = 1000L;
    private static final String REASON_TOO_SHORT_TIME = "time is too short(less than 1 second)";
    private MediaRecorder recorder = null;
    private String localPath = null;
    private long startRecordTime = 0L;
    private RecordEventListener listener = null;

    public LCIMAudioRecorder(String path, RecordEventListener listener) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IllegalArgumentException("local path is empty.");
        }
        this.localPath = path;
        this.listener = listener;
    }

    public int getMaxAmplitude() {
        if (null == this.recorder) {
            return 0;
        }
        return this.recorder.getMaxAmplitude();
    }

    public void start() {
        try {
            if (null == this.recorder) {
                this.recorder = new MediaRecorder();
                this.recorder.setAudioSource(0);
                this.recorder.setOutputFormat(0);
                this.recorder.setAudioEncoder(3);
                this.recorder.setOutputFile(this.localPath);
                this.recorder.prepare();
            } else {
                this.recorder.reset();
                this.recorder.setOutputFile(this.localPath);
            }
            this.recorder.start();
            this.startRecordTime = System.currentTimeMillis();
            if (null != this.listener) {
                this.listener.onStartRecord();
            }
        }
        catch (IOException ex) {
            LOGGER.e("failed to start MediaRecorder. cause: ", (Throwable)ex);
        }
    }

    public void stop() {
        this.stopRecorder(true);
    }

    public void cancel() {
        this.stopRecorder(false);
        this.removeRecordFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRecorder(boolean notify) {
        if (this.recorder != null) {
            try {
                this.recorder.stop();
                if (notify && null != this.listener) {
                    long intervalTime = System.currentTimeMillis() - this.startRecordTime;
                    if (intervalTime < 1000L) {
                        this.removeRecordFile();
                        this.listener.onFinishedRecord(0L, REASON_TOO_SHORT_TIME);
                    } else {
                        this.listener.onFinishedRecord(intervalTime, null);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.e("failed to stop MediaRecorder. cause: ", (Throwable)e);
            }
            finally {
                this.recorder.release();
                this.recorder = null;
            }
        }
    }

    private void removeRecordFile() {
        File file = new File(this.localPath);
        if (file.exists()) {
            file.delete();
        }
    }

    public static interface RecordEventListener {
        public void onFinishedRecord(long var1, String var3);

        public void onStartRecord();
    }
}

