/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im;

import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import cn.leancloud.LCException;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.LeanCloud;
import cn.leancloud.callback.LCCallback;
import cn.leancloud.codec.MDFive;
import cn.leancloud.im.IntentUtil;
import cn.leancloud.im.LCIMBaseBroadcastReceiver;
import cn.leancloud.im.OperationTube;
import cn.leancloud.im.RequestCache;
import cn.leancloud.im.WindTalker;
import cn.leancloud.im.v2.Conversation;
import cn.leancloud.im.v2.LCIMClient;
import cn.leancloud.im.v2.LCIMException;
import cn.leancloud.im.v2.LCIMMessage;
import cn.leancloud.im.v2.LCIMMessageOption;
import cn.leancloud.im.v2.callback.LCIMClientCallback;
import cn.leancloud.im.v2.callback.LCIMClientStatusCallback;
import cn.leancloud.im.v2.callback.LCIMCommonJsonCallback;
import cn.leancloud.im.v2.callback.LCIMConversationCallback;
import cn.leancloud.im.v2.callback.LCIMConversationIterableResult;
import cn.leancloud.im.v2.callback.LCIMConversationIterableResultCallback;
import cn.leancloud.im.v2.callback.LCIMMessagesQueryCallback;
import cn.leancloud.im.v2.callback.LCIMOnlineClientsCallback;
import cn.leancloud.json.JSON;
import cn.leancloud.livequery.LCLiveQuerySubscribeCallback;
import cn.leancloud.push.PushService;
import cn.leancloud.session.LCConnectionManager;
import cn.leancloud.session.LCSession;
import cn.leancloud.session.LCSessionManager;
import cn.leancloud.utils.LocalBroadcastManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidOperationTube
implements OperationTube {
    private static LCLogger LOGGER = LogUtil.getLogger(AndroidOperationTube.class);

    public boolean openClient(LCConnectionManager connectionManager, final String clientId, String tag, String userSessionToken, boolean reConnect, LCIMClientCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client.tag", tag);
        params.put("client.userSession", userSessionToken);
        params.put("client.reconnect", reConnect);
        LOGGER.d("openClient. clientId:" + clientId + ", tag:" + tag + ", callback:" + callback);
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    LOGGER.d("openClient get response. error:" + error);
                    this.callback.internalDone((Object)LCIMClient.getInstance((String)clientId), (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, JSON.toJSONString(params), receiver, Conversation.LCIMOperation.CLIENT_OPEN);
    }

    public boolean queryClientStatus(LCConnectionManager connectionManager, String clientId, LCIMClientStatusCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    LCIMClient.LCIMClientStatus status = null;
                    if (null != intentResult && intentResult.containsKey("callbackClientStatus")) {
                        status = LCIMClient.LCIMClientStatus.getClientStatus((int)((Integer)intentResult.get("callbackClientStatus")));
                    }
                    this.callback.internalDone(status, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, null, receiver, Conversation.LCIMOperation.CLIENT_STATUS);
    }

    public boolean closeClient(LCConnectionManager connectionManager, final String self, LCIMClientCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    LCIMClient client = LCIMClient.getInstance((String)self);
                    this.callback.internalDone((Object)client, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(self, null, receiver, Conversation.LCIMOperation.CLIENT_DISCONNECT);
    }

    public boolean renewSessionToken(LCConnectionManager connectionManager, String clientId, LCIMClientCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(null, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, null, receiver, Conversation.LCIMOperation.CLIENT_REFRESH_TOKEN);
    }

    public boolean queryOnlineClients(LCConnectionManager connectionManager, String self, List<String> clients, LCIMOnlineClientsCallback callback) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("client.oneline", clients);
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    if (error != null) {
                        this.callback.internalDone(null, (LCException)LCIMException.wrapperException((Throwable)error));
                    } else {
                        List onlineClients = null;
                        if (null != intentResult && intentResult.containsKey("callbackOnlineClient")) {
                            onlineClients = (List)intentResult.get("callbackOnlineClient");
                        }
                        this.callback.internalDone(onlineClients, null);
                    }
                }
            };
        }
        return this.sendClientCMDToPushService(self, JSON.toJSONString(params), receiver, Conversation.LCIMOperation.CLIENT_ONLINE_QUERY);
    }

    public boolean createConversation(LCConnectionManager connectionManager, String self, List<String> members, Map<String, Object> attributes, boolean isTransient, boolean isUnique, boolean isTemp, int tempTTL, LCIMCommonJsonCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("conversation.member", members);
        params.put("conversation.unique", isUnique);
        params.put("conversation.transient", isTransient);
        params.put("conversation.temp", isTemp);
        if (isTemp) {
            params.put("conversation.tempTTL", tempTTL);
        }
        if (null != attributes && attributes.size() > 0) {
            params.put("conversation.attributes", attributes);
        }
        LCIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(self, JSON.toJSONString(params), receiver, Conversation.LCIMOperation.CONVERSATION_CREATION);
    }

    public boolean updateConversation(LCConnectionManager connectionManager, String clientId, String conversationId, int convType, Map<String, Object> param, LCIMCommonJsonCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, JSON.toJSONString(param), null, null, Conversation.LCIMOperation.CONVERSATION_UPDATE, receiver);
    }

    public boolean participateConversation(LCConnectionManager connectionManager, String clientId, String conversationId, int convType, Map<String, Object> param, Conversation.LCIMOperation operation, LCIMConversationCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        String paramString = null != param ? JSON.toJSONString(param) : null;
        return this.sendClientCMDToPushService(clientId, conversationId, convType, paramString, null, null, operation, receiver);
    }

    public boolean queryConversations(LCConnectionManager connectionManager, String clientId, String queryString, LCIMCommonJsonCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, queryString, receiver, Conversation.LCIMOperation.CONVERSATION_QUERY);
    }

    public boolean queryConversationsInternally(LCConnectionManager connectionManager, String clientId, String queryString, LCIMCommonJsonCallback callback) {
        LOGGER.d("queryConversationsInternally...");
        int requestId = WindTalker.getNextIMRequestId();
        RequestCache.getInstance().addRequestCallback(clientId, null, requestId, (LCCallback)callback);
        LCSession session = LCSessionManager.getInstance().getOrCreateSession(clientId, LCInstallation.getCurrentInstallation().getInstallationId(), connectionManager);
        session.queryConversations((Map)JSON.parseObject((String)queryString, Map.class), requestId, MDFive.computeMD5((String)queryString));
        return true;
    }

    public boolean sendMessage(LCConnectionManager connectionManager, String clientId, String conversationId, int convType, LCIMMessage message, LCIMMessageOption messageOption, LCIMCommonJsonCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, null, message, messageOption, Conversation.LCIMOperation.CONVERSATION_SEND_MESSAGE, receiver);
    }

    public boolean updateMessage(LCConnectionManager connectionManager, String clientId, int convType, LCIMMessage oldMessage, LCIMMessage newMessage, LCIMCommonJsonCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService2(clientId, oldMessage.getConversationId(), convType, oldMessage, newMessage, Conversation.LCIMOperation.CONVERSATION_UPDATE_MESSAGE, receiver);
    }

    public boolean recallMessage(LCConnectionManager connectionManager, String clientId, int convType, LCIMMessage message, LCIMCommonJsonCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, message.getConversationId(), convType, null, message, null, Conversation.LCIMOperation.CONVERSATION_RECALL_MESSAGE, receiver);
    }

    public boolean fetchReceiptTimestamps(LCConnectionManager connectionManager, String clientId, String conversationId, int convType, Conversation.LCIMOperation operation, LCIMCommonJsonCallback callback) {
        return false;
    }

    public boolean queryMessages(LCConnectionManager connectionManager, String clientId, String conversationId, int convType, String params, Conversation.LCIMOperation operation, LCIMMessagesQueryCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    List msg = null == intentResult ? null : (List)intentResult.get("callbackHistoryMessages");
                    this.callback.internalDone((Object)msg, (LCException)LCIMException.wrapperException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, params, null, null, Conversation.LCIMOperation.CONVERSATION_MESSAGE_QUERY, receiver);
    }

    public boolean processMembers(LCConnectionManager connectionManager, String clientId, String conversationId, int convType, String params, final Conversation.LCIMOperation op, LCCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new LCIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    if (Conversation.LCIMOperation.CONVERSATION_MEMBER_COUNT_QUERY == op) {
                        Object memberCount;
                        int result = 0;
                        if (null != intentResult && (memberCount = intentResult.get("callbackMemberCount")) instanceof Integer) {
                            result = (Integer)memberCount;
                        }
                        this.callback.internalDone((Object)result, (LCException)LCIMException.wrapperException((Throwable)error));
                    } else if (Conversation.LCIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY == op || Conversation.LCIMOperation.CONVERSATION_MUTED_MEMBER_QUERY == op) {
                        ArrayList<String> result = new ArrayList<String>();
                        String next = null;
                        if (null != intentResult) {
                            Object memberList = intentResult.get("callbackData");
                            next = (String)intentResult.get("callbackNext");
                            if (memberList instanceof Collection) {
                                result.addAll((Collection)memberList);
                            } else if (memberList instanceof String[]) {
                                result.addAll(Arrays.asList((String[])memberList));
                            }
                        }
                        if (this.callback instanceof LCIMConversationIterableResultCallback) {
                            LCIMConversationIterableResult iterableResult = new LCIMConversationIterableResult();
                            iterableResult.setMembers(result);
                            iterableResult.setNext(next);
                            this.callback.internalDone((Object)iterableResult, (LCException)LCIMException.wrapperException((Throwable)error));
                        } else {
                            this.callback.internalDone(result, (LCException)LCIMException.wrapperException((Throwable)error));
                        }
                    } else {
                        this.callback.internalDone(intentResult, (LCException)LCIMException.wrapperException((Throwable)error));
                    }
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, params, null, null, op, receiver);
    }

    public boolean markConversationRead(LCConnectionManager connectionManager, String clientId, String conversationId, int convType, Map<String, Object> lastMessageParam) {
        String dataString = null == lastMessageParam ? null : JSON.toJSONString(lastMessageParam);
        return this.sendClientCMDToPushService(clientId, conversationId, convType, dataString, null, null, Conversation.LCIMOperation.CONVERSATION_READ, null);
    }

    public boolean loginLiveQuery(LCConnectionManager connectionManager, String subscriptionId, LCLiveQuerySubscribeCallback callback) {
        LCIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new LCIMBaseBroadcastReceiver((LCCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    if (null != this.callback) {
                        this.callback.internalDone(null == error ? null : new LCException(error));
                    }
                }
            };
        }
        if (LeanCloud.getContext() == null) {
            LOGGER.e("failed to startService. cause: root Context is null.");
            if (null != callback) {
                callback.internalDone(new LCException(-1, "root Context is null, please initialize at first."));
            }
            return false;
        }
        int requestId = WindTalker.getNextIMRequestId();
        LocalBroadcastManager.getInstance(LeanCloud.getContext()).registerReceiver(receiver, new IntentFilter("live_query_" + requestId));
        try {
            Intent i = new Intent(LeanCloud.getContext(), PushService.class);
            i.setAction("action_live_query_login");
            i.putExtra("id", subscriptionId);
            i.putExtra("conversation.requestId", requestId);
            LeanCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to start PushServer. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean sendClientCMDToPushService(String clientId, String dataAsString, BroadcastReceiver receiver, Conversation.LCIMOperation operation) {
        if (LeanCloud.getContext() == null) {
            LOGGER.e("failed to startService. cause: root Context is null.");
            if (null != receiver && receiver instanceof LCIMBaseBroadcastReceiver) {
                ((LCIMBaseBroadcastReceiver)receiver).execute(new HashMap<String, Object>(), (Throwable)new LCException(-1, "root Context is null, please initialize at first."));
            }
            return false;
        }
        int requestId = WindTalker.getNextIMRequestId();
        if (receiver != null) {
            LocalBroadcastManager.getInstance(LeanCloud.getContext()).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(LeanCloud.getContext(), PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (!StringUtil.isEmpty((String)dataAsString)) {
            i.putExtra("conversation.data", dataAsString);
        }
        i.putExtra("conversation.client", clientId);
        i.putExtra("conversation.requestId", requestId);
        i.putExtra("conversation.operation", operation.getCode());
        try {
            LeanCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to startService. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean sendClientCMDToPushService(String clientId, String conversationId, int convType, String dataAsString, LCIMMessage message, LCIMMessageOption option, Conversation.LCIMOperation operation, BroadcastReceiver receiver) {
        if (LeanCloud.getContext() == null) {
            LOGGER.e("failed to startService. cause: root Context is null.");
            if (null != receiver && receiver instanceof LCIMBaseBroadcastReceiver) {
                ((LCIMBaseBroadcastReceiver)receiver).execute(new HashMap<String, Object>(), (Throwable)new LCException(-1, "root Context is null, please initialize at first."));
            }
            return false;
        }
        int requestId = WindTalker.getNextIMRequestId();
        if (null != receiver) {
            LocalBroadcastManager.getInstance(LeanCloud.getContext()).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(LeanCloud.getContext(), PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (!StringUtil.isEmpty((String)dataAsString)) {
            i.putExtra("conversation.data", dataAsString);
        }
        if (null != message) {
            i.putExtra("conversation.data", message.toJSONString());
            if (null != option) {
                i.putExtra("conversation.messageoption", option.toJSONString());
            }
        }
        i.putExtra("conversation.client", clientId);
        i.putExtra("convesration.id", conversationId);
        i.putExtra("conversation.type", convType);
        i.putExtra("conversation.operation", operation.getCode());
        i.putExtra("conversation.requestId", requestId);
        try {
            LeanCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to startService. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean sendClientCMDToPushService2(String clientId, String conversationId, int convType, LCIMMessage message, LCIMMessage message2, Conversation.LCIMOperation operation, BroadcastReceiver receiver) {
        if (LeanCloud.getContext() == null) {
            LOGGER.e("failed to startService. cause: root Context is null.");
            if (null != receiver && receiver instanceof LCIMBaseBroadcastReceiver) {
                ((LCIMBaseBroadcastReceiver)receiver).execute(new HashMap<String, Object>(), (Throwable)new LCException(-1, "root Context is null, please initialize at first."));
            }
            return false;
        }
        int requestId = WindTalker.getNextIMRequestId();
        if (null != receiver) {
            LocalBroadcastManager.getInstance(LeanCloud.getContext()).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(LeanCloud.getContext(), PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (null != message) {
            i.putExtra("conversation.data", message.toJSONString());
        }
        if (null != message2) {
            i.putExtra("conversation.message.ex", message2.toJSONString());
        }
        i.putExtra("conversation.client", clientId);
        i.putExtra("convesration.id", conversationId);
        i.putExtra("conversation.type", convType);
        i.putExtra("conversation.operation", operation.getCode());
        i.putExtra("conversation.requestId", requestId);
        try {
            LeanCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to startService. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    public void onOperationCompleted(String clientId, String conversationId, int requestId, Conversation.LCIMOperation operation, Throwable throwable) {
        LCCallback callback;
        if (Conversation.LCIMOperation.CONVERSATION_QUERY == operation && null != (callback = RequestCache.getInstance().getRequestCallback(clientId, null, requestId))) {
            callback.internalDone(null, (LCException)LCIMException.wrapperException((Throwable)throwable));
            RequestCache.getInstance().cleanRequestCallback(clientId, null, requestId);
            return;
        }
        IntentUtil.sendIMLocalBroadcast(clientId, conversationId, requestId, throwable, operation);
    }

    public void onOperationCompletedEx(String clientId, String conversationId, int requestId, Conversation.LCIMOperation operation, HashMap<String, Object> resultData) {
        LCCallback callback;
        if (Conversation.LCIMOperation.CONVERSATION_QUERY == operation && null != (callback = RequestCache.getInstance().getRequestCallback(clientId, null, requestId))) {
            callback.internalDone(resultData, null);
            RequestCache.getInstance().cleanRequestCallback(clientId, null, requestId);
            return;
        }
        IntentUtil.sendMap2LocalBroadcase(clientId, conversationId, requestId, resultData, null, operation);
    }

    public void onLiveQueryCompleted(int requestId, Throwable throwable) {
        IntentUtil.sendLiveQueryLocalBroadcast(requestId, throwable);
    }

    public void onPushMessage(String message, String messageId) {
    }
}

