/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import cn.leancloud.LCLogger;
import cn.leancloud.LeanCloud;
import cn.leancloud.push.LCNotificationManager;
import cn.leancloud.push.PushService;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.Random;

public class AndroidNotificationManager
extends LCNotificationManager {
    private static final LCLogger LOGGER = LogUtil.getLogger(AndroidNotificationManager.class);
    private static final String PUSH_INTENT_KEY = "com.avoscloud.push";
    private static final Random random = new Random();
    private static final AndroidNotificationManager INSTANCE = new AndroidNotificationManager();
    private Context serviceContext;

    public static AndroidNotificationManager getInstance() {
        return INSTANCE;
    }

    private AndroidNotificationManager() {
    }

    public void setServiceContext(Context context) {
        this.serviceContext = context;
    }

    private Intent buildUpdateIntent(String channel, String msg, String action) {
        Intent updateIntent = new Intent();
        if (action != null) {
            updateIntent.setAction(action);
        }
        updateIntent.putExtra(PUSH_INTENT_KEY, 1);
        updateIntent.putExtra("com.avos.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avos.avoscloud.Data", msg);
        updateIntent.putExtra("com.avoscloud.Data", msg);
        if (null != LeanCloud.getContext()) {
            updateIntent.setPackage(LeanCloud.getContext().getPackageName());
        } else {
            updateIntent.setPackage(this.serviceContext.getPackageName());
        }
        return updateIntent;
    }

    void sendNotification(String from, String msg) throws IllegalArgumentException {
        Intent resultIntent = this.buildUpdateIntent(from, msg, null);
        this.sendNotification(from, msg, resultIntent);
    }

    static String getNotificationChannel(String msg) {
        return AndroidNotificationManager.getJSONValue((String)msg, (String)"_notificationChannel");
    }

    @TargetApi(value=26)
    private void sendNotification(String from, String msg, Intent resultIntent) {
        String clsName = this.getDefaultPushCallback(from);
        if (StringUtil.isEmpty((String)clsName)) {
            throw new IllegalArgumentException("No default callback found, did you forget to invoke setDefaultPushCallback?");
        }
        Context context = null != LeanCloud.getContext() ? LeanCloud.getContext() : this.serviceContext;
        int lastIndex = clsName.lastIndexOf(".");
        if (lastIndex != -1) {
            Notification.Builder builder;
            int notificationId = random.nextInt();
            ComponentName cn = new ComponentName(context, clsName);
            resultIntent.setComponent(cn);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)notificationId, (Intent)resultIntent, (int)0);
            String sound = this.getSound(msg);
            String title = this.getTitle(msg);
            String notificationChannel = AndroidNotificationManager.getNotificationChannel(msg);
            String content = AndroidNotificationManager.getText((String)msg);
            Notification notification = null;
            if (Build.VERSION.SDK_INT <= 25) {
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)title).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setContentText((CharSequence)content);
                notification = mBuilder.build();
            } else if (!StringUtil.isEmpty((String)notificationChannel)) {
                builder = new Notification.Builder(context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setAutoCancel(true).setContentIntent(contentIntent).setChannelId(notificationChannel);
                notification = builder.build();
            } else {
                builder = new Notification.Builder(context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setChannelId(PushService.DefaultChannelId);
                notification = builder.build();
            }
            if (sound != null && sound.trim().length() > 0) {
                notification.sound = Uri.parse((String)("android.resource://" + sound));
            }
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.notify(notificationId, notification);
        } else {
            LOGGER.e("Class name is invalid, which must contain '.': " + clsName);
        }
    }

    String getApplicationName() {
        ApplicationInfo ai;
        Context context = null != LeanCloud.getContext() ? LeanCloud.getContext() : this.serviceContext;
        PackageManager pm = context.getPackageManager();
        try {
            ai = pm.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        String applicationName = ai != null ? pm.getApplicationLabel(ai) : "Notification";
        return applicationName;
    }

    void sendBroadcast(String channel, String msg, String action) {
        Intent updateIntent = this.buildUpdateIntent(channel, msg, action);
        LOGGER.d("action: " + updateIntent.getAction());
        Context context = null != LeanCloud.getContext() ? LeanCloud.getContext() : this.serviceContext;
        context.sendBroadcast(updateIntent);
        LOGGER.d("sent broadcast");
    }

    public void processMixPushMessage(String message) {
        if (!StringUtil.isEmpty((String)message)) {
            String channel = AndroidNotificationManager.getChannel((String)message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = LeanCloud.getApplicationId();
            }
            String action = AndroidNotificationManager.getAction((String)message);
            boolean isSlient = AndroidNotificationManager.getSilent((String)message);
            if (action != null) {
                this.sendBroadcast(channel, message, action);
            } else if (!isSlient) {
                this.sendNotification(channel, message);
            } else {
                LOGGER.e("ignore push silent message: " + message);
            }
        }
    }

    public void porcessMixNotificationArrived(String message, String action) {
        if (!StringUtil.isEmpty((String)message) && !StringUtil.isEmpty((String)action)) {
            String channel = AndroidNotificationManager.getChannel((String)message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = LeanCloud.getApplicationId();
            }
            this.sendNotificationBroadcast(channel, message, action);
        }
    }

    public void processMixNotification(String message, String defaultAction) {
        if (StringUtil.isEmpty((String)message)) {
            LOGGER.e("message is empty, ignore.");
        } else {
            String action;
            String channel = AndroidNotificationManager.getChannel((String)message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = LeanCloud.getApplicationId();
            }
            if (null != (action = AndroidNotificationManager.getAction((String)message))) {
                this.sendNotificationBroadcast(channel, message, defaultAction);
            } else {
                String clsName = this.getDefaultPushCallback(channel);
                if (StringUtil.isEmpty((String)clsName)) {
                    LOGGER.e("className is empty, ignore.");
                } else {
                    Context context = null != LeanCloud.getContext() ? LeanCloud.getContext() : this.serviceContext;
                    Intent intent = this.buildUpdateIntent(channel, message, null);
                    ComponentName cn = new ComponentName(context, clsName);
                    intent.setComponent(cn);
                    intent.setFlags(0x20000000);
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
                    try {
                        pendingIntent.send();
                    }
                    catch (PendingIntent.CanceledException e) {
                        LOGGER.e("Ocurred PendingIntent.CanceledException", (Throwable)e);
                    }
                }
            }
        }
    }

    public void processFcmMessage(String channel, String action, String message) {
        if (!StringUtil.isEmpty((String)message)) {
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = LeanCloud.getApplicationId();
            }
            if (action != null) {
                this.sendBroadcast(channel, message, action);
            } else {
                this.sendNotification(channel, message);
            }
        }
    }

    private void sendNotificationBroadcast(String channel, String msg, String action) {
        Intent updateIntent = this.buildUpdateIntent(channel, msg, action);
        LOGGER.d("action: " + updateIntent.getAction());
        Context context = null != LeanCloud.getContext() ? LeanCloud.getContext() : this.serviceContext;
        context.sendBroadcast(updateIntent);
        LOGGER.d("sent broadcast");
    }
}

