/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import cn.leancloud.AVOSCloud;
import cn.leancloud.im.v2.Conversation;
import cn.leancloud.utils.StringUtil;
import java.io.Serializable;
import java.util.HashMap;

public class IntentUtil {
    public static final String CALLBACK_RESULT_KEY = "callbackHashMap";

    public static Intent setupIntentFlags(Intent i) {
        if (Build.VERSION.SDK_INT > 11) {
            i.setFlags(32);
        }
        return i;
    }

    public static void sendIMLocalBroadcast(String clientId, String conversationId, int requestId, Conversation.AVIMOperation operation) {
        IntentUtil.sendIMLocalBroadcast(clientId, conversationId, requestId, null, null, operation);
    }

    public static void sendIMLocalBroadcast(String clientId, String conversationId, int requestId, Throwable throwable, Conversation.AVIMOperation operation) {
        IntentUtil.sendIMLocalBroadcast(clientId, conversationId, requestId, null, throwable, operation);
    }

    public static void sendIMLocalBroadcast(String clientId, String conversationId, int requestId, Bundle bundle, Conversation.AVIMOperation operation) {
        IntentUtil.sendIMLocalBroadcast(clientId, conversationId, requestId, bundle, null, operation);
    }

    public static void sendMap2LocalBroadcase(String clientId, String conversationId, int requestId, HashMap<String, Object> result, Throwable throwable, Conversation.AVIMOperation operation) {
        if (IntentUtil.isOperationValid(operation)) {
            String keyHeader = operation.getOperation();
            Intent callbackIntent = new Intent(keyHeader + requestId);
            callbackIntent.putExtra("callbackclient", clientId);
            if (!StringUtil.isEmpty((String)conversationId)) {
                callbackIntent.putExtra("callbackconversation", conversationId);
            }
            if (null != throwable) {
                callbackIntent.putExtra("callbackException", (Serializable)throwable);
            }
            if (null != result) {
                callbackIntent.putExtra(CALLBACK_RESULT_KEY, result);
            }
            LocalBroadcastManager.getInstance((Context)AVOSCloud.getContext()).sendBroadcast(callbackIntent);
        }
    }

    public static void sendLiveQueryLocalBroadcast(int requestId, Throwable throwable) {
        Intent callbackIntent = new Intent("live_query_" + requestId);
        if (null != throwable) {
            callbackIntent.putExtra("callbackException", (Serializable)throwable);
        }
        LocalBroadcastManager.getInstance((Context)AVOSCloud.getContext()).sendBroadcast(callbackIntent);
    }

    private static void sendIMLocalBroadcast(String clientId, String conversationId, int requestId, Bundle bundle, Throwable throwable, Conversation.AVIMOperation operation) {
        if (IntentUtil.isOperationValid(operation)) {
            String keyHeader = operation.getOperation();
            Intent callbackIntent = new Intent(keyHeader + requestId);
            callbackIntent.putExtra("callbackclient", clientId);
            if (!StringUtil.isEmpty((String)conversationId)) {
                callbackIntent.putExtra("callbackconversation", conversationId);
            }
            if (null != throwable) {
                callbackIntent.putExtra("callbackException", (Serializable)throwable);
            }
            if (null != bundle) {
                callbackIntent.putExtras(bundle);
            }
            LocalBroadcastManager.getInstance((Context)AVOSCloud.getContext()).sendBroadcast(callbackIntent);
        }
    }

    private static boolean isOperationValid(Conversation.AVIMOperation operation) {
        return null != operation && Conversation.AVIMOperation.CONVERSATION_UNKNOWN.getCode() != operation.getCode();
    }
}

