/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import cn.leancloud.AVException;
import cn.leancloud.AVLogger;
import cn.leancloud.AVOSCloud;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.im.AVIMBaseBroadcastReceiver;
import cn.leancloud.im.IntentUtil;
import cn.leancloud.im.OperationTube;
import cn.leancloud.im.RequestCache;
import cn.leancloud.im.WindTalker;
import cn.leancloud.im.v2.AVIMClient;
import cn.leancloud.im.v2.AVIMException;
import cn.leancloud.im.v2.AVIMMessage;
import cn.leancloud.im.v2.AVIMMessageOption;
import cn.leancloud.im.v2.Conversation;
import cn.leancloud.im.v2.callback.AVIMClientCallback;
import cn.leancloud.im.v2.callback.AVIMClientStatusCallback;
import cn.leancloud.im.v2.callback.AVIMCommonJsonCallback;
import cn.leancloud.im.v2.callback.AVIMConversationCallback;
import cn.leancloud.im.v2.callback.AVIMMessagesQueryCallback;
import cn.leancloud.im.v2.callback.AVIMOnlineClientsCallback;
import cn.leancloud.livequery.AVLiveQuerySubscribeCallback;
import cn.leancloud.push.PushService;
import cn.leancloud.session.AVSession;
import cn.leancloud.session.AVSessionManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidOperationTube
implements OperationTube {
    private static AVLogger LOGGER = LogUtil.getLogger(AndroidOperationTube.class);

    public boolean openClient(final String clientId, String tag, String userSessionToken, boolean reConnect, AVIMClientCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client.tag", tag);
        params.put("client.userSession", userSessionToken);
        params.put("client.reconnect", reConnect);
        LOGGER.d("openClient. clientId:" + clientId + ", tag:" + tag + ", callback:" + callback);
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    LOGGER.d("openClient get response. error:" + error);
                    this.callback.internalDone((Object)AVIMClient.getInstance((String)clientId), (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, JSON.toJSONString(params), receiver, Conversation.AVIMOperation.CLIENT_OPEN);
    }

    public boolean queryClientStatus(String clientId, AVIMClientStatusCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    AVIMClient.AVIMClientStatus status = null;
                    if (null != intentResult && intentResult.containsKey("callbackClientStatus")) {
                        status = AVIMClient.AVIMClientStatus.getClientStatus((int)((Integer)intentResult.get("callbackClientStatus")));
                    }
                    this.callback.internalDone(status, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, null, receiver, Conversation.AVIMOperation.CLIENT_STATUS);
    }

    public boolean closeClient(final String self, AVIMClientCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    AVIMClient client = AVIMClient.getInstance((String)self);
                    this.callback.internalDone((Object)client, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(self, null, receiver, Conversation.AVIMOperation.CLIENT_DISCONNECT);
    }

    public boolean renewSessionToken(String clientId, AVIMClientCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(null, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, null, receiver, Conversation.AVIMOperation.CLIENT_REFRESH_TOKEN);
    }

    public boolean queryOnlineClients(String self, List<String> clients, AVIMOnlineClientsCallback callback) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("client.oneline", clients);
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    if (error != null) {
                        this.callback.internalDone(null, (AVException)AVIMException.wrapperAVException((Throwable)error));
                    } else {
                        List onlineClients = null;
                        if (null != intentResult && intentResult.containsKey("callbackOnlineClient")) {
                            onlineClients = (List)intentResult.get("callbackOnlineClient");
                        }
                        this.callback.internalDone(onlineClients, null);
                    }
                }
            };
        }
        return this.sendClientCMDToPushService(self, JSON.toJSONString(params), receiver, Conversation.AVIMOperation.CLIENT_ONLINE_QUERY);
    }

    public boolean createConversation(String self, List<String> members, Map<String, Object> attributes, boolean isTransient, boolean isUnique, boolean isTemp, int tempTTL, AVIMCommonJsonCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("conversation.member", members);
        params.put("conversation.unique", isUnique);
        params.put("conversation.transient", isTransient);
        params.put("conversation.temp", isTemp);
        if (isTemp) {
            params.put("conversation.tempTTL", tempTTL);
        }
        if (null != attributes && attributes.size() > 0) {
            params.put("conversation.attributes", attributes);
        }
        AVIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(self, JSON.toJSONString(params), receiver, Conversation.AVIMOperation.CONVERSATION_CREATION);
    }

    public boolean updateConversation(String clientId, String conversationId, int convType, Map<String, Object> param, AVIMCommonJsonCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, JSON.toJSONString(param), null, null, Conversation.AVIMOperation.CONVERSATION_UPDATE, receiver);
    }

    public boolean participateConversation(String clientId, String conversationId, int convType, Map<String, Object> param, Conversation.AVIMOperation operation, AVIMConversationCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        String paramString = null != param ? JSON.toJSONString(param) : null;
        return this.sendClientCMDToPushService(clientId, conversationId, convType, paramString, null, null, operation, receiver);
    }

    public boolean queryConversations(String clientId, String queryString, AVIMCommonJsonCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (callback != null) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, queryString, receiver, Conversation.AVIMOperation.CONVERSATION_QUERY);
    }

    public boolean queryConversationsInternally(String clientId, String queryString, AVIMCommonJsonCallback callback) {
        LOGGER.d("queryConversationsInternally...");
        int requestId = WindTalker.getNextIMRequestId();
        RequestCache.getInstance().addRequestCallback(clientId, null, requestId, (AVCallback)callback);
        AVSession session = AVSessionManager.getInstance().getOrCreateSession(clientId);
        session.queryConversations((Map)JSON.parseObject((String)queryString, Map.class), requestId);
        return true;
    }

    public boolean sendMessage(String clientId, String conversationId, int convType, AVIMMessage message, AVIMMessageOption messageOption, AVIMCommonJsonCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, null, message, messageOption, Conversation.AVIMOperation.CONVERSATION_SEND_MESSAGE, receiver);
    }

    public boolean updateMessage(String clientId, int convType, AVIMMessage oldMessage, AVIMMessage newMessage, AVIMCommonJsonCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService2(clientId, oldMessage.getConversationId(), convType, oldMessage, newMessage, Conversation.AVIMOperation.CONVERSATION_UPDATE_MESSAGE, receiver);
    }

    public boolean recallMessage(String clientId, int convType, AVIMMessage message, AVIMCommonJsonCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, message.getConversationId(), convType, null, message, null, Conversation.AVIMOperation.CONVERSATION_RECALL_MESSAGE, receiver);
    }

    public boolean fetchReceiptTimestamps(String clientId, String conversationId, int convType, Conversation.AVIMOperation operation, AVIMCommonJsonCallback callback) {
        return false;
    }

    public boolean queryMessages(String clientId, String conversationId, int convType, String params, Conversation.AVIMOperation operation, AVIMMessagesQueryCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    List msg = null == intentResult ? null : (List)intentResult.get("callbackHistoryMessages");
                    this.callback.internalDone((Object)msg, (AVException)AVIMException.wrapperAVException((Throwable)error));
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, params, null, null, Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY, receiver);
    }

    public boolean processMembers(String clientId, String conversationId, int convType, String params, final Conversation.AVIMOperation op, AVCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new AVIMBaseBroadcastReceiver(callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    if (Conversation.AVIMOperation.CONVERSATION_MEMBER_COUNT_QUERY == op) {
                        Object memberCount;
                        int result = 0;
                        if (null != intentResult && (memberCount = intentResult.get("callbackMemberCount")) instanceof Integer) {
                            result = (Integer)memberCount;
                        }
                        this.callback.internalDone((Object)result, (AVException)AVIMException.wrapperAVException((Throwable)error));
                    } else if (Conversation.AVIMOperation.CONVERSATION_BLOCKED_MEMBER_QUERY == op || Conversation.AVIMOperation.CONVERSATION_MUTED_MEMBER_QUERY == op) {
                        ArrayList<String> result = new ArrayList<String>();
                        if (null != intentResult) {
                            Object memberList = intentResult.get("callbackData");
                            if (memberList instanceof Collection) {
                                result.addAll((Collection)memberList);
                            } else if (memberList instanceof String[]) {
                                result.addAll(Arrays.asList((String[])memberList));
                            }
                        }
                        this.callback.internalDone(result, (AVException)AVIMException.wrapperAVException((Throwable)error));
                    } else {
                        this.callback.internalDone(intentResult, (AVException)AVIMException.wrapperAVException((Throwable)error));
                    }
                }
            };
        }
        return this.sendClientCMDToPushService(clientId, conversationId, convType, params, null, null, op, receiver);
    }

    public boolean markConversationRead(String clientId, String conversationId, int convType, Map<String, Object> lastMessageParam) {
        String dataString = null == lastMessageParam ? null : JSON.toJSONString(lastMessageParam);
        return this.sendClientCMDToPushService(clientId, conversationId, convType, dataString, null, null, Conversation.AVIMOperation.CONVERSATION_READ, null);
    }

    public boolean loginLiveQuery(String subscriptionId, AVLiveQuerySubscribeCallback callback) {
        AVIMBaseBroadcastReceiver receiver = null;
        if (null != callback) {
            receiver = new AVIMBaseBroadcastReceiver((AVCallback)callback){

                @Override
                public void execute(Map<String, Object> intentResult, Throwable error) {
                    if (null != this.callback) {
                        this.callback.internalDone(null == error ? null : new AVException(error));
                    }
                }
            };
        }
        int requestId = WindTalker.getNextIMRequestId();
        LocalBroadcastManager.getInstance((Context)AVOSCloud.getContext()).registerReceiver((BroadcastReceiver)receiver, new IntentFilter("live_query_" + requestId));
        try {
            Intent i = new Intent(AVOSCloud.getContext(), PushService.class);
            i.setAction("action_live_query_login");
            i.putExtra("id", subscriptionId);
            i.putExtra("conversation.requestId", requestId);
            AVOSCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to start PushServer. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean sendClientCMDToPushService(String clientId, String dataAsString, BroadcastReceiver receiver, Conversation.AVIMOperation operation) {
        int requestId = WindTalker.getNextIMRequestId();
        if (receiver != null) {
            LocalBroadcastManager.getInstance((Context)AVOSCloud.getContext()).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(AVOSCloud.getContext(), PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (!StringUtil.isEmpty((String)dataAsString)) {
            i.putExtra("conversation.data", dataAsString);
        }
        i.putExtra("conversation.client", clientId);
        i.putExtra("conversation.requestId", requestId);
        i.putExtra("conversation.operation", operation.getCode());
        try {
            AVOSCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to startService. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean sendClientCMDToPushService(String clientId, String conversationId, int convType, String dataAsString, AVIMMessage message, AVIMMessageOption option, Conversation.AVIMOperation operation, BroadcastReceiver receiver) {
        int requestId = WindTalker.getNextIMRequestId();
        if (null != receiver) {
            LocalBroadcastManager.getInstance((Context)AVOSCloud.getContext()).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(AVOSCloud.getContext(), PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (!StringUtil.isEmpty((String)dataAsString)) {
            i.putExtra("conversation.data", dataAsString);
        }
        if (null != message) {
            i.putExtra("conversation.data", message.toJSONString());
            if (null != option) {
                i.putExtra("conversation.messageoption", option.toJSONString());
            }
        }
        i.putExtra("conversation.client", clientId);
        i.putExtra("convesration.id", conversationId);
        i.putExtra("conversation.type", convType);
        i.putExtra("conversation.operation", operation.getCode());
        i.putExtra("conversation.requestId", requestId);
        try {
            AVOSCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to startService. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    protected boolean sendClientCMDToPushService2(String clientId, String conversationId, int convType, AVIMMessage message, AVIMMessage message2, Conversation.AVIMOperation operation, BroadcastReceiver receiver) {
        int requestId = WindTalker.getNextIMRequestId();
        if (null != receiver) {
            LocalBroadcastManager.getInstance((Context)AVOSCloud.getContext()).registerReceiver(receiver, new IntentFilter(operation.getOperation() + requestId));
        }
        Intent i = new Intent(AVOSCloud.getContext(), PushService.class);
        i.setAction("com.avoscloud.im.v2.action");
        if (null != message) {
            i.putExtra("conversation.data", message.toJSONString());
        }
        if (null != message2) {
            i.putExtra("conversation.message.ex", message2.toJSONString());
        }
        i.putExtra("conversation.client", clientId);
        i.putExtra("convesration.id", conversationId);
        i.putExtra("conversation.type", convType);
        i.putExtra("conversation.operation", operation.getCode());
        i.putExtra("conversation.requestId", requestId);
        try {
            AVOSCloud.getContext().startService(IntentUtil.setupIntentFlags(i));
        }
        catch (Exception ex) {
            LOGGER.e("failed to startService. cause: " + ex.getMessage());
            return false;
        }
        return true;
    }

    public void onOperationCompleted(String clientId, String conversationId, int requestId, Conversation.AVIMOperation operation, Throwable throwable) {
        AVCallback callback;
        if (Conversation.AVIMOperation.CONVERSATION_QUERY == operation && null != (callback = RequestCache.getInstance().getRequestCallback(clientId, null, requestId))) {
            callback.internalDone(null, (AVException)AVIMException.wrapperAVException((Throwable)throwable));
            RequestCache.getInstance().cleanRequestCallback(clientId, null, requestId);
            return;
        }
        IntentUtil.sendIMLocalBroadcast(clientId, conversationId, requestId, throwable, operation);
    }

    public void onOperationCompletedEx(String clientId, String conversationId, int requestId, Conversation.AVIMOperation operation, HashMap<String, Object> resultData) {
        AVCallback callback;
        if (Conversation.AVIMOperation.CONVERSATION_QUERY == operation && null != (callback = RequestCache.getInstance().getRequestCallback(clientId, null, requestId))) {
            callback.internalDone(resultData, null);
            RequestCache.getInstance().cleanRequestCallback(clientId, null, requestId);
            return;
        }
        IntentUtil.sendMap2LocalBroadcase(clientId, conversationId, requestId, resultData, null, operation);
    }

    public void onLiveQueryCompleted(int requestId, Throwable throwable) {
        IntentUtil.sendLiveQueryLocalBroadcast(requestId, throwable);
    }

    public void onPushMessage(String message, String messageId) {
    }
}

