/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im;

import android.content.Context;
import cn.leancloud.AVLogger;
import cn.leancloud.AVOSCloud;
import cn.leancloud.im.AVIMEventHandler;
import cn.leancloud.im.AndroidDatabaseDelegateFactory;
import cn.leancloud.im.AndroidFileMetaAccessor;
import cn.leancloud.im.AndroidOperationTube;
import cn.leancloud.im.DatabaseDelegateFactory;
import cn.leancloud.im.FileMetaAccessor;
import cn.leancloud.im.InternalConfiguration;
import cn.leancloud.im.OperationTube;
import cn.leancloud.internal.ThreadModel;
import cn.leancloud.livequery.AVLiveQueryEventHandler;
import cn.leancloud.push.AVNotificationManager;
import cn.leancloud.push.AVPushMessageListener;
import cn.leancloud.push.AndroidNotificationManager;
import cn.leancloud.util.AndroidUtil;
import cn.leancloud.utils.LogUtil;

public class AndroidInitializer {
    private static AVLogger LOGGER = LogUtil.getLogger(AndroidInitializer.class);

    private static void init() {
        ThreadModel.MainThreadChecker checker = new ThreadModel.MainThreadChecker(){

            public boolean isMainThread() {
                return AndroidUtil.isMainThread();
            }
        };
        ThreadModel.ThreadShuttle shuttle = new ThreadModel.ThreadShuttle(){

            public void launch(Runnable runnable) {
                AVOSCloud.getHandler().post(runnable);
            }
        };
        LOGGER.i("[LeanCloud] initialize mainThreadChecker and threadShuttle within AVIMEventHandler.");
        AVIMEventHandler.setMainThreadChecker((ThreadModel.MainThreadChecker)checker, (ThreadModel.ThreadShuttle)shuttle);
        LOGGER.i("[LeanCloud] initialize mainThreadChecker and threadShuttle within AVLiveQueryEventHandler.");
        AVLiveQueryEventHandler.setMainThreadChecker((ThreadModel.MainThreadChecker)checker, (ThreadModel.ThreadShuttle)shuttle);
        AVPushMessageListener.getInstance().setNotificationManager((AVNotificationManager)AndroidNotificationManager.getInstance());
    }

    public static void init(Context context) {
        if (InternalConfiguration.getDatabaseDelegateFactory() != null) {
            LOGGER.i("[LeanCloud] re-initialize InternalConfiguration.");
            return;
        }
        AndroidInitializer.init();
        LOGGER.i("[LeanCloud] initialize InternalConfiguration within AVIMEventHandler.");
        InternalConfiguration.setFileMetaAccessor((FileMetaAccessor)new AndroidFileMetaAccessor());
        InternalConfiguration.setOperationTube((OperationTube)new AndroidOperationTube());
        InternalConfiguration.setDatabaseDelegateFactory((DatabaseDelegateFactory)new AndroidDatabaseDelegateFactory(context));
    }
}

