/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.im;

import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.webkit.MimeTypeMap;
import cn.leancloud.im.FileMetaAccessor;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class AndroidFileMetaAccessor
implements FileMetaAccessor {
    public Map<String, Object> mediaInfo(File file) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        try {
            MediaMetadataRetriever retriever = new MediaMetadataRetriever();
            retriever.setDataSource(file.getAbsolutePath());
            String durationString = retriever.extractMetadata(9);
            String format = this.getMimeType(file.getAbsolutePath());
            double duration = (double)Long.parseLong(durationString) / 1000.0;
            meta.put("format", format);
            meta.put("duration", duration);
        }
        catch (Exception e) {
            meta.put("duration", 0L);
            meta.put("format", "");
        }
        return meta;
    }

    public String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            type = mime.getMimeTypeFromExtension(extension);
        }
        return type;
    }

    public Map<String, Object> getImageMeta(File file) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        int width = options.outWidth;
        int height = options.outHeight;
        String type = options.outMimeType;
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("format", type);
        meta.put("width", width);
        meta.put("height", height);
        return meta;
    }
}

