/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVOSCloud;
import cn.leancloud.AVObject;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.core.AppConfiguration;
import cn.leancloud.im.AVIMOptions;
import cn.leancloud.im.AndroidDatabaseDelegateFactory;
import cn.leancloud.im.AndroidFileMetaAccessor;
import cn.leancloud.im.AndroidInitializer;
import cn.leancloud.im.AndroidOperationTube;
import cn.leancloud.im.DatabaseDelegateFactory;
import cn.leancloud.im.DirectlyOperationTube;
import cn.leancloud.im.FileMetaAccessor;
import cn.leancloud.im.InternalConfiguration;
import cn.leancloud.im.OperationTube;
import cn.leancloud.im.v2.AVIMClient;
import cn.leancloud.im.v2.AVIMMessage;
import cn.leancloud.im.v2.AVIMMessageOption;
import cn.leancloud.im.v2.Conversation;
import cn.leancloud.push.AVConnectivityListener;
import cn.leancloud.push.AVConnectivityReceiver;
import cn.leancloud.push.AVNotificationManager;
import cn.leancloud.push.AVPushMessageListener;
import cn.leancloud.push.AVShutdownListener;
import cn.leancloud.push.AVShutdownReceiver;
import cn.leancloud.push.NotifyUtil;
import cn.leancloud.session.AVConnectionManager;
import cn.leancloud.session.AVSession;
import cn.leancloud.session.AVSessionManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class PushService
extends Service {
    private static final AVLogger LOGGER = LogUtil.getLogger(PushService.class);
    static final String AV_PUSH_SERVICE_APPLICATION_ID = "AV_APPLICATION_ID";
    static final String AV_PUSH_SERVICE_DEFAULT_CALLBACK = "AV_DEFAULT_CALLBACK";
    static final String SERVICE_RESTART_ACTION = "com.avos.avoscloud.notify.action";
    private static boolean isNeedNotifyApplication = true;
    private AVConnectionManager connectionManager = null;
    private static Object connecting = new Object();
    private static volatile boolean isStarted = false;
    private static boolean isAutoWakeUp = true;
    static String DefaultChannelId = "";
    AVConnectivityReceiver connectivityReceiver;
    AVShutdownReceiver shutdownReceiver;
    DirectlyOperationTube directlyOperationTube;
    private Timer cleanupTimer = new Timer();
    private static Handler _installationSaveHandler;

    public void onCreate() {
        LOGGER.d("PushService#onCreate");
        super.onCreate();
        this.directlyOperationTube = new DirectlyOperationTube(true);
        this.connectionManager = AVConnectionManager.getInstance();
        new Thread(new Runnable(){

            @Override
            public void run() {
                PushService.this.connectionManager.startConnection();
            }
        }).start();
        this.connectivityReceiver = new AVConnectivityReceiver(new AVConnectivityListener(){
            private volatile boolean connectEstablished = false;

            @Override
            public void onMobile(Context context) {
                this.connectEstablished = true;
                PushService.this.connectionManager.startConnection();
                LOGGER.d("Connection resumed with Mobile...");
            }

            @Override
            public void onWifi(Context context) {
                this.connectEstablished = true;
                PushService.this.connectionManager.startConnection();
                LOGGER.d("Connection resumed with Wifi...");
            }

            @Override
            public void onOtherConnected(Context context) {
                LOGGER.d("Connectivity resumed with Others");
                this.connectEstablished = true;
                PushService.this.connectionManager.startConnection();
            }

            @Override
            public void onNotConnected(Context context) {
                if (!this.connectEstablished) {
                    LOGGER.d("Connectivity isn't established yet.");
                    return;
                }
                LOGGER.d("Connectivity broken");
                this.connectEstablished = false;
                if (AVIMOptions.getGlobalOptions().isResetConnectionWhileBroken()) {
                    PushService.this.cleanupTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!connectEstablished) {
                                LOGGER.d("Connection cleanup now.");
                                PushService.this.connectionManager.cleanup();
                            } else {
                                LOGGER.d("Connection has been resumed");
                            }
                        }
                    }, 3000L);
                }
            }
        });
        this.registerReceiver(this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.shutdownReceiver = new AVShutdownReceiver(new AVShutdownListener(){

            @Override
            public void onShutdown(Context context) {
                PushService.this.connectionManager.cleanup();
            }
        });
        this.registerReceiver(this.shutdownReceiver, new IntentFilter("android.intent.action.ACTION_SHUTDOWN"));
        isStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=5)
    public int onStartCommand(final Intent intent, int flags, int startId) {
        LOGGER.d("PushService#onStartCommand");
        this.notifyOtherApplication(null != intent ? intent.getAction() : null);
        boolean connected = AppConfiguration.getGlobalNetworkingDetector().isConnected();
        if (connected && !this.connectionManager.isConnectionEstablished()) {
            LOGGER.d("networking is fine and try to start connection to leancloud.");
            Object object = connecting;
            synchronized (object) {
                this.connectionManager.startConnection((AVCallback)new AVCallback<Integer>(){

                    protected void internalDone0(Integer resultCode, AVException exception) {
                        if (null == exception) {
                            PushService.this.processIMRequests(intent);
                        } else {
                            LOGGER.w("failed to start connection. cause:", (Throwable)exception);
                            PushService.this.processRequestsWithException(intent, exception);
                        }
                    }
                });
            }
        } else {
            this.processIMRequests(intent);
        }
        return 1;
    }

    public void onDestroy() {
        LOGGER.d("PushService#onDestroy");
        this.connectionManager.cleanup();
        this.unregisterReceiver(this.connectivityReceiver);
        this.unregisterReceiver(this.shutdownReceiver);
        isStarted = false;
        if (isAutoWakeUp && Build.VERSION.SDK_INT <= 25) {
            try {
                Intent i = new Intent(AVOSCloud.getContext(), PushService.class);
                i.addFlags(0x10000000);
                this.startService(i);
            }
            catch (Exception ex) {
                LOGGER.e("failed to start PushService. cause: " + ex.getMessage());
            }
        }
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        LOGGER.d("PushService#onBind");
        return null;
    }

    @TargetApi(value=14)
    public void onTaskRemoved(Intent rootIntent) {
        LOGGER.d("try to restart service on task Removed");
        if (isAutoWakeUp) {
            Intent restartServiceIntent = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
            restartServiceIntent.setPackage(this.getPackageName());
            PendingIntent restartServicePendingIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartServiceIntent, (int)0x8000000);
            AlarmManager alarmService = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
            alarmService.set(3, SystemClock.elapsedRealtime() + 500L, restartServicePendingIntent);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            super.onTaskRemoved(rootIntent);
        }
    }

    public static synchronized void subscribe(Context context, String channel, Class<? extends Activity> cls) {
        PushService.startServiceIfRequired(context, cls);
        String finalChannel = channel;
        AVInstallation.getCurrentInstallation().addUnique("channels", (Object)finalChannel);
        _installationSaveHandler.sendMessage(Message.obtain());
        if (cls != null) {
            AVNotificationManager manager = AVPushMessageListener.getInstance().getNotificationManager();
            manager.addDefaultPushCallback(channel, cls.getName());
            if (manager.getDefaultPushCallback(AVOSCloud.getApplicationId()) == null) {
                manager.addDefaultPushCallback(AVOSCloud.getApplicationId(), cls.getName());
            }
        }
    }

    public static void setNotificationIcon(int icon) {
        AVPushMessageListener.getInstance().getNotificationManager().setNotificationIcon(icon);
    }

    public static void startIfRequired(Context context) {
        PushService.startServiceIfRequired(context, null);
    }

    public static void setDefaultPushCallback(Context context, Class<? extends Activity> cls) {
        LOGGER.d("setDefaultPushCallback cls=" + cls.getName());
        PushService.startServiceIfRequired(context, cls);
        AVPushMessageListener.getInstance().getNotificationManager().addDefaultPushCallback(AVOSCloud.getApplicationId(), cls.getName());
    }

    public static void setAutoWakeUp(boolean isAutoWakeUp) {
        PushService.isAutoWakeUp = isAutoWakeUp;
    }

    @TargetApi(value=26)
    public static void setDefaultChannelId(Context context, String channelId) {
        DefaultChannelId = channelId;
        if (Build.VERSION.SDK_INT <= 25) {
            return;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            String name = context.getPackageName();
            String description = "PushNotification";
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)name, importance);
            channel.setDescription(description);
            notificationManager.createNotificationChannel(channel);
        }
        catch (Exception ex) {
            LOGGER.w("failed to create NotificationChannel, then perhaps PushNotification doesn't work well on Android O and newer version.");
        }
    }

    public static synchronized void unsubscribe(Context context, String channel) {
        if (channel == null) {
            return;
        }
        AVPushMessageListener.getInstance().getNotificationManager().removeDefaultPushCallback(channel);
        final String finalChannel = channel;
        if (StringUtil.isEmpty((String)AVInstallation.getCurrentInstallation().getObjectId())) {
            AVInstallation.getCurrentInstallation().saveInBackground().subscribe((Observer)new Observer<AVObject>(){

                public void onSubscribe(Disposable d) {
                }

                public void onNext(AVObject avObject) {
                    AVInstallation.getCurrentInstallation().removeAll("channels", Arrays.asList(finalChannel));
                    _installationSaveHandler.sendMessage(Message.obtain());
                }

                public void onError(Throwable e) {
                    LOGGER.w(e);
                }

                public void onComplete() {
                }
            });
        } else {
            AVInstallation.getCurrentInstallation().removeAll("channels", Arrays.asList(finalChannel));
            _installationSaveHandler.sendMessage(Message.obtain());
        }
    }

    private static void startServiceIfRequired(Context context, Class<? extends Activity> cls) {
        if (isStarted) {
            return;
        }
        if (context == null) {
            LOGGER.d("context is null");
            return;
        }
        if (0 != context.checkCallingOrSelfPermission("android.permission.INTERNET")) {
            LOGGER.e("Please add <uses-permission android:name=\"android.permission.INTERNET\"/> in your AndroidManifest file");
            return;
        }
        if (!AppConfiguration.getGlobalNetworkingDetector().isConnected()) {
            LOGGER.d("No network available now");
            return;
        }
        if (!PushService.isPushServiceAvailable(context, PushService.class)) {
            LOGGER.e("Please add <service android:name=\"cn.leancloud.push.PushService\"/> in your AndroidManifest file");
            return;
        }
        InternalConfiguration.setFileMetaAccessor((FileMetaAccessor)new AndroidFileMetaAccessor());
        InternalConfiguration.setOperationTube((OperationTube)new AndroidOperationTube());
        InternalConfiguration.setDatabaseDelegateFactory((DatabaseDelegateFactory)new AndroidDatabaseDelegateFactory(context));
        PushService.startService(context, cls);
    }

    private static boolean isPushServiceAvailable(Context context, Class cls) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent(context, cls), 65536);
        return resolveInfo.size() > 0;
    }

    private static synchronized void startService(Context context, final Class cls) {
        final Context finalContext = context;
        new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.d("Start service");
                try {
                    Intent intent = new Intent(finalContext, PushService.class);
                    intent.putExtra(PushService.AV_PUSH_SERVICE_APPLICATION_ID, AVOSCloud.getApplicationId());
                    if (cls != null) {
                        intent.putExtra(PushService.AV_PUSH_SERVICE_DEFAULT_CALLBACK, cls.getName());
                    }
                    finalContext.startService(intent);
                }
                catch (Exception ex) {
                    LOGGER.e("failed to start PushService. cause: " + ex.getMessage());
                }
            }
        }).start();
    }

    private void notifyOtherApplication(String action) {
        if (isNeedNotifyApplication && !SERVICE_RESTART_ACTION.equals(action)) {
            isNeedNotifyApplication = false;
            try {
                ServiceInfo info = this.getApplicationContext().getPackageManager().getServiceInfo(new ComponentName(this.getApplicationContext(), PushService.class), 0);
                if (info.exported) {
                    NotifyUtil.notifyHandler.sendEmptyMessage(1024);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    private void processIMRequests(Intent intent) {
        LOGGER.d("processIMRequests...");
        if (null == intent) {
            LOGGER.w("intent is null, invalid operation.");
            return;
        }
        if ("com.avoscloud.im.v2.action".equalsIgnoreCase(intent.getAction())) {
            this.processIMRequestsFromClient(intent);
        } else {
            this.processLiveQueryRequestsFromClient(intent);
        }
    }

    private void processIMRequestsFromClient(Intent intent) {
        LOGGER.d("processIMRequestsFromClient...");
        String clientId = intent.getExtras().getString("conversation.client");
        int requestId = intent.getExtras().getInt("conversation.requestId");
        Conversation.AVIMOperation operation = Conversation.AVIMOperation.getAVIMOperation((int)intent.getExtras().getInt("conversation.operation"));
        String keyData = intent.getExtras().getString("conversation.data");
        AVIMMessage existedMessage = null;
        Map param = null;
        if (!StringUtil.isEmpty((String)keyData)) {
            param = (Map)JSON.parseObject((String)keyData, Map.class);
        }
        String conversationId = intent.getExtras().getString("convesration.id");
        int convType = intent.getExtras().getInt("conversation.type", 1);
        switch (operation) {
            case CLIENT_OPEN: {
                String tag = (String)param.get("client.tag");
                String userSession = (String)param.get("client.userSession");
                boolean reConnection = (Boolean)param.get("client.reconnect");
                this.directlyOperationTube.openClientDirectly(clientId, tag, userSession, reConnection, requestId);
                break;
            }
            case CLIENT_DISCONNECT: {
                this.directlyOperationTube.closeClientDirectly(clientId, requestId);
                break;
            }
            case CLIENT_REFRESH_TOKEN: {
                this.directlyOperationTube.renewSessionTokenDirectly(clientId, requestId);
                break;
            }
            case CLIENT_STATUS: {
                AVSession session = AVSessionManager.getInstance().getOrCreateSession(clientId);
                AVIMClient.AVIMClientStatus status = AVIMClient.AVIMClientStatus.AVIMClientStatusNone;
                status = AVSession.Status.Opened != session.getCurrentStatus() ? AVIMClient.AVIMClientStatus.AVIMClientStatusPaused : AVIMClient.AVIMClientStatus.AVIMClientStatusOpened;
                HashMap<String, Integer> bundle = new HashMap<String, Integer>();
                bundle.put("callbackClientStatus", status.getCode());
                InternalConfiguration.getOperationTube().onOperationCompletedEx(clientId, null, requestId, Conversation.AVIMOperation.CLIENT_STATUS, bundle);
                break;
            }
            case CLIENT_ONLINE_QUERY: {
                List idList = (List)param.get("client.oneline");
                this.directlyOperationTube.queryOnlineClientsDirectly(clientId, idList, requestId);
                break;
            }
            case CONVERSATION_CREATION: {
                List members = (List)param.get("conversation.member");
                boolean isUnique = false;
                if (param.containsKey("conversation.unique")) {
                    isUnique = (Boolean)param.get("conversation.unique");
                }
                boolean isTransient = false;
                if (param.containsKey("conversation.transient")) {
                    isTransient = (Boolean)param.get("conversation.transient");
                }
                boolean isTemp = false;
                if (param.containsKey("conversation.temp")) {
                    isTemp = (Boolean)param.get("conversation.temp");
                }
                int tempTTL = isTemp ? (Integer)param.get("conversation.tempTTL") : 0;
                Map attributes = (Map)param.get("conversation.attributes");
                this.directlyOperationTube.createConversationDirectly(clientId, members, attributes, isTransient, isUnique, isTemp, tempTTL, requestId);
                break;
            }
            case CONVERSATION_QUERY: {
                this.directlyOperationTube.queryConversationsDirectly(clientId, keyData, requestId);
                break;
            }
            case CONVERSATION_UPDATE: {
                this.directlyOperationTube.updateConversationDirectly(clientId, conversationId, convType, param, requestId);
                break;
            }
            case CONVERSATION_QUIT: 
            case CONVERSATION_JOIN: 
            case CONVERSATION_MUTE: 
            case CONVERSATION_UNMUTE: {
                this.directlyOperationTube.participateConversationDirectly(clientId, conversationId, convType, param, operation, requestId);
                break;
            }
            case CONVERSATION_ADD_MEMBER: 
            case CONVERSATION_RM_MEMBER: 
            case CONVERSATION_MUTE_MEMBER: 
            case CONVERSATION_UNMUTE_MEMBER: 
            case CONVERSATION_UNBLOCK_MEMBER: 
            case CONVERSATION_BLOCK_MEMBER: 
            case CONVERSATION_PROMOTE_MEMBER: 
            case CONVERSATION_BLOCKED_MEMBER_QUERY: 
            case CONVERSATION_MUTED_MEMBER_QUERY: 
            case CONVERSATION_FETCH_RECEIPT_TIME: 
            case CONVERSATION_MEMBER_COUNT_QUERY: {
                this.directlyOperationTube.processMembersDirectly(clientId, conversationId, convType, keyData, operation, requestId);
                break;
            }
            case CONVERSATION_MESSAGE_QUERY: {
                this.directlyOperationTube.queryMessagesDirectly(clientId, conversationId, convType, keyData, Conversation.AVIMOperation.CONVERSATION_MESSAGE_QUERY, requestId);
                break;
            }
            case CONVERSATION_READ: {
                this.directlyOperationTube.markConversationReadDirectly(clientId, conversationId, convType, param, requestId);
                break;
            }
            case CONVERSATION_RECALL_MESSAGE: {
                existedMessage = AVIMMessage.parseJSONString((String)keyData);
                this.directlyOperationTube.recallMessageDirectly(clientId, convType, existedMessage, requestId);
                break;
            }
            case CONVERSATION_SEND_MESSAGE: {
                existedMessage = AVIMMessage.parseJSONString((String)keyData);
                AVIMMessageOption option = AVIMMessageOption.parseJSONString((String)intent.getExtras().getString("conversation.messageoption"));
                this.directlyOperationTube.sendMessageDirectly(clientId, conversationId, convType, existedMessage, option, requestId);
                break;
            }
            case CONVERSATION_UPDATE_MESSAGE: {
                existedMessage = AVIMMessage.parseJSONString((String)keyData);
                AVIMMessage secondMessage = AVIMMessage.parseJSONString((String)intent.getExtras().getString("conversation.message.ex"));
                this.directlyOperationTube.updateMessageDirectly(clientId, convType, existedMessage, secondMessage, requestId);
                break;
            }
            default: {
                LOGGER.w("not support operation: " + operation);
            }
        }
    }

    private void processRequestsWithException(Intent intent, AVException exception) {
        if (intent != null && "com.avoscloud.im.v2.action".equalsIgnoreCase(intent.getAction())) {
            int operationCode = intent.getExtras().getInt("conversation.operation");
            String clientId = intent.getExtras().getString("conversation.client");
            String conversationId = intent.getExtras().getString("convesration.id");
            int requestId = intent.getExtras().getInt("conversation.requestId");
            InternalConfiguration.getOperationTube().onOperationCompleted(clientId, conversationId, requestId, Conversation.AVIMOperation.getAVIMOperation((int)operationCode), (Throwable)exception);
        }
    }

    private void processLiveQueryRequestsFromClient(Intent intent) {
    }

    static {
        AndroidInitializer.init();
        _installationSaveHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message m) {
                AVInstallation.getCurrentInstallation().saveInBackground().subscribe((Observer)new Observer<AVObject>(){

                    public void onSubscribe(Disposable d) {
                    }

                    public void onNext(AVObject avObject) {
                    }

                    public void onError(Throwable e) {
                        if (e != null && "already has one request sending".equals(e.getMessage())) {
                            _installationSaveHandler.removeMessages(0);
                            Message m = Message.obtain();
                            m.what = 0;
                            _installationSaveHandler.sendMessageDelayed(m, 2000L);
                        }
                    }

                    public void onComplete() {
                    }
                });
            }
        };
    }
}

