/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import cn.leancloud.AVLogger;
import cn.leancloud.AVOSCloud;
import cn.leancloud.push.AVNotificationManager;
import cn.leancloud.push.PushService;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import java.util.Random;

public class AndroidNotificationManager
extends AVNotificationManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AndroidNotificationManager.class);
    private static final String PUSH_INTENT_KEY = "com.avoscloud.push";
    private static final Random random = new Random();
    private static final AndroidNotificationManager INSTANCE = new AndroidNotificationManager();

    public static AndroidNotificationManager getInstance() {
        return INSTANCE;
    }

    private AndroidNotificationManager() {
    }

    private Intent buildUpdateIntent(String channel, String msg, String action) {
        Intent updateIntent = new Intent();
        if (action != null) {
            updateIntent.setAction(action);
        }
        updateIntent.putExtra(PUSH_INTENT_KEY, 1);
        updateIntent.putExtra("com.avos.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avoscloud.Channel", channel);
        updateIntent.putExtra("com.avos.avoscloud.Data", msg);
        updateIntent.putExtra("com.avoscloud.Data", msg);
        updateIntent.setPackage(AVOSCloud.getContext().getPackageName());
        return updateIntent;
    }

    void sendNotification(String from, String msg) throws IllegalArgumentException {
        Intent resultIntent = this.buildUpdateIntent(from, msg, null);
        this.sendNotification(from, msg, resultIntent);
    }

    @TargetApi(value=26)
    private void sendNotification(String from, String msg, Intent resultIntent) {
        String clsName = this.getDefaultPushCallback(from);
        if (StringUtil.isEmpty((String)clsName)) {
            throw new IllegalArgumentException("No default callback found, did you forget to invoke setDefaultPushCallback?");
        }
        Context context = AVOSCloud.getContext();
        int lastIndex = clsName.lastIndexOf(".");
        if (lastIndex != -1) {
            int notificationId = random.nextInt();
            ComponentName cn = new ComponentName(context, clsName);
            resultIntent.setComponent(cn);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)notificationId, (Intent)resultIntent, (int)0);
            String sound = this.getSound(msg);
            Notification notification = null;
            if (Build.VERSION.SDK_INT <= 25) {
                NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)this.getTitle(msg)).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setContentText((CharSequence)AndroidNotificationManager.getText((String)msg));
                notification = mBuilder.build();
            } else {
                Notification.Builder builder = new Notification.Builder(context).setSmallIcon(this.getNotificationIcon()).setContentTitle((CharSequence)this.getTitle(msg)).setAutoCancel(true).setContentIntent(contentIntent).setDefaults(3).setContentText((CharSequence)AndroidNotificationManager.getText((String)msg)).setChannelId(PushService.DefaultChannelId);
                notification = builder.build();
            }
            if (sound != null && sound.trim().length() > 0) {
                notification.sound = Uri.parse((String)("android.resource://" + sound));
            }
            NotificationManager manager = (NotificationManager)context.getSystemService("notification");
            manager.notify(notificationId, notification);
        } else {
            LOGGER.e("Class name is invalid, which must contain '.': " + clsName);
        }
    }

    String getApplicationName() {
        ApplicationInfo ai;
        Context context = AVOSCloud.getContext();
        PackageManager pm = context.getPackageManager();
        try {
            ai = pm.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        String applicationName = ai != null ? pm.getApplicationLabel(ai) : "Notification";
        return applicationName;
    }

    void sendBroadcast(String channel, String msg, String action) {
        Intent updateIntent = this.buildUpdateIntent(channel, msg, action);
        LOGGER.d("action: " + updateIntent.getAction());
        AVOSCloud.getContext().sendBroadcast(updateIntent);
        LOGGER.d("sent broadcast");
    }

    public void processMixPushMessage(String message) {
        if (!StringUtil.isEmpty((String)message)) {
            String channel = AndroidNotificationManager.getChannel((String)message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.getApplicationId();
            }
            String action = AndroidNotificationManager.getAction((String)message);
            boolean isSlient = AndroidNotificationManager.getSilent((String)message);
            if (action != null) {
                this.sendBroadcast(channel, message, action);
            } else if (!isSlient) {
                this.sendNotification(channel, message);
            } else {
                LOGGER.e("ignore push silent message: " + message);
            }
        }
    }

    public void porcessMixNotificationArrived(String message, String action) {
        if (!StringUtil.isEmpty((String)message) && !StringUtil.isEmpty((String)action)) {
            String channel = AndroidNotificationManager.getChannel((String)message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.getApplicationId();
            }
            this.sendNotificationBroadcast(channel, message, action);
        }
    }

    public void processMixNotification(String message, String defaultAction) {
        if (StringUtil.isEmpty((String)message)) {
            LOGGER.e("message is empty, ignore.");
        } else {
            String action;
            String channel = AndroidNotificationManager.getChannel((String)message);
            if (channel == null || !this.containsDefaultPushCallback(channel)) {
                channel = AVOSCloud.getApplicationId();
            }
            if (null != (action = AndroidNotificationManager.getAction((String)message))) {
                this.sendNotificationBroadcast(channel, message, defaultAction);
            } else {
                String clsName = this.getDefaultPushCallback(channel);
                if (StringUtil.isEmpty((String)clsName)) {
                    LOGGER.e("className is empty, ignore.");
                } else {
                    Intent intent = this.buildUpdateIntent(channel, message, null);
                    ComponentName cn = new ComponentName(AVOSCloud.getContext(), clsName);
                    intent.setComponent(cn);
                    intent.setFlags(0x20000000);
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)AVOSCloud.getContext(), (int)0, (Intent)intent, (int)0x8000000);
                    try {
                        pendingIntent.send();
                    }
                    catch (PendingIntent.CanceledException e) {
                        LOGGER.e("Ocurred PendingIntent.CanceledException", (Throwable)e);
                    }
                }
            }
        }
    }

    public void processGcmMessage(String channel, String action, String message) {
        if (channel == null || !this.containsDefaultPushCallback(channel)) {
            channel = AVOSCloud.getApplicationId();
            if (action != null) {
                this.sendBroadcast(channel, message, action);
            } else {
                this.sendNotification(channel, message);
            }
        }
    }

    private void sendNotificationBroadcast(String channel, String msg, String action) {
        Intent updateIntent = this.buildUpdateIntent(channel, msg, action);
        LOGGER.d("action: " + updateIntent.getAction());
        AVOSCloud.getContext().sendBroadcast(updateIntent);
        LOGGER.d("sent broadcast");
    }
}

