/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.vivo;

import android.app.Application;
import android.content.Context;
import cn.leancloud.AVException;
import cn.leancloud.AVInstallation;
import cn.leancloud.AVLogger;
import cn.leancloud.AVOSCloud;
import cn.leancloud.callback.AVCallback;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import com.vivo.push.util.VivoPushException;
import io.reactivex.Observer;
import java.util.List;

public class AVMixPushManager {
    private static final AVLogger LOGGER = LogUtil.getLogger(AVMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String vivoDeviceProfile = "";

    public static boolean registerVIVOPush(Application application) {
        return AVMixPushManager.registerVIVOPush(application, "");
    }

    public static boolean registerVIVOPush(Application application, String profile) {
        vivoDeviceProfile = profile;
        PushClient client = PushClient.getInstance((Context)application.getApplicationContext());
        try {
            client.checkManifest();
            client.initialize();
            return true;
        }
        catch (VivoPushException ex) {
            AVMixPushManager.printErrorLog("register error, mainifest is incomplete! details=" + ex.getMessage());
            return false;
        }
    }

    public static void turnOffVIVOPush(final AVCallback<Boolean> callback) {
        PushClient.getInstance((Context)AVOSCloud.getContext()).turnOffPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null == callback) {
                    AVException exception = null;
                    if (0 != state) {
                        exception = new AVException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static void turnOnVIVOPush(final AVCallback<Boolean> callback) {
        PushClient.getInstance((Context)AVOSCloud.getContext()).turnOnPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null == callback) {
                    AVException exception = null;
                    if (0 != state) {
                        exception = new AVException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static boolean isSupportVIVOPush(Context context) {
        PushClient client = PushClient.getInstance((Context)context);
        if (null == client) {
            return false;
        }
        return client.isSupport();
    }

    public static void bindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).bindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void unbindVIVOAlias(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).unBindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static String getVIVOAlias(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getAlias();
    }

    public static void setVIVOTopic(Context context, String topic, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).setTopic(topic, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void delVIVOTopic(Context context, String alias, final AVCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new AVException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).delTopic(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        AVException exception = null;
                        if (0 != state) {
                            exception = new AVException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static List<String> getVIVOTopics(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getTopics();
    }

    public static void unRegisterMixPush() {
        AVInstallation installation = AVInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(AVException e) {
                    if (null != e) {
                        AVMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

