/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.oppo;

import android.content.Context;
import cn.leancloud.LCException;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.LCOPPOPushAdapter;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.heytap.msp.push.callback.IGetAppNotificationCallBackService;
import com.heytap.msp.push.callback.ISetAppNotificationCallBackService;
import com.heytap.msp.push.mode.DataMessage;
import io.reactivex.Observer;
import java.util.List;

public class LCMixPushManager {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String oppoDeviceProfile = "";

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, LCOPPOPushAdapter callback) {
        if (null == context || StringUtil.isEmpty((String)appKey) || StringUtil.isEmpty((String)appSecret)) {
            LOGGER.e("invalid parameter. context=" + context + ", appKey=" + appKey);
            return false;
        }
        HeytapPushManager.init((Context)context, (boolean)true);
        if (!LCMixPushManager.isSupportOppoPush(context)) {
            LOGGER.e("current device doesn't support OPPO Push.");
            return false;
        }
        HeytapPushManager.register((Context)context, (String)appKey, (String)appSecret, (ICallBackResultService)callback);
        HeytapPushManager.requestNotificationPermission();
        return true;
    }

    public static boolean registerOppoPush(Context context, String appKey, String appSecret, String profile, LCOPPOPushAdapter callback) {
        oppoDeviceProfile = profile;
        return LCMixPushManager.registerOppoPush(context, appKey, appSecret, callback);
    }

    public static boolean isSupportOppoPush(Context context) {
        return HeytapPushManager.isSupportPush((Context)context);
    }

    public static String getRegisterID() {
        return HeytapPushManager.getRegisterID();
    }

    public static void setRegisterID(String registerID) {
        HeytapPushManager.setRegisterID((String)registerID);
    }

    public static void pauseOppoPush() {
        HeytapPushManager.pausePush();
    }

    public static void resumeOppoPush() {
        HeytapPushManager.resumePush();
    }

    public static void enableAppNotificationSwitch(ISetAppNotificationCallBackService service) {
        HeytapPushManager.enableAppNotificationSwitch((ISetAppNotificationCallBackService)service);
    }

    public static void disableAppNotificationSwitch(ISetAppNotificationCallBackService service) {
        HeytapPushManager.disableAppNotificationSwitch((ISetAppNotificationCallBackService)service);
    }

    public static void getAppNotificationSwitch(IGetAppNotificationCallBackService service) {
        HeytapPushManager.getAppNotificationSwitch((IGetAppNotificationCallBackService)service);
    }

    public static void setOppoPushTime(List<Integer> weekDays, int startHour, int startMinute, int endHour, int endMinute) {
        HeytapPushManager.setPushTime(weekDays, (int)startHour, (int)startMinute, (int)endHour, (int)endMinute);
    }

    @Deprecated
    public static void setOppoAliases(List<String> aliases) {
    }

    @Deprecated
    public static void unsetOppoAlias(String alias) {
    }

    @Deprecated
    public static void getOppoAliases() {
    }

    @Deprecated
    public static void setOppoUserAccount(String account) {
    }

    @Deprecated
    public static void unsetOppoUserAccouts(List<String> accounts) {
    }

    @Deprecated
    public static void getOppoUserAccounts() {
    }

    @Deprecated
    public static void setOppoTags(List<String> tags) {
    }

    @Deprecated
    public static void unsetOppoTags(List<String> tags) {
    }

    @Deprecated
    public static void getOppoTags() {
    }

    public static void getOppoPushStatus() {
        HeytapPushManager.getPushStatus();
    }

    public static void getOppoNotificationStatus() {
        HeytapPushManager.getNotificationStatus();
    }

    public static void setNotificationType(int notificationType) {
        HeytapPushManager.setNotificationType((int)notificationType);
    }

    public static void clearNotificationType() {
        HeytapPushManager.clearNotificationType();
    }

    public static void clearNotifications() {
        HeytapPushManager.clearNotifications();
    }

    public static String getMcsPackageName(Context context) {
        return HeytapPushManager.getMcsPackageName((Context)context);
    }

    public static String getReceiveSdkAction(Context context) {
        return HeytapPushManager.getReceiveSdkAction((Context)context);
    }

    public static void statisticEvent(Context context, String eventId, DataMessage message) {
        HeytapPushManager.statisticEvent((Context)context, (String)eventId, (DataMessage)message);
    }

    public static void unRegisterMixPush() {
        LCInstallation installation = LCInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(LCException e) {
                    if (null != e) {
                        LCMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
        HeytapPushManager.unRegister();
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

