/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import cn.leancloud.LCException;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.oppo.LCMixPushManager;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.heytap.msp.push.callback.ICallBackResultService;
import io.reactivex.Observer;

public class LCOPPOPushAdapter
implements ICallBackResultService {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCOPPOPushAdapter.class);
    private static final String VENDOR_OPPO = "oppo";

    private void updateLCInstallation(String registerId) {
        if (!StringUtil.isEmpty((String)registerId)) {
            String localProfile;
            LCInstallation installation = LCInstallation.getCurrentInstallation();
            if (!VENDOR_OPPO.equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)VENDOR_OPPO);
            }
            if (!registerId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)registerId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(LCMixPushManager.oppoDeviceProfile)) {
                installation.put("deviceProfile", (Object)LCMixPushManager.oppoDeviceProfile);
            }
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(LCException e) {
                    if (null != e) {
                        LOGGER.e("update installation error!", (Throwable)e);
                    } else {
                        LOGGER.d("oppo push registration successful!");
                    }
                }
            }));
        }
    }

    public void onRegister(int responseCode, String registerID) {
        if (responseCode != 0) {
            LOGGER.e("failed to register device. errorCode: " + responseCode);
            return;
        }
        if (StringUtil.isEmpty((String)registerID)) {
            LOGGER.e("oppo register id is empty.");
            return;
        }
        this.updateLCInstallation(registerID);
    }

    public void onUnRegister(int responseCode) {
        if (responseCode != 0) {
            LOGGER.e("failed to unregister device. errorCode: " + responseCode);
        } else {
            LOGGER.i("succeeded to unregister device.");
        }
    }

    public void onSetPushTime(int responseCode, String var2) {
        if (responseCode != 0) {
            LOGGER.e("failed to setPushTime. errorCode: " + responseCode);
        } else {
            LOGGER.i("succeeded to setPushTime.");
        }
    }

    public void onGetPushStatus(int responseCode, int status) {
        if (responseCode != 0) {
            LOGGER.e("failed to getPushStatus. errorCode: " + responseCode);
        } else {
            LOGGER.i("succeeded to getPushStatus.");
        }
    }

    public void onGetNotificationStatus(int responseCode, int status) {
        if (responseCode != 0) {
            LOGGER.e("failed to getNotificationStatus. errorCode: " + responseCode);
        } else {
            LOGGER.i("succeeded to getNotificationStatus.");
        }
    }

    public void onError(int i, String s) {
        LOGGER.w("error occurred. code: " + i + ", cause: " + s);
    }
}

